/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.fpx.JaiI18N;
import com.sun.media.jai.codecimpl.fpx.Property;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;

class PropertySet {
    private static final int TYPE_VT_EMPTY = -1;
    private static final int TYPE_VT_NULL = -1;
    private static final int TYPE_VT_I2 = 2;
    private static final int TYPE_VT_I4 = 3;
    private static final int TYPE_VT_R4 = -1;
    private static final int TYPE_VT_R8 = -1;
    private static final int TYPE_VT_CY = -1;
    private static final int TYPE_VT_DATE = -1;
    private static final int TYPE_VT_BSTR = -1;
    private static final int TYPE_VT_ERROR = -1;
    private static final int TYPE_VT_BOOL = -1;
    private static final int TYPE_VT_VARIANT = -1;
    private static final int TYPE_VT_UI1 = -1;
    private static final int TYPE_VT_UI2 = -1;
    private static final int TYPE_VT_UI4 = 19;
    private static final int TYPE_VT_I8 = -1;
    private static final int TYPE_VT_UI8 = -1;
    private static final int TYPE_VT_LPSTR = 30;
    private static final int TYPE_VT_LPWSTR = 31;
    private static final int TYPE_VT_FILETIME = 64;
    private static final int TYPE_VT_BLOB = 65;
    private static final int TYPE_VT_STREAM = -1;
    private static final int TYPE_VT_STORAGE = -1;
    private static final int TYPE_VT_STREAMED_OBJECT = -1;
    private static final int TYPE_VT_STORED_OBJECT = -1;
    private static final int TYPE_VT_BLOB_OBJECT = -1;
    private static final int TYPE_VT_CF = 71;
    private static final int TYPE_VT_CLSID = 72;
    private static final int TYPE_VT_VECTOR = 4096;
    SeekableStream stream;
    Hashtable properties = new Hashtable();

    public PropertySet(SeekableStream seekableStream) throws IOException {
        this.stream = seekableStream;
        seekableStream.seek(44L);
        int n = seekableStream.readIntLE();
        seekableStream.seek(n);
        int n2 = seekableStream.readIntLE();
        int n3 = seekableStream.readIntLE();
        int n4 = 0;
        while (n4 < n3) {
            seekableStream.seek(n + 8 * n4 + 8);
            int n5 = seekableStream.readIntLE();
            int n6 = seekableStream.readIntLE();
            seekableStream.seek(n + n6);
            int n7 = seekableStream.readIntLE();
            Property property = new Property(n7, n + n6 + 4);
            this.properties.put(new Integer(n5), property);
            ++n4;
        }
    }

    public boolean hasProperty(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        return property != null;
    }

    public int getI4(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readIntLE();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public int getUI1(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readUnsignedByte();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public int getUI2(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readUnsignedShortLE();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
    }

    public long getUI4(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
    }

    public long getUI4(int n, long l) {
        Property property = (Property)this.properties.get(new Integer(n));
        if (property == null) {
            return l;
        }
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readUnsignedIntLE();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
    }

    public String getLPSTR(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        if (property == null) {
            return null;
        }
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            int n3 = this.stream.readIntLE();
            StringBuffer stringBuffer = new StringBuffer(n3);
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append((char)this.stream.read());
                ++n4;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getLPWSTR(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            int n3 = this.stream.readIntLE();
            StringBuffer stringBuffer = new StringBuffer(n3);
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append(this.stream.readCharLE());
                ++n4;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public float getR4(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            return this.stream.readFloatLE();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1.0f;
        }
    }

    public Date getDate(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public Date getFiletime(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public byte[] getBlob(int n) {
        Property property = (Property)this.properties.get(new Integer(n));
        try {
            int n2 = property.getOffset();
            this.stream.seek(n2);
            int n3 = this.stream.readIntLE();
            byte[] byArray = new byte[n3];
            this.stream.seek(n2 + 4);
            this.stream.readFully(byArray);
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public int[] getUI1Vector(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public int[] getUI2Vector(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public long[] getUI4Vector(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public float[] getR4Vector(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }

    public String[] getLPWSTRVector(int n) {
        throw new RuntimeException(JaiI18N.getString("PropertySet0"));
    }
}

