/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.Geometry;
import com.esri.sde.sdk.geom.Linestring;
import com.esri.sde.sdk.geom.Point;
import com.esri.sde.sdk.geom.SeCoordRef;
import com.esri.sde.sdk.geom.SeCurve;
import com.esri.sde.sdk.geom.SeEnvelope;
import com.esri.sde.sdk.geom.SeGeometry;
import com.esri.sde.sdk.geom.SePoint;
import com.esri.sde.sdk.geom.SgEnvelope;
import com.esri.sde.sdk.geom.SgSDEShape;
import com.esri.sde.sdk.geom.SgShapeException;
import com.esri.sde.sdk.geom.SgShapePoint;
import java.io.Serializable;

public class SeLinestring
extends SeCurve
implements Linestring,
Cloneable,
Serializable {
    protected SgShapePoint[] a;
    protected double[] b;
    protected double[] c;

    public SeLinestring() {
    }

    public SeLinestring(SePoint[] sePointArray) {
        if (sePointArray[0].d && sePointArray[0].isMeasured()) {
            this.a = new SgShapePoint[sePointArray.length];
            this.c = new double[sePointArray.length];
            this.b = new double[sePointArray.length];
            int n2 = 0;
            while (n2 < sePointArray.length) {
                this.a[n2] = new SgShapePoint(sePointArray[n2].X(), sePointArray[n2].Y());
                this.c[n2] = sePointArray[n2].getZ();
                this.b[n2] = sePointArray[n2].getM();
                ++n2;
            }
        } else if (sePointArray[0].isMeasured()) {
            this.a = new SgShapePoint[sePointArray.length];
            this.b = new double[sePointArray.length];
            int n3 = 0;
            while (n3 < sePointArray.length) {
                this.a[n3] = new SgShapePoint(sePointArray[n3].X(), sePointArray[n3].Y());
                this.b[n3] = sePointArray[n3].getM();
                ++n3;
            }
        } else if (sePointArray[0].is3D()) {
            this.a = new SgShapePoint[sePointArray.length];
            this.c = new double[sePointArray.length];
            int n4 = 0;
            while (n4 < sePointArray.length) {
                this.a[n4] = new SgShapePoint(sePointArray[n4].X(), sePointArray[n4].Y());
                this.c[n4] = sePointArray[n4].getZ();
                ++n4;
            }
        } else {
            this.a = new SgShapePoint[sePointArray.length];
            int n5 = 0;
            while (n5 < sePointArray.length) {
                this.a[n5] = new SgShapePoint(sePointArray[n5].X(), sePointArray[n5].Y());
                ++n5;
            }
        }
    }

    public SeLinestring(SeCoordRef seCoordRef, SePoint[] sePointArray) {
        if (sePointArray[0].is3D() && sePointArray[0].isMeasured()) {
            int n2;
            this.k = n2 = sePointArray.length;
            this.a = new SgShapePoint[n2];
            this.c = new double[n2];
            this.b = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.a[n3] = new SgShapePoint(sePointArray[n3].X(), sePointArray[n3].Y());
                this.c[n3] = sePointArray[n3].b;
                this.b[n3] = sePointArray[n3].c;
                ++n3;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgSDEShape sgSDEShape = this.a();
                try {
                    sgSDEShape.a(n2, 1, null, this.a, this.c, this.b, true);
                }
                catch (SgShapeException sgShapeException) {
                    if (sgShapeException.getErrorCode() == -2035) {
                        sgSDEShape.b(n2, 1, null, this.a, this.c, this.b, true);
                    }
                    sgShapeException.printStackTrace();
                }
                sgSDEShape.y();
                this.a(sgSDEShape, true);
            }
            catch (SgShapeException sgShapeException) {
                sgShapeException.printStackTrace();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else if (sePointArray[0].isMeasured()) {
            int n4;
            this.k = n4 = sePointArray.length;
            this.a = new SgShapePoint[n4];
            this.b = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                this.a[n5] = new SgShapePoint(sePointArray[n5].X(), sePointArray[n5].Y());
                this.b[n5] = sePointArray[n5].c;
                ++n5;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgSDEShape sgSDEShape = this.a();
                try {
                    sgSDEShape.a(n4, 1, null, this.a, null, this.b, true);
                }
                catch (SgShapeException sgShapeException) {
                    if (sgShapeException.getErrorCode() == -2035) {
                        sgSDEShape.b(n4, 1, null, this.a, null, this.b, true);
                    }
                    sgShapeException.printStackTrace();
                }
                sgSDEShape.y();
                this.a(sgSDEShape, true);
            }
            catch (SgShapeException sgShapeException) {
                sgShapeException.printStackTrace();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else if (sePointArray[0].is3D()) {
            int n6;
            this.k = n6 = sePointArray.length;
            this.a = new SgShapePoint[n6];
            this.c = new double[n6];
            int n7 = 0;
            while (n7 < n6) {
                this.a[n7] = new SgShapePoint(sePointArray[n7].X(), sePointArray[n7].Y());
                this.c[n7] = sePointArray[n7].b;
                ++n7;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgSDEShape sgSDEShape = this.a();
                try {
                    sgSDEShape.a(n6, 1, null, this.a, this.c, null, true);
                }
                catch (SgShapeException sgShapeException) {
                    if (sgShapeException.getErrorCode() == -2035) {
                        sgSDEShape.b(n6, 1, null, this.a, this.c, null, true);
                    }
                    sgShapeException.printStackTrace();
                }
                sgSDEShape.y();
                this.a(sgSDEShape, true);
            }
            catch (SgShapeException sgShapeException) {
                sgShapeException.printStackTrace();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        } else {
            int n8;
            this.k = n8 = sePointArray.length;
            this.a = new SgShapePoint[n8];
            int n9 = 0;
            while (n9 < n8) {
                this.a[n9] = new SgShapePoint(sePointArray[n9].X(), sePointArray[n9].Y());
                ++n9;
            }
            try {
                this.setCoordRef(seCoordRef);
                SgSDEShape sgSDEShape = this.a();
                try {
                    sgSDEShape.a(n8, 1, null, this.a, true);
                }
                catch (SgShapeException sgShapeException) {
                    if (sgShapeException.getErrorCode() == -2035) {
                        sgSDEShape.b(n8, 1, null, this.a, null, null, true);
                    }
                    sgShapeException.printStackTrace();
                }
                sgSDEShape.y();
                this.a(sgSDEShape, true);
            }
            catch (SgShapeException sgShapeException) {
                sgShapeException.printStackTrace();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
    }

    SeLinestring(SgShapePoint[] sgShapePointArray) {
        int n2 = sgShapePointArray.length;
        this.a = new SgShapePoint[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.a[n3] = new SgShapePoint(sgShapePointArray[n3].dx, sgShapePointArray[n3].dy);
            ++n3;
        }
    }

    SeLinestring(SgShapePoint[] sgShapePointArray, double[] dArray) {
        int n2 = sgShapePointArray.length;
        this.a = new SgShapePoint[n2];
        this.b = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.a[n3] = new SgShapePoint(sgShapePointArray[n3].dx, sgShapePointArray[n3].dy);
            this.b[n3] = dArray[n3];
            ++n3;
        }
    }

    SeLinestring(SgShapePoint[] sgShapePointArray, double[] dArray, double[] dArray2) {
        if (dArray2 == null) {
            int n2 = sgShapePointArray.length;
            this.a = new SgShapePoint[n2];
            this.c = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.a[n3] = new SgShapePoint(sgShapePointArray[n3].dx, sgShapePointArray[n3].dy);
                this.c[n3] = dArray[n3];
                ++n3;
            }
        } else {
            int n4 = sgShapePointArray.length;
            this.a = new SgShapePoint[n4];
            this.c = new double[n4];
            this.b = new double[n4];
            int n5 = 0;
            while (n5 < n4) {
                this.a[n5] = new SgShapePoint(sgShapePointArray[n5].dx, sgShapePointArray[n5].dy);
                this.c[n5] = dArray[n5];
                this.b[n5] = dArray2[n5];
                ++n5;
            }
        }
    }

    public Point startPoint() {
        SePoint sePoint = null;
        if (this.a == null) {
            return null;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgShapePoint sgShapePoint = sgSDEShape.af();
            sePoint = new SePoint(sgSDEShape.coordref.b(sgShapePoint.x), sgSDEShape.coordref.b(sgShapePoint.y));
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return sePoint;
    }

    public Point endPoint() {
        SePoint sePoint = null;
        if (this.a == null) {
            return null;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgShapePoint sgShapePoint = sgSDEShape.ag();
            sePoint = new SePoint(sgSDEShape.coordref.b(sgShapePoint.x), sgSDEShape.coordref.b(sgShapePoint.y));
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return sePoint;
    }

    public Geometry pointN(int n2) {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.a == null) {
            return geometryArray[0];
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgShapePoint sgShapePoint = new SgShapePoint(sgSDEShape.point[n2 - 1].x, sgSDEShape.point[n2 - 1].y);
            sgSDEShape.point = new SgShapePoint[1];
            sgSDEShape.point[0] = new SgShapePoint(sgShapePoint.x, sgShapePoint.y);
            if (sgSDEShape.j() && sgSDEShape.i()) {
                int n3 = sgSDEShape.zpt[n2 - 1];
                sgSDEShape.zpt = new int[1];
                sgSDEShape.zpt[0] = n3;
                int n4 = sgSDEShape.mval[n2 - 1];
                sgSDEShape.mval = new int[1];
                sgSDEShape.mval[0] = n4;
            } else if (sgSDEShape.i()) {
                int n5 = sgSDEShape.mval[n2 - 1];
                sgSDEShape.mval = new int[1];
                sgSDEShape.mval[0] = n5;
            } else if (sgSDEShape.j()) {
                int n6 = sgSDEShape.zpt[n2 - 1];
                sgSDEShape.zpt = new int[1];
                sgSDEShape.zpt[0] = n6;
            }
            sgSDEShape.numPoints = 1;
            sgSDEShape.entity = 1;
            sgSDEShape.statusMask = 0;
            geometryArray[0] = SeGeometry.a(sgSDEShape);
            System.out.println("PointN geometry is " + geometryArray[0]);
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public double length() {
        double d2 = 0.0;
        try {
            SgSDEShape sgSDEShape = this.a();
            d2 = sgSDEShape.f();
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return d2;
    }

    public boolean isRing() {
        boolean bl = true;
        boolean bl2 = true;
        double d2 = 0.0;
        if (this.a == null) {
            return false;
        }
        if (this.a.length < 3) {
            return false;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgShapePoint sgShapePoint = sgSDEShape.point[0];
            if (sgSDEShape.zpt != null) {
                d2 = sgSDEShape.zpt[0];
            }
            int n2 = sgSDEShape.point.length;
            if (sgSDEShape.point[n2 - 1].x != sgShapePoint.x || sgSDEShape.point[n2 - 1].y != sgShapePoint.y) {
                bl2 = false;
            } else if (sgSDEShape.zpt != null && (double)sgSDEShape.zpt[n2 - 1] != d2) {
                bl2 = false;
            }
            bl = bl2 ? sgSDEShape.ai() : false;
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return bl;
    }

    public boolean isClosed() {
        boolean bl = true;
        SgShapePoint sgShapePoint = null;
        double d2 = 0.0;
        if (this.a == null) {
            return false;
        }
        if (this.a.length < 3) {
            return false;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            sgShapePoint = sgSDEShape.point[0];
            if (sgSDEShape.zpt != null) {
                d2 = sgSDEShape.zpt[0];
            }
            int n2 = sgSDEShape.point.length;
            if (sgSDEShape.point[n2 - 1].x != sgShapePoint.x || sgSDEShape.point[n2 - 1].y != sgShapePoint.y) {
                bl = false;
            } else if (sgSDEShape.zpt != null && (double)sgSDEShape.zpt[n2 - 1] != d2) {
                bl = false;
            }
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return bl;
    }

    public Geometry boundary() {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.a == null) {
            return null;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgSDEShape sgSDEShape2 = null;
            sgSDEShape2 = sgSDEShape.j() && sgSDEShape.i() ? sgSDEShape.a(true, true) : (sgSDEShape.i() ? sgSDEShape.a(false, true) : (sgSDEShape.j() ? sgSDEShape.a(true, false) : sgSDEShape.a(false, false)));
            geometryArray[0] = SeGeometry.a(sgSDEShape2);
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public Geometry interior() {
        return null;
    }

    public Geometry exterior() {
        return null;
    }

    public Geometry buffer(double d2) {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.a == null) {
            return null;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgSDEShape sgSDEShape2 = sgSDEShape.d(d2);
            geometryArray[0] = SeGeometry.a(sgSDEShape2);
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public boolean isSimple() {
        boolean bl = false;
        if (this.a == null) {
            return true;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            bl = sgSDEShape.ai();
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.a == null) {
            bl = true;
        }
        return bl;
    }

    public int numPoints() {
        return this.a.length;
    }

    public Geometry envelope() {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.a == null) {
            return null;
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgSDEShape sgSDEShape2 = new SgSDEShape();
            sgSDEShape2.a(sgSDEShape.coordref);
            if (this.m == this.o || this.n == this.p) {
                SgShapePoint[] sgShapePointArray = new SgShapePoint[]{new SgShapePoint(this.m, this.n), new SgShapePoint(this.o, this.p)};
                sgSDEShape2.a(2, 1, null, sgShapePointArray, true);
            } else {
                SeEnvelope seEnvelope = new SeEnvelope(this.m, this.n, this.o, this.p);
                seEnvelope.a(sgSDEShape2.o());
                sgSDEShape2.a(seEnvelope.a(), true);
            }
            geometryArray[0] = SeGeometry.a(sgSDEShape2);
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public int dimension() {
        return 1;
    }

    public boolean isMeasured() {
        return this.b != null;
    }

    public boolean is3D() {
        return this.c != null;
    }

    public String geometryType() {
        return "Linestring";
    }

    public Geometry convexhull() {
        Geometry[] geometryArray = new Geometry[]{null};
        if (this.k < 3) {
            return geometryArray[0];
        }
        try {
            SgSDEShape sgSDEShape = this.a();
            SgEnvelope sgEnvelope = sgSDEShape.y();
            SeEnvelope seEnvelope = new SeEnvelope();
            seEnvelope.a(sgEnvelope);
            seEnvelope.b(sgSDEShape.o());
            sgSDEShape.e(true);
            SgSDEShape sgSDEShape2 = sgSDEShape.u();
            geometryArray[0] = SeGeometry.a(sgSDEShape2);
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public Geometry locateAlong(double d2) {
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgSDEShape sgSDEShape = this.a();
            SgSDEShape[] sgSDEShapeArray = sgSDEShape.b(d2);
            if (sgSDEShapeArray == null) {
                return null;
            }
            SgSDEShape sgSDEShape2 = null;
            int n2 = 0;
            while (n2 < sgSDEShapeArray.length) {
                int n3 = sgSDEShapeArray[n2].h();
                if ((2 & n3) != 0 || (4 & n3) != 0) {
                    sgSDEShape2 = sgSDEShapeArray[n2];
                    break;
                }
                sgSDEShape2 = sgSDEShapeArray[n2];
                ++n2;
            }
            if (sgSDEShape2 != null) {
                geometryArray[0] = SeGeometry.a(sgSDEShape2);
            }
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public Geometry locateBetween(double d2, double d3) {
        Geometry[] geometryArray = new Geometry[]{null};
        try {
            SgSDEShape sgSDEShape = this.a();
            SgSDEShape[] sgSDEShapeArray = sgSDEShape.a(d2, d3);
            if (sgSDEShapeArray == null) {
                return null;
            }
            SgSDEShape sgSDEShape2 = null;
            int n2 = 0;
            while (n2 < sgSDEShapeArray.length) {
                int n3 = sgSDEShapeArray[n2].h();
                if ((2 & n3) == 1 || (4 & n3) == 1) {
                    sgSDEShape2 = sgSDEShapeArray[n2];
                    break;
                }
                sgSDEShape2 = sgSDEShapeArray[n2];
                ++n2;
            }
            if (sgSDEShape2 != null) {
                geometryArray[0] = SeGeometry.a(sgSDEShape2);
            }
        }
        catch (SgShapeException sgShapeException) {
            sgShapeException.printStackTrace();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return geometryArray[0];
    }

    public SePoint[] getXYs() {
        SePoint[] sePointArray = new SePoint[this.a.length];
        int n2 = 0;
        while (n2 < this.a.length) {
            sePointArray[n2] = new SePoint(this.a[n2].dx, this.a[n2].dy);
            ++n2;
        }
        return sePointArray;
    }

    public double[] getMs() {
        double[] dArray = new double[this.b.length];
        int n2 = 0;
        while (n2 < this.b.length) {
            dArray[n2] = this.b[n2];
            ++n2;
        }
        return dArray;
    }

    public double[] getZs() {
        double[] dArray = new double[this.c.length];
        int n2 = 0;
        while (n2 < this.c.length) {
            dArray[n2] = this.c[n2];
            ++n2;
        }
        return dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.a == null) {
            stringBuffer.append("SeLinestring Empty");
        } else {
            stringBuffer.append("SeLinestring:\n");
            if (this.c != null && this.b != null) {
                int n2 = 0;
                while (n2 < this.a.length) {
                    stringBuffer.append("(SePoint : ").append(n2).append(" dx=").append(this.a[n2].dx).append(",dy=").append(this.a[n2].dy).append(",z=").append(this.c[n2]).append(",m=").append(this.b[n2]).append(")\n");
                    ++n2;
                }
            } else if (this.b != null) {
                int n3 = 0;
                while (n3 < this.a.length) {
                    stringBuffer.append("(SePoint : ").append(n3).append(" dx=").append(this.a[n3].dx).append(",dy=").append(this.a[n3].dy).append(",m=").append(this.b[n3]).append(")\n");
                    ++n3;
                }
            } else if (this.c != null) {
                int n4 = 0;
                while (n4 < this.a.length) {
                    stringBuffer.append("(SePoint : ").append(n4).append(" dx=").append(this.a[n4].dx).append(",dy=").append(this.a[n4].dy).append(",z=").append(this.c[n4]).append(")\n");
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < this.a.length) {
                    stringBuffer.append("(SePoint : ").append(n5).append(" dx=").append(this.a[n5].dx).append(",dy=").append(this.a[n5].dy).append(")\n");
                    ++n5;
                }
            }
        }
        return new String(stringBuffer);
    }
}

