/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.geom;

import com.esri.sde.sdk.geom.Geometry;

public class GeometryException
extends Exception {
    public GeometryException() {
    }

    public GeometryException(String string) {
        super(string);
    }

    public static class IncompatibleGeometries
    extends GeometryException {
        Geometry[] a = new Geometry[2];

        public IncompatibleGeometries(String string, Geometry geometry, Geometry geometry2) {
            super(string);
            this.a[0] = geometry;
            this.a[1] = geometry2;
        }

        public String toString() {
            return "Incompatible geometries: " + this.a[0] + " , " + this.a[1] + " \n " + super.toString();
        }

        public Geometry[] geometries() {
            return this.a;
        }
    }

    public static class InvalidGeometry
    extends GeometryException {
        Geometry a = null;

        public InvalidGeometry(String string, Geometry geometry) {
            super(string);
            this.a = geometry;
        }

        public String toString() {
            return "Invalid geometry: " + this.a + " \n " + super.toString();
        }

        public Geometry geometry() {
            return this.a;
        }
    }

    public static class InvalidSrid
    extends GeometryException {
        int a;

        public InvalidSrid(String string, int n2) {
            super(string);
            this.a = n2;
        }

        public String toString() {
            return "Invalid srid " + this.a + "\n" + this.toString();
        }
    }

    public static class IndexOutOfBounds
    extends IndexOutOfBoundsException {
        int a;
        Geometry b = null;

        public IndexOutOfBounds(String string, Geometry geometry, int n2) {
            super(string);
            this.a = n2;
            this.b = geometry;
        }

        public String toString() {
            return "Index " + this.a + " is out of bounds for " + this.b.toString();
        }
    }
}

