/*
 * Decompiled with CFR 0.152.
 */
package com.esri.sde.sdk.client;

import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExceptionFactory;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SePECoordinateSystem;
import com.esri.sde.sdk.client.SePEGeographicCS;
import com.esri.sde.sdk.client.SePEProjectedCS;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeTransmittable;
import com.esri.sde.sdk.client.XdrInputStream;
import com.esri.sde.sdk.client.XdrOutputStream;
import com.esri.sde.sdk.client.b;
import com.esri.sde.sdk.client.e;
import com.esri.sde.sdk.geom.SeCoordRef;
import com.esri.sde.sdk.geom.SgShapeException;
import java.io.IOException;

public class SeCoordinateReference
extends b
implements Cloneable {
    private SeCoordRef a = new SeCoordRef();
    private SePECoordinateSystem b;

    public Object clone() throws CloneNotSupportedException {
        SeCoordinateReference seCoordinateReference = new SeCoordinateReference();
        try {
            seCoordinateReference.a(this.a.duplicate());
            if (this.b != null) {
                seCoordinateReference.b = (SePECoordinateSystem)this.b.clone();
            }
        }
        catch (SgShapeException sgShapeException) {
            try {
                SeShape.d(sgShapeException.getErrorCode());
            }
            catch (SeException seException) {
                throw new CloneNotSupportedException(seException.getMessage());
            }
        }
        catch (SeException seException) {
            throw new CloneNotSupportedException(seException.getMessage());
        }
        return seCoordinateReference;
    }

    int a(double d2) throws SeException {
        int n2 = 0;
        try {
            n2 = this.a.convertValueToSystem(d2);
        }
        catch (SgShapeException sgShapeException) {
            SeShape.d(sgShapeException.getErrorCode());
        }
        return n2;
    }

    int a(double d2, double d3) throws SeException {
        int n2 = 0;
        try {
            n2 = this.a.convertValueToSystem(d2, d3);
        }
        catch (SgShapeException sgShapeException) {
            SeShape.d(sgShapeException.getErrorCode());
        }
        return n2;
    }

    public String getProjectionDescription() {
        return this.a.getProjectionStr();
    }

    public double getFalseM() {
        return this.a.getFalseM();
    }

    public double getMUnits() {
        return this.a.getMUnits();
    }

    public double getMinMValue() {
        return this.a.getFalseM();
    }

    public double getMaxMValue() {
        return this.b(this.getMinMValue(), this.getMUnits());
    }

    public SeObjectId getSrid() {
        return new SeObjectId(this.a.getSrid());
    }

    public double getFalseX() {
        return this.a.getFalseX();
    }

    public double getFalseY() {
        return this.a.getFalseY();
    }

    public double getXYUnits() {
        return this.a.getXYUnits();
    }

    public double getFalseZ() {
        return this.a.getFalseZ();
    }

    public double getZUnits() {
        return this.a.getZUnits();
    }

    public double getMinZValue() {
        return this.a.getFalseZ();
    }

    public double getMaxZValue() {
        return this.b(this.getMinZValue(), this.getZUnits());
    }

    private double b(double d2, double d3) {
        return d2 + 2.147483645E9 / d3;
    }

    private double b(double d2) {
        return 2.147483645E9 / d2;
    }

    private double c(double d2, double d3) {
        return d2 - 1.0 / d3;
    }

    public boolean isEqual(SeCoordinateReference seCoordinateReference) throws SeException {
        return this.a.isEqual(seCoordinateReference.getCoordRef());
    }

    public void setCoordSysByDescription(String string) {
        this.b = string.startsWith("PROJCS[") ? new SePEProjectedCS(string) : (string.startsWith("GEOGCS[") ? new SePEGeographicCS(string) : null);
        if (this.b != null && this.a != null) {
            this.a.setProjectionStr(string);
        }
    }

    public String getCoordSysDescription() {
        if (this.b != null) {
            return this.b.toString();
        }
        return "UNKNOWN";
    }

    public void setM(double d2, double d3) {
        this.a.setM(d2, d3);
    }

    public void setMByRange(double d2, double d3) {
        double d4 = this.b(d3 - d2);
        double d5 = this.c(d2, d4);
        this.setM(d5, d4);
    }

    public void setXY(double d2, double d3, double d4) {
        this.a.setXY(d2, d3, d4);
    }

    public SeExtent getXYEnvelope() throws SeException {
        double d2 = this.getXYUnits();
        double d3 = this.getFalseX();
        double d4 = this.b(d3, d2);
        double d5 = this.getFalseY();
        double d6 = this.b(d5, d2);
        return new SeExtent(d3, d4, d5, d6);
    }

    public void setXYByEnvelope(SeExtent seExtent) throws SeException {
        if (seExtent.getMinX() >= seExtent.getMaxX() || seExtent.getMinY() >= seExtent.getMaxY()) {
            SeExceptionFactory.throwException(null, -58, "");
        }
        double d2 = Math.min(seExtent.getMaxX() - seExtent.getMinX(), seExtent.getMaxY() - seExtent.getMinY());
        double d3 = this.b(d2);
        double d4 = this.c(seExtent.getMinX(), d3);
        double d5 = this.c(seExtent.getMinY(), d3);
        this.setXY(d4, d5, d3);
    }

    public void setZ(double d2, double d3) {
        this.a.setZ(d2, d3);
    }

    public void setZByRange(double d2, double d3) {
        double d4 = this.b(d3 - d2);
        double d5 = this.c(d2, d4);
        this.setM(d5, d4);
    }

    void a() throws SeException {
        String string = this.a.getProjectionStr();
        this.b = string.startsWith("PROJCS[") ? new SePEProjectedCS(string) : (string.startsWith("GEOGCS[") ? new SePEGeographicCS(string) : null);
    }

    void b() throws SeException {
        if (this.b != null) {
            String string = this.b.toString();
            this.a.setProjectionStr(string);
        } else {
            this.a.setProjectionStr("UNKNOWN");
        }
    }

    void a(SeCoordRef seCoordRef) throws SeException {
        try {
            this.a = seCoordRef.duplicate();
        }
        catch (SgShapeException sgShapeException) {
            SeShape.d(sgShapeException.getErrorCode());
        }
    }

    public SeCoordRef getCoordRef() throws SeException {
        SeCoordRef seCoordRef = null;
        try {
            seCoordRef = this.a.duplicate();
        }
        catch (SgShapeException sgShapeException) {
            SeShape.d(-2023);
        }
        return seCoordRef;
    }

    SeTransmittable transmitter() {
        return new TransmittableImpl();
    }

    protected final class TransmittableImpl
    implements SeTransmittable {
        protected TransmittableImpl() {
        }

        public void read(XdrInputStream xdrInputStream, int n2) throws IOException {
            SeCoordinateReference.this.a.setFalseX(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setFalseY(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setFalseZ(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setFalseM(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setXYUnits(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setZUnits(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setMUnits(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setXYCRound(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setZCRound(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setMCRound(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setXYHalfSU(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setZHalfSU(xdrInputStream.readDouble());
            SeCoordinateReference.this.a.setMHalfSU(xdrInputStream.readDouble());
            int n3 = xdrInputStream.readInt();
            if (n3 > 0) {
                SeCoordinateReference.this.a.setProjectionStr(xdrInputStream.readCString());
            }
            SeCoordinateReference.this.setCoordSysByDescription(SeCoordinateReference.this.a.getProjectionStr());
            if (n2 > 3020) {
                SeCoordinateReference.this.a.setSrid(xdrInputStream.readInt());
            }
        }

        public void write(XdrOutputStream xdrOutputStream, int n2) throws IOException {
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getFalseX());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getFalseY());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getFalseZ());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getFalseM());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getXYUnits());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getZUnits());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getMUnits());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getXYCRound());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getZCRound());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getMCRound());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getXYHalfSU());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getZHalfSU());
            xdrOutputStream.writeDouble(SeCoordinateReference.this.a.getMHalfSU());
            String string = SeCoordinateReference.this.a.getProjectionStr();
            int n3 = string.length();
            xdrOutputStream.writeInt(n3);
            if (n3 > 0) {
                xdrOutputStream.writeString(string);
            }
            if (n2 > 3020) {
                xdrOutputStream.writeInt(SeCoordinateReference.this.a.getSrid());
            }
        }

        public int size(int n2) {
            int n3 = 0;
            n3 += 104;
            n3 += 4;
            n3 += e.a(SeCoordinateReference.this.a.getProjectionStr());
            if (n2 > 3020) {
                n3 += 4;
            }
            return n3;
        }
    }
}

