/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.marshal;

import com.esri.axl.mapping.XmlMappingRegistry;
import com.esri.axl.marshal.BaseXmlStream;
import com.esri.axl.marshal.FieldAccessor;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.XmlName;
import com.esri.axl.marshal.XmlOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Stack;

public class XmlOutputStreamImpl
extends BaseXmlStream
implements XmlOutputStream {
    private static String _tabs;
    private String _encoding;
    private String _overwriteStartTag;
    private Stack _tagStack;
    private Stack _freeAccessor;
    private byte _lastState;
    private String _startTag;
    private boolean _bWroteFirstStartTag;
    private String _header = new String("<?xml version=\"1.0\"");
    private Stack _markers;
    private Writer _outputStream;
    private boolean _bIndent;
    private HashMap _prefix2uri;
    private HashMap _uri2prefix;
    private boolean _bWriteXmlns;

    public XmlOutputStreamImpl(OutputStream outputStream, XmlMappingRegistry xmlMappingRegistry, String string) throws UnsupportedEncodingException {
        this(outputStream, xmlMappingRegistry, string, true);
    }

    public XmlOutputStreamImpl(OutputStream outputStream, XmlMappingRegistry xmlMappingRegistry, String string, boolean bl) throws UnsupportedEncodingException {
        super(xmlMappingRegistry);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 256) {
            stringBuffer.append('\t');
            ++n;
        }
        _tabs = new String(stringBuffer);
        this._encoding = string == null || string == "" ? "UTF-8" : string.toString();
        this._bWroteFirstStartTag = false;
        this._outputStream = new OutputStreamWriter(outputStream, this._encoding);
        this._tagStack = new Stack();
        this._markers = new Stack();
        this._bIndent = true;
        this._prefix2uri = new HashMap(10);
        this._uri2prefix = new HashMap(10);
        this._freeAccessor = new Stack();
        this._bWriteXmlns = bl;
    }

    public String getEncoding() {
        return this._encoding.toString();
    }

    public String getNamespaceURI(String string) {
        return (String)this._prefix2uri.get(string);
    }

    public String getNamespacePrefix(String string) {
        return (String)this._uri2prefix.get(string);
    }

    public void setNamespaceURI(String string, String string2) {
        this._uri2prefix.put(string, string2);
        this._prefix2uri.put(string2, string);
        this.getMapping().addURI(string);
    }

    public void overwriteStartTag(String string, String string2) throws MarshallingException {
        this._overwriteStartTag = XmlName.getPrefixedName(this, string, string2);
    }

    public void overwriteStartTag(XmlName xmlName) throws MarshallingException {
        this._overwriteStartTag = xmlName.getPrefixedName(this);
    }

    public boolean hasOverwrittenStartTag() {
        return this._overwriteStartTag != null;
    }

    public void writeStartTag(XmlName xmlName) throws MarshallingException {
        if (xmlName == null) {
            this.writeStartTag("", "");
        } else {
            this.writeStartTag(xmlName.getURI(), xmlName.getName());
        }
    }

    public void writeStartTag(String string, String string2) throws MarshallingException {
        try {
            if (this._startTag != null) {
                if (this._lastState == 2) {
                    this.getOutputStream().write(">\n");
                }
                this._tagStack.push(this._startTag);
            }
            if (this._overwriteStartTag != null) {
                this._startTag = this._overwriteStartTag;
                this._overwriteStartTag = null;
            } else {
                this._startTag = XmlName.getPrefixedName(this, string, string2);
            }
            if (!this._bWroteFirstStartTag) {
                this.getOutputStream().write(this.getHeader() + " encoding=\"" + this._encoding + "\" ?>\n");
            }
            if (this._bIndent) {
                this.getOutputStream().write(_tabs.substring(0, this._tagStack.size()));
            }
            this.getOutputStream().write("<" + this._startTag);
            if (!this._bWroteFirstStartTag) {
                this.writeAttributeNamespaces();
            }
            this._lastState = (byte)2;
        }
        catch (Exception exception) {
            throw new MarshallingException("Error writing start tag: " + string2);
        }
    }

    public void writeAttributeNamespaces() throws MarshallingException {
        this._bWroteFirstStartTag = true;
        if (this._bWriteXmlns) {
            String[] stringArray = this.getMapping().getAllURIs();
            int n = 0;
            while (n < stringArray.length) {
                String string = this.getNamespacePrefix(stringArray[n]);
                try {
                    if (string.equals("")) {
                        this.getOutputStream().write(" xmlns=\"" + stringArray[n] + "\"");
                    } else {
                        this.getOutputStream().write(" xmlns:" + string + "=\"" + stringArray[n] + "\"");
                    }
                }
                catch (Exception exception) {
                    throw new MarshallingException("Error writing namespace prefixes: " + stringArray[n]);
                }
                ++n;
            }
        }
    }

    public void writeEndTag() throws MarshallingException {
        String string = this._startTag;
        try {
            if (this._lastState == 2) {
                this.getOutputStream().write("/>\n");
            } else if (this._lastState == 4) {
                this.getOutputStream().write("</" + string + ">\n");
            } else {
                string = (String)this._tagStack.pop();
                if (this._bIndent) {
                    this.getOutputStream().write(_tabs.substring(0, this._tagStack.size()));
                }
                this.getOutputStream().write("</" + string + ">\n");
            }
            this._lastState = (byte)3;
            this._startTag = null;
        }
        catch (Exception exception) {
            throw new MarshallingException("Error writing end tag: " + string);
        }
    }

    public void close() throws MarshallingException {
        try {
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new MarshallingException("Error closing stream");
        }
    }

    public void marshal(Object object) throws MarshallingException {
        this.getMapping().marshalByClass(object, this);
    }

    public void writeAttribute(String string, String string2, String string3) throws MarshallingException {
        String string4 = XmlName.getPrefixedName(this, string, string2);
        try {
            this.getOutputStream().write(" ");
            this.getOutputStream().write(string4);
            this.getOutputStream().write("=\"");
            this.writeXmlString(string3);
            this.getOutputStream().write("\"");
        }
        catch (Exception exception) {
            throw new MarshallingException("Error writing attribute: " + string2);
        }
    }

    public void writeAttribute(String string, String string2) throws MarshallingException {
        try {
            this.getOutputStream().write(" ");
            this.getOutputStream().write(string);
            this.getOutputStream().write("=\"");
            this.writeXmlString(string2);
            this.getOutputStream().write("\"");
        }
        catch (Exception exception) {
            throw new MarshallingException("Error writing attribute: " + string);
        }
    }

    public void writeAttribute(XmlName xmlName, String string) throws MarshallingException {
        this.writeAttribute(xmlName.getURI(), xmlName.getName(), string);
    }

    public void writeContent(String string) throws MarshallingException {
        try {
            if (this._lastState == 2) {
                this.getOutputStream().write(">");
                this._lastState = (byte)4;
            }
            this.writeXmlString(string);
        }
        catch (IOException iOException) {
            throw new MarshallingException("Error writing content: " + string);
        }
    }

    private void writeXmlString(String string) throws IOException {
        if (string == null) {
            return;
        }
        Writer writer = this.getOutputStream();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    if (n != n2) {
                        writer.write(string, n, n2 - n);
                    }
                    n = n2 + 1;
                    break;
                }
            }
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '\'': {
                    writer.write("&apos;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
            }
            ++n2;
        }
        if (n != string.length()) {
            writer.write(string, n, string.length() - n);
        }
    }

    public void setIndent(boolean bl) {
        this._bIndent = bl;
    }

    public void setMarker() {
        this._markers.push(new StringWriter());
    }

    public void clearLastMarker() throws MarshallingException {
        StringWriter stringWriter = (StringWriter)this._markers.pop();
        try {
            this.getOutputStream().write(stringWriter.getBuffer().toString());
        }
        catch (IOException iOException) {
            throw new MarshallingException("Java IO Error in writing XML to output stream");
        }
    }

    public void gotoAndClearLastMarker() {
        this._markers.pop();
    }

    private Writer getOutputStream() {
        if (this._markers.size() == 0) {
            return this._outputStream;
        }
        return (Writer)this._markers.peek();
    }

    public FieldAccessor allocateFieldAccessor(Object object) {
        if (this._freeAccessor.size() == 0) {
            return new FieldAccessor(object);
        }
        return (FieldAccessor)this._freeAccessor.pop();
    }

    public void freeFieldAccessor(FieldAccessor fieldAccessor) {
        this._freeAccessor.push(fieldAccessor);
    }

    public String getHeader() {
        return this._header;
    }

    public void setHeader(String string) {
        this._header = string.toString();
    }
}

