/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.marshal;

import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.Utils;
import com.esri.axl.marshal.XmlOutputStream;
import com.esri.axl.marshal.XmlStream;

public class XmlName {
    private String _name;
    private String _uri;

    public XmlName() {
    }

    public XmlName(String string, String string2) {
        this._uri = string;
        this._name = string2;
    }

    public XmlName(XmlStream xmlStream, String string) {
        this._uri = Utils.getURIFromRawName(xmlStream, string);
        this._name = Utils.getLocalNameFromRawName(string);
    }

    public boolean equals(Object object) {
        XmlName xmlName = (XmlName)object;
        return this.isEqual(xmlName.getURI(), xmlName.getName());
    }

    public boolean isEqual(String string, String string2) {
        if (this._name.equals("*")) {
            return true;
        }
        if (!string2.equals(this._name)) {
            return false;
        }
        if (string == null) {
            return this._uri == null;
        }
        return string.equals(this._uri);
    }

    public String getName() {
        return this._name;
    }

    public String getURI() {
        return this._uri;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setURI(String string) {
        this._uri = string;
    }

    public String getPrefixedName(XmlOutputStream xmlOutputStream) throws MarshallingException {
        return XmlName.getPrefixedName(xmlOutputStream, this._uri, this._name);
    }

    public static String getPrefixedName(XmlOutputStream xmlOutputStream, XmlName xmlName) throws MarshallingException {
        return XmlName.getPrefixedName(xmlOutputStream, xmlName.getURI(), xmlName.getName());
    }

    public static String getPrefixedName(XmlOutputStream xmlOutputStream, String string, String string2) throws MarshallingException {
        if (string == null) {
            return string2;
        }
        String string3 = xmlOutputStream.getNamespacePrefix(string);
        if (string3 == null) {
            throw new MarshallingException("Prefix for namespace URI < " + string + " > not found.");
        }
        if (string3.equals("")) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }
}

