/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.marshal;

import com.esri.axl.indiana.xpp.StartTag;
import com.esri.axl.indiana.xpp.XmlPullParser;
import com.esri.axl.indiana.xpp.XmlPullParserException;
import com.esri.axl.mapping.XmlMappingRegistry;
import com.esri.axl.marshal.BaseXmlStream;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlEncodedInputStream;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class XmlInputStreamImpl
extends BaseXmlStream
implements XmlInputStream {
    private XmlPullParser _parser;
    private byte _nodeType = 0;
    private StartTag _startTag = new StartTag();
    private String _content;
    private boolean _checkingAttributes = false;
    private String _encoding;

    public void setCheckAttributes(boolean bl) {
        this._checkingAttributes = bl;
    }

    public boolean isNamespaceAware() {
        return this._parser.isNamespaceAware();
    }

    public XmlInputStreamImpl(InputStream inputStream, XmlMappingRegistry xmlMappingRegistry) throws UnMarshallingException {
        this(inputStream, xmlMappingRegistry, true);
    }

    public String getEncoding() {
        return this._encoding.toString();
    }

    public XmlInputStreamImpl(InputStream inputStream, XmlMappingRegistry xmlMappingRegistry, boolean bl) throws UnMarshallingException {
        super(xmlMappingRegistry);
        try {
            if (inputStream.available() <= 0) {
                throw new UnMarshallingException("Could not read input stream");
            }
            this._parser = new XmlPullParser();
            this._parser.setNamespaceAware(bl);
            this._parser.setNamespacePrefixes(bl);
            XmlEncodedInputStream xmlEncodedInputStream = new XmlEncodedInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)xmlEncodedInputStream, xmlEncodedInputStream.getEncoding());
            this._encoding = xmlEncodedInputStream.getEncoding();
            this._parser.setInput(inputStreamReader);
            this._registry = xmlMappingRegistry;
            this.nextNode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnMarshallingException("Could not create input stream");
        }
    }

    public XmlInputStreamImpl(InputStream inputStream, XmlMappingRegistry xmlMappingRegistry, String string) throws UnMarshallingException {
        super(xmlMappingRegistry);
        try {
            if (inputStream.available() <= 0) {
                throw new UnMarshallingException("Could not read input stream");
            }
            this._parser = new XmlPullParser();
            this._parser.setNamespaceAware(true);
            this._parser.setNamespacePrefixes(true);
            this._parser.setDefaultNamespace(string);
            XmlEncodedInputStream xmlEncodedInputStream = new XmlEncodedInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)xmlEncodedInputStream, xmlEncodedInputStream.getEncoding());
            this._encoding = xmlEncodedInputStream.getEncoding();
            this._parser.setInput(inputStreamReader);
            this._registry = xmlMappingRegistry;
            this.nextNode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnMarshallingException("Could not create input stream");
        }
    }

    public void setMapping(XmlMappingRegistry xmlMappingRegistry) {
        this._registry = xmlMappingRegistry;
    }

    public XmlMappingRegistry getMapping() {
        return this._registry;
    }

    public Object unMarshal(Class clazz) throws UnMarshallingException {
        return this._registry.unMarshalByClass(clazz.getName(), this);
    }

    public boolean atEnd() {
        return this._nodeType == 1;
    }

    public void close() throws UnMarshallingException {
        this._parser = null;
        this._startTag.clear();
        this._startTag = null;
    }

    public byte getNodeType() throws UnMarshallingException {
        return this._nodeType;
    }

    private void resetAttributeCounts(StartTag startTag) {
    }

    public void nextNode() throws UnMarshallingException {
        int n;
        if (this._checkingAttributes && this._nodeType == 2 && (n = this._startTag.unreadAttribute()) != -1) {
            throw new UnMarshallingException("Unread attribute '" + this._startTag.getLocalName(n) + "' in tag '" + this._startTag.getLocalName() + "'.");
        }
        try {
            this._nodeType = this._parser.next();
            if (this._nodeType == 2) {
                this._parser.readStartTag(this._startTag);
                this.resetAttributeCounts(this._startTag);
            }
            if (this._nodeType == 4) {
                this._content = this._parser.readContent();
                if (this._parser.whitespaceContent()) {
                    this.nextNode();
                }
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            throw new UnMarshallingException(xmlPullParserException.getMessage());
        }
        catch (IOException iOException) {
            throw new UnMarshallingException(this, "I/O Exception");
        }
    }

    public String getStartTag() throws UnMarshallingException {
        return this._startTag.getLocalName();
    }

    public String getStartTagURI() throws UnMarshallingException {
        if (this.isNamespaceAware()) {
            return this._startTag.getUri();
        }
        return null;
    }

    public void disgardPastEndTag() throws UnMarshallingException {
        try {
            this._parser.skipSubTree();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new UnMarshallingException(xmlPullParserException.getMessage());
        }
        catch (IOException iOException) {
            throw new UnMarshallingException(this, "I/O Exception");
        }
    }

    public String getAttributeValue(String string, String string2) throws UnMarshallingException {
        return this._startTag.getValue(string, string2);
    }

    public String getAttributeValue(String string) throws UnMarshallingException {
        return this._startTag.getValue(string);
    }

    public String getAttributeValue(XmlName xmlName) throws UnMarshallingException {
        if (xmlName.getURI() == null) {
            return this._startTag.getValue(xmlName.getName());
        }
        return this._startTag.getValue(xmlName.getURI(), xmlName.getName());
    }

    public String getAttributeValue(int n) throws UnMarshallingException {
        return this._startTag.getValue(n);
    }

    public String getAttributeName(int n) throws UnMarshallingException {
        return this._startTag.getLocalName(n);
    }

    public String getAttributeURI(int n) throws UnMarshallingException {
        return this._startTag.getURI(n);
    }

    public int getAttributeCount() throws UnMarshallingException {
        return this._startTag.getLength();
    }

    public String getContent() throws UnMarshallingException {
        return this._content;
    }

    public void setMarker() {
    }

    public void gotoMarker() {
    }

    public int getLineNumber() {
        return this._parser.getLineNumber();
    }

    public int getColumnNumber() {
        return this._parser.getColumnNumber();
    }

    public String getNamespaceURI(String string) {
        return this._parser.prefix2Namespace(string);
    }
}

