/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.marshal;

import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlOutputStream;
import com.esri.axl.marshal.XmlStream;

public class Utils {
    private static String EMPTY_STRING = new String();

    public static String toString(double d) {
        return Double.toString(d);
    }

    public static double parsedouble(String string, String string2, XmlInputStream xmlInputStream) throws UnMarshallingException {
        double d;
        if (string2.equals("Infinity")) {
            d = Double.POSITIVE_INFINITY;
        } else if (string2.equals("-Infinity")) {
            d = Double.NEGATIVE_INFINITY;
        } else {
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnMarshallingException(xmlInputStream, "Invalid double parameter '" + string2 + "' for field " + string);
            }
        }
        return d;
    }

    public static String getPrefixFromRawName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(0, n);
        }
        return EMPTY_STRING;
    }

    public static String getURIFromRawName(XmlStream xmlStream, String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return xmlStream.getNamespaceURI(string.substring(0, n));
        }
        return xmlStream.getNamespaceURI("");
    }

    public static String getLocalNameFromRawName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String makeRawName(XmlOutputStream xmlOutputStream, String string, String string2) {
        return Utils.makeRawName(xmlOutputStream.getNamespacePrefix(string), string2);
    }

    public static String makeRawName(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static int parseOccursInteger(String string, int n) {
        if (string == null) {
            return n;
        }
        if (string.equals("unbounded")) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }
}

