/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.marshal;

import com.esri.axl.mapping.FieldMapping;
import java.util.Iterator;

public class FieldAccessor {
    private Object _object;
    private FieldMapping[] _fields;
    private int[] _counts;
    private Iterator[] _iterators;
    private int _count;
    private int _maxCount;

    public FieldAccessor(Object object) {
        this._object = object;
        this._maxCount = 8;
        this._fields = new FieldMapping[this._maxCount];
        this._counts = new int[this._maxCount];
        this._iterators = new Iterator[this._maxCount];
        this._count = 0;
    }

    public void reset(Object object) {
        int n = 0;
        while (n < this._count) {
            this._fields[n] = null;
            this._counts[n] = 0;
            this._iterators[n] = null;
            ++n;
        }
        this._count = 0;
        this._object = object;
    }

    public Object getObject() {
        return this._object;
    }

    public int getFieldIndex(FieldMapping fieldMapping) {
        int n = 0;
        while (n < this._count) {
            if (fieldMapping == this._fields[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Iterator getIterator(int n) {
        return this._iterators[n];
    }

    public int getCount(int n) {
        return this._counts[n];
    }

    public int addField(FieldMapping fieldMapping, Iterator iterator) {
        int n = this.addField(fieldMapping);
        this._counts[n] = 0;
        this._iterators[n] = iterator;
        return n;
    }

    public int incrementCount(int n) {
        int n2 = n;
        int n3 = this._counts[n2] + 1;
        this._counts[n2] = n3;
        return n3;
    }

    private int addField(FieldMapping fieldMapping) {
        if (this._count == this._maxCount) {
            this._maxCount *= 2;
            FieldMapping[] fieldMappingArray = new FieldMapping[this._maxCount];
            int[] nArray = new int[this._maxCount];
            Iterator[] iteratorArray = new Iterator[this._maxCount];
            int n = 0;
            while (n < this._count) {
                fieldMappingArray[n] = this._fields[n];
                nArray[n] = this._counts[n];
                iteratorArray[n] = this._iterators[n];
                ++n;
            }
            this._fields = fieldMappingArray;
            this._counts = nArray;
            this._iterators = iteratorArray;
        }
        this._fields[this._count] = fieldMapping;
        return this._count++;
    }
}

