/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.ClassMappingEntryImpl;
import com.esri.axl.mapping.EnumerationMapping;
import com.esri.axl.mapping.EnumerationMappingImpl;
import com.esri.axl.mapping.FieldMapping;
import com.esri.axl.mapping.HelperMarshallingEntryImpl;
import com.esri.axl.mapping.IntrospectMappingEntryImpl;
import com.esri.axl.mapping.SelfMarshallingEntryImpl;
import com.esri.axl.mapping.SimpleTypeMarshaller;
import com.esri.axl.mapping.SimpleTypeMarshallerImpl;
import com.esri.axl.mapping.XmlMappingEntry;
import com.esri.axl.mapping.XmlMappingRegistry;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.SelfMarshalling;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlInputStreamImpl;
import com.esri.axl.marshal.XmlOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class XmlMappingRegistryImpl
implements XmlMappingRegistry {
    private boolean _bBeenPostProcessed = false;
    private HashMap _entries;
    private HashMap _references;
    private HashMap _enumerations;
    private HashMap _simpleTypes;
    private String _mappingFileURI;
    private Vector _allURIs;
    private String _introspectionURI;
    public static String MAPPING_FILE_URI = new String("http://www.esri.com/ArcXML/Mapping");

    public XmlMappingRegistryImpl() {
        this._entries = new HashMap();
        this._references = new HashMap();
        this._enumerations = new HashMap();
        this._simpleTypes = new HashMap();
        this._mappingFileURI = MAPPING_FILE_URI;
        this._allURIs = new Vector();
        this._introspectionURI = null;
    }

    public XmlMappingRegistryImpl(String string) {
        this._entries = new HashMap();
        this._references = new HashMap();
        this._enumerations = new HashMap();
        this._simpleTypes = new HashMap();
        this._mappingFileURI = MAPPING_FILE_URI;
        this._allURIs = new Vector();
        this._introspectionURI = string.toString();
    }

    public XmlMappingRegistryImpl(InputStream inputStream) throws UnMarshallingException {
        this(inputStream, true);
    }

    public XmlMappingRegistryImpl(InputStream inputStream, boolean bl) throws UnMarshallingException {
        this._mappingFileURI = MAPPING_FILE_URI;
        this._entries = new HashMap();
        this._references = new HashMap();
        this._enumerations = new HashMap();
        this._simpleTypes = new HashMap();
        this._allURIs = new Vector();
        XmlInputStreamImpl xmlInputStreamImpl = new XmlInputStreamImpl(inputStream, (XmlMappingRegistry)this, bl);
        this.unMarshal(xmlInputStreamImpl);
    }

    public String getMappingFileURI() {
        return this._mappingFileURI;
    }

    public void add(XmlMappingEntry xmlMappingEntry) {
        xmlMappingEntry.setRegistry(this);
        this._entries.put(xmlMappingEntry.getClassName(), xmlMappingEntry);
        if (this._bBeenPostProcessed && xmlMappingEntry instanceof ClassMappingEntryImpl) {
            ((ClassMappingEntryImpl)xmlMappingEntry).postProcess(this);
            ((ClassMappingEntryImpl)xmlMappingEntry).postProcess2(this);
            ((ClassMappingEntryImpl)xmlMappingEntry).postProcess3(this);
        }
    }

    public XmlMappingEntry get(String string) {
        return (XmlMappingEntry)this._entries.get(string);
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(this.getMappingFileURI(), "mapping");
        if (this.getIntrospectionNamespaceURI() != null) {
            xmlOutputStream.writeAttribute("introspectionNamespace", this.getIntrospectionNamespaceURI());
        }
        Collection collection = this._simpleTypes.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SimpleTypeMarshaller simpleTypeMarshaller = (SimpleTypeMarshaller)iterator.next();
            simpleTypeMarshaller.marshal(xmlOutputStream);
        }
        collection = this._enumerations.values();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            EnumerationMapping enumerationMapping = (EnumerationMapping)iterator.next();
            enumerationMapping.marshal(xmlOutputStream);
        }
        collection = this._entries.values();
        iterator = collection.iterator();
        while (iterator.hasNext()) {
            XmlMappingEntry xmlMappingEntry = (XmlMappingEntry)iterator.next();
            xmlMappingEntry.marshal(xmlOutputStream);
        }
        xmlOutputStream.writeEndTag();
    }

    public Iterator classEntries() {
        return this._entries.values().iterator();
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        String string;
        Object object;
        SelfMarshalling selfMarshalling;
        SelfMarshalling selfMarshalling2;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = xmlInputStream.getAttributeValue("introspectionNamespace");
        this.setIntrospectionNamespaceURI(string2);
        xmlInputStream.nextNode();
        while (xmlInputStream.getNodeType() == 2 && xmlInputStream.getStartTag().equals("import")) {
            String string3 = xmlInputStream.getAttributeValue("fileName");
            if (string3 == null) {
                throw new UnMarshallingException(xmlInputStream, "File name undefined in mapping (import)");
            }
            xmlInputStream.nextNode();
            try {
                object4 = new FileInputStream(string3);
            }
            catch (Exception exception) {
                throw new UnMarshallingException(xmlInputStream, "Import file not found:" + string3);
            }
            object3 = new XmlMappingRegistryImpl((InputStream)object4);
            object2 = object3.classEntries();
            while (object2.hasNext()) {
                selfMarshalling2 = (XmlMappingEntry)object2.next();
                this.add((XmlMappingEntry)selfMarshalling2);
            }
            object2 = object3.fieldReferences();
            while (object2.hasNext()) {
                selfMarshalling = (FieldMapping)object2.next();
                this.addReference((FieldMapping)selfMarshalling);
            }
            object2 = object3.enumerations();
            while (object2.hasNext()) {
                object = (EnumerationMapping)object2.next();
                this.addEnumeration((EnumerationMapping)object);
            }
            object3.clear();
            if (xmlInputStream.getNodeType() != 3) {
                throw new UnMarshallingException(xmlInputStream, "Unmatched import tag for fileName:" + string3);
            }
            xmlInputStream.nextNode();
        }
        while (xmlInputStream.getNodeType() == 2 && xmlInputStream.getStartTag().equals("type")) {
            string = xmlInputStream.getAttributeValue("class");
            if (string == null) {
                throw new UnMarshallingException(xmlInputStream, "Attribute 'class' not found");
            }
            String string4 = xmlInputStream.getAttributeValue("alias");
            if (string4 == null) {
                throw new UnMarshallingException(xmlInputStream, "Attribute 'alias' not found");
            }
            if (hashMap.containsKey(string4)) {
                throw new UnMarshallingException(xmlInputStream, "Duplicate alias name: " + string4);
            }
            hashMap.put(string4, string);
            xmlInputStream.nextNode();
            if (xmlInputStream.getNodeType() != 3) {
                throw new UnMarshallingException(xmlInputStream, "Unmatched <type> tag for class:" + string);
            }
            xmlInputStream.nextNode();
        }
        hashMap.put("Vector", "java.util.Vector");
        hashMap.put("LinkedList", "java.util.LinkedList");
        hashMap.put("ArrayList", "java.util.ArrayList");
        hashMap.put("double", "double");
        hashMap.put("long", "long");
        hashMap.put("int", "int");
        hashMap.put("integer", "int");
        hashMap.put("boolean", "boolean");
        hashMap.put("byte", "byte");
        hashMap.put("character", "char");
        hashMap.put("char", "char");
        hashMap.put("float", "float");
        hashMap.put("short", "short");
        hashMap.put("string", "java.lang.String");
        hashMap.put("String", "java.lang.String");
        xmlInputStream.getPropertySet().addProperty("Aliases", hashMap);
        while (xmlInputStream.getNodeType() == 2) {
            if (xmlInputStream.getStartTag().equals("class")) {
                String string5;
                string = xmlInputStream.getAttributeValue("name");
                if (string == null) {
                    throw new UnMarshallingException(xmlInputStream, "Attribute 'class' not found");
                }
                if (hashMap.containsKey(string)) {
                    string = (String)hashMap.get(string);
                }
                if ((string5 = xmlInputStream.getAttributeValue("method")) == null || string5.equals("mapping")) {
                    object4 = new ClassMappingEntryImpl(string, (XmlMappingRegistry)this);
                } else if (string5.equals("helper")) {
                    object = xmlInputStream.getAttributeValue("helperClass");
                    if (hashMap.containsKey(object)) {
                        object = (String)hashMap.get(object);
                    }
                    object4 = new HelperMarshallingEntryImpl(string, (String)object, (XmlMappingRegistry)this);
                } else if (string5.equals("self")) {
                    object4 = new SelfMarshallingEntryImpl(string, (XmlMappingRegistry)this);
                } else if (string5.equals("introspection")) {
                    object4 = new IntrospectMappingEntryImpl(string, (XmlMappingRegistry)this);
                } else {
                    throw new UnMarshallingException(xmlInputStream, "Undefined value for method attribute in class:" + string);
                }
                object4.unMarshal(xmlInputStream);
                this.add((XmlMappingEntry)object4);
            } else if (xmlInputStream.getStartTag().equals("enumeration")) {
                object3 = xmlInputStream.getAttributeValue("name");
                selfMarshalling2 = new EnumerationMappingImpl((String)object3, this);
                selfMarshalling2.unMarshal(xmlInputStream);
            } else if (xmlInputStream.getStartTag().equals("simpleType")) {
                object2 = xmlInputStream.getAttributeValue("name");
                selfMarshalling = new SimpleTypeMarshallerImpl((String)object2, this);
                selfMarshalling.unMarshal(xmlInputStream);
            } else {
                throw new UnMarshallingException(xmlInputStream, "Tag <" + xmlInputStream.getStartTag() + "> not allowed");
            }
            if (xmlInputStream.getNodeType() == 3) break;
        }
        xmlInputStream.nextNode();
        object = this._entries.values();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object4 = (XmlMappingEntry)iterator.next();
            if (!(object4 instanceof IntrospectMappingEntryImpl)) continue;
            try {
                ((IntrospectMappingEntryImpl)object4).initialize(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        while (iterator.hasNext()) {
            object4 = (XmlMappingEntry)iterator.next();
            if (!(object4 instanceof ClassMappingEntryImpl)) continue;
            ((ClassMappingEntryImpl)object4).postProcess(this);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            object4 = (XmlMappingEntry)iterator.next();
            if (!(object4 instanceof ClassMappingEntryImpl)) continue;
            ((ClassMappingEntryImpl)object4).postProcess2(this);
        }
        iterator = object.iterator();
        while (iterator.hasNext()) {
            object4 = (XmlMappingEntry)iterator.next();
            if (!(object4 instanceof ClassMappingEntryImpl)) continue;
            ((ClassMappingEntryImpl)object4).postProcess3(this);
        }
        this._bBeenPostProcessed = true;
    }

    public Object unMarshalByClass(String string, XmlInputStream xmlInputStream) throws UnMarshallingException {
        XmlMappingEntry xmlMappingEntry = this.get(string);
        if (xmlMappingEntry == null) {
            xmlMappingEntry = this.addClass(string);
        }
        if (xmlMappingEntry == null) {
            throw new UnMarshallingException(xmlInputStream, "Could not find class in registry: " + string);
        }
        return xmlMappingEntry.unMarshalObject(xmlInputStream);
    }

    public void marshalByClass(Object object, XmlOutputStream xmlOutputStream) throws MarshallingException {
        XmlMappingEntry xmlMappingEntry = this.get(object.getClass().getName());
        if (xmlMappingEntry == null && (xmlMappingEntry = this.addClass(object.getClass().getName())) == null) {
            throw new MarshallingException("Could not add class to registry: " + object.getClass().getName());
        }
        xmlMappingEntry.marshalObject(object, xmlOutputStream);
    }

    private XmlMappingEntry addClass(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (Exception exception) {
            return null;
        }
        try {
            if (Class.forName("com.esri.axl.marshal.SelfMarshalling").isAssignableFrom(clazz)) {
                SelfMarshallingEntryImpl selfMarshallingEntryImpl = new SelfMarshallingEntryImpl(string, (XmlMappingRegistry)this);
                this.add(selfMarshallingEntryImpl);
                return selfMarshallingEntryImpl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            IntrospectMappingEntryImpl introspectMappingEntryImpl = new IntrospectMappingEntryImpl(string, (XmlMappingRegistry)this);
            introspectMappingEntryImpl.initialize(this);
            this.add(introspectMappingEntryImpl);
            return introspectMappingEntryImpl;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clear() {
        this._entries.clear();
    }

    public void addReference(FieldMapping fieldMapping) {
        this._references.put(fieldMapping.getReferenceName(), fieldMapping);
    }

    public FieldMapping getReference(String string) {
        return (FieldMapping)this._references.get(string);
    }

    public Iterator fieldReferences() {
        return this._references.values().iterator();
    }

    public void addEnumeration(EnumerationMapping enumerationMapping) {
        this._enumerations.put(enumerationMapping.getName(), enumerationMapping);
    }

    public EnumerationMapping getEnumeration(String string) {
        return (EnumerationMapping)this._enumerations.get(string);
    }

    public Iterator enumerations() {
        return this._enumerations.values().iterator();
    }

    public void addSimpleType(SimpleTypeMarshaller simpleTypeMarshaller) {
        this._simpleTypes.put(simpleTypeMarshaller.getName(), simpleTypeMarshaller);
    }

    public SimpleTypeMarshaller getSimpleType(String string) {
        return (SimpleTypeMarshaller)this._simpleTypes.get(string);
    }

    public Iterator simpleTypes() {
        return this._simpleTypes.values().iterator();
    }

    public String getIntrospectionNamespaceURI() {
        return this._introspectionURI;
    }

    public void setIntrospectionNamespaceURI(String string) {
        this._introspectionURI = string == null ? null : string.toString();
    }

    public String[] getAllURIs() {
        String[] stringArray = new String[this._allURIs.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)this._allURIs.get(n);
            ++n;
        }
        return stringArray;
    }

    public void addURI(String string) {
        int n = 0;
        while (n < this._allURIs.size()) {
            if (string.equals((String)this._allURIs.get(n))) {
                return;
            }
            ++n;
        }
        this._allURIs.add(string);
    }
}

