/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.BaseXmlMappingEntry;
import com.esri.axl.mapping.XmlMappingRegistry;
import com.esri.axl.marshal.Marshaller;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlOutputStream;

public class HelperMarshallingEntryImpl
extends BaseXmlMappingEntry {
    private Marshaller _marshaller;
    private String _helperClassName;

    public HelperMarshallingEntryImpl(String string, XmlMappingRegistry xmlMappingRegistry) {
        super(string, xmlMappingRegistry);
    }

    public HelperMarshallingEntryImpl(String string, String string2, XmlMappingRegistry xmlMappingRegistry) {
        super(string, xmlMappingRegistry);
        this._helperClassName = string2;
    }

    public HelperMarshallingEntryImpl(Class clazz, Class clazz2, XmlMappingRegistry xmlMappingRegistry) {
        super(clazz.getName(), xmlMappingRegistry);
        this._helperClassName = clazz2.getName();
    }

    private void getMarshaller() {
        if (this._marshaller == null) {
            try {
                Class<?> clazz = Class.forName(this._helperClassName);
                this._marshaller = (Marshaller)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void marshalObject(Object object, XmlOutputStream xmlOutputStream) throws MarshallingException {
        this.getMarshaller();
        if (this._marshaller == null) {
            throw new MarshallingException("Helper Marshaller error. Helper class:" + this._helperClassName + "  Entry Class:" + this._className);
        }
        this._marshaller.marshalObject(object, xmlOutputStream);
    }

    public Object unMarshalObject(XmlInputStream xmlInputStream) throws UnMarshallingException {
        this.getMarshaller();
        if (this._marshaller == null) {
            throw new UnMarshallingException(xmlInputStream, "Helper Marshaller error. Helper class:" + this._helperClassName + "  Entry Class:" + this._className);
        }
        return this._marshaller.unMarshalObject(xmlInputStream);
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        xmlInputStream.nextNode();
        if (xmlInputStream.getNodeType() != 3) {
            throw new UnMarshallingException(xmlInputStream, "Unmatched class tag in class:" + this._className);
        }
        xmlInputStream.nextNode();
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "class");
        xmlOutputStream.writeAttribute(xmlOutputStream.getMapping().getMappingFileURI(), "name", this._className);
        xmlOutputStream.writeAttribute(xmlOutputStream.getMapping().getMappingFileURI(), "method", "helper");
        xmlOutputStream.writeAttribute(xmlOutputStream.getMapping().getMappingFileURI(), "helperClass", this._helperClassName);
        xmlOutputStream.writeEndTag();
    }
}

