/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.ClassMapping;
import com.esri.axl.mapping.EnumerationMapping;
import com.esri.axl.mapping.FieldMapping;
import com.esri.axl.mapping.SimpleTypeMarshaller;
import com.esri.axl.mapping.XmlMappingEntry;
import com.esri.axl.mapping.XmlPart;
import com.esri.axl.marshal.FieldAccessor;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlName;
import com.esri.axl.marshal.XmlOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class FieldMappingImpl
implements FieldMapping {
    private static final int DOUBLE_TYPE = 0;
    private static final int INTEGER_TYPE = 1;
    private static final int SHORT_TYPE = 2;
    private static final int LONG_TYPE = 3;
    private static final int CHAR_TYPE = 4;
    private static final int BYTE_TYPE = 5;
    private static final int BOOLEAN_TYPE = 6;
    private static final int FLOAT_TYPE = 7;
    private static final int OBJECT_TYPE = 8;
    private SimpleTypeMarshaller _simpleType;
    private String _fieldName;
    private String _fieldClassName;
    private Class _fieldClass;
    private String _referenceName;
    private String _fieldSetMethodName;
    private Method _fieldSetMethod;
    private boolean _bSetIsIgnored;
    private String _fieldGetMethodName;
    private Method _fieldGetMethod;
    private boolean _bGetIsIgnored;
    private String _collectionClassName;
    private Class _collectionClass;
    private ClassMapping _containingClassMapping;
    private boolean _bIsArray;
    private boolean _bIsPrimitive;
    private boolean _bIsNullable;
    private boolean _bIsOptional;
    private boolean _bIsIgnored;
    private boolean _bClassMappingWasChecked;
    private boolean _isIndexed;
    private boolean _isIterator;
    private String _default;
    private int _type;
    private Constructor _simpleConstructor;
    private XmlName _xmlName;
    private XmlPart _part;
    private ClassMapping _fieldClassMapping;
    private EnumerationMapping _enumMapping;
    private int _minOccurs;
    private int _maxOccurs;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;

    public String getReferenceName() {
        return this._referenceName;
    }

    public FieldMappingImpl(ClassMapping classMapping) {
        this._containingClassMapping = classMapping;
        this._type = -1;
        this._bIsNullable = false;
        this._bIsOptional = false;
        this._default = null;
        this._part = null;
        this._bClassMappingWasChecked = false;
        this._bSetIsIgnored = false;
        this._bGetIsIgnored = false;
        this._minOccurs = 1;
        this._maxOccurs = 1;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public XmlName getXmlName() {
        return this._xmlName;
    }

    public String getSetMethodName() {
        if (this._fieldSetMethodName == null) {
            this._fieldSetMethodName = "set" + Character.toUpperCase(this._fieldName.charAt(0)) + this._fieldName.substring(1);
        }
        return this._fieldSetMethodName;
    }

    public String getGetMethodName() {
        if (this._bGetIsIgnored) {
            return null;
        }
        if (this._fieldGetMethodName == null) {
            this._fieldGetMethodName = this.getAutoGetMethodName();
        }
        return this._fieldGetMethodName;
    }

    private String getAutoGetMethodName() {
        return "get" + this.getAutoMethodName();
    }

    private String getAutoSetMethodName() {
        return "set" + this.getAutoMethodName();
    }

    private String getAutoMethodName() {
        return Character.toUpperCase(this._fieldName.charAt(0)) + this._fieldName.substring(1);
    }

    public boolean isAttribute() {
        return this._part == XmlPart.ATTRIBUTE;
    }

    public boolean isContent() {
        return this._part == XmlPart.CONTENT;
    }

    public boolean isElement() {
        return this._part == XmlPart.ELEMENT;
    }

    private boolean isReallyElement() {
        if (this._part != XmlPart.ELEMENT) {
            if (this.getFieldClassMapping() == null) {
                return false;
            }
            return this.getFieldClassMapping().isElementClass();
        }
        return true;
    }

    private Method getSetMethod() throws NoSuchMethodException {
        if (this._fieldSetMethod == null) {
            Class clazz;
            boolean bl;
            Class<?> clazz2;
            String string = this.getSetMethodName();
            int n = string.lastIndexOf(46);
            ClassMapping classMapping = this.getContainingClassMapping();
            try {
                clazz2 = classMapping.getEntryClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException("Class not found: " + classMapping.getClassName());
            }
            if (n == -1) {
                bl = false;
            } else {
                try {
                    clazz2 = Class.forName(string.substring(0, n));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchMethodException("Class not found: " + string.substring(0, n));
                }
                string = string.substring(n + 1);
                bl = true;
            }
            Class[] classArray = bl ? new Class[2] : new Class[1];
            try {
                clazz = this.getActualFieldClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException("Class not found: " + this.getFieldClassName());
            }
            if (bl) {
                try {
                    classArray[0] = this.getContainingClassMapping().getEntryClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchMethodException("Class not found: " + this.getContainingClassMapping().getClassName());
                }
                classArray[1] = clazz;
            } else {
                classArray[0] = clazz;
            }
            try {
                this._fieldSetMethod = clazz2.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodException("Field set method not found for field " + this._fieldName + " in class " + this.getContainingClassMapping().getClassName());
            }
        }
        return this._fieldSetMethod;
    }

    private Method getGetMethod() throws NoSuchMethodException {
        if (this._fieldGetMethod == null) {
            Class[] classArray;
            Class<?> clazz;
            String string = this.getGetMethodName();
            int n = string.lastIndexOf(46);
            ClassMapping classMapping = this.getContainingClassMapping();
            try {
                clazz = classMapping.getEntryClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException("Class not found: " + classMapping.getClassName());
            }
            try {
                Class clazz2 = this.getActualFieldClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchMethodException("Class not found: " + this.getFieldClassName());
            }
            if (n == -1) {
                classArray = this._isIndexed ? new Class[]{Integer.TYPE} : null;
            } else {
                try {
                    clazz = Class.forName(string.substring(0, n));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchMethodException("Class not found: " + string.substring(0, n));
                }
                string = string.substring(n + 1);
                if (this._isIndexed) {
                    classArray = new Class[2];
                    classArray[1] = Integer.TYPE;
                } else {
                    classArray = new Class[1];
                }
                try {
                    classArray[0] = this.getContainingClassMapping().getEntryClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoSuchMethodException("Class not found: " + classMapping.getClassName());
                }
            }
            try {
                this._fieldGetMethod = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new NoSuchMethodException("Get method not found for field " + this._fieldName + " in class " + classMapping.getClassName());
            }
        }
        return this._fieldGetMethod;
    }

    public boolean usesElement(XmlInputStream xmlInputStream) throws UnMarshallingException {
        if (this._xmlName != null) {
            return this._xmlName.isEqual(xmlInputStream.getStartTagURI(), xmlInputStream.getStartTag());
        }
        if (this.getFieldClassMapping() == null) {
            return false;
        }
        return this._fieldClassMapping.matches(xmlInputStream) != null;
    }

    private ClassMapping findClassMapping(XmlInputStream xmlInputStream) throws UnMarshallingException {
        return this.getFieldClassMapping().matches(xmlInputStream);
    }

    private Class findClass(XmlInputStream xmlInputStream) throws UnMarshallingException {
        if (this.isElement()) {
            if (this._xmlName.isEqual(xmlInputStream.getStartTagURI(), xmlInputStream.getStartTag())) {
                return this.getFieldClass();
            }
            return null;
        }
        if (this.isAttribute()) {
            return this.getFieldClass();
        }
        ClassMapping classMapping = this.findClassMapping(xmlInputStream);
        if (classMapping == null) {
            return null;
        }
        try {
            return classMapping.getEntryClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnMarshallingException(xmlInputStream, "Class not found for class: " + classMapping.getClassName());
        }
    }

    private XmlName findTag(Class clazz) throws MarshallingException {
        ClassMapping classMapping = this.findMapping(clazz, this.getFieldClassMapping());
        if (classMapping == null) {
            return null;
        }
        return classMapping.getStartTag();
    }

    private ClassMapping findMapping(Class clazz, ClassMapping classMapping) throws MarshallingException {
        try {
            if (classMapping.getEntryClass() == clazz) {
                return classMapping;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MarshallingException("Class not found for class: " + classMapping.getClassName());
        }
        Vector vector = classMapping.derivedClasses();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ClassMapping classMapping2 = this.findMapping(clazz, (ClassMapping)vector.get(n));
                if (classMapping2 != null) {
                    return classMapping2;
                }
                ++n;
            }
        }
        return null;
    }

    public String getFieldClassName() {
        return this._fieldClassName;
    }

    public Class getFieldClass() {
        if (this._fieldClass == null) {
            try {
                this.getFieldType();
                if (this._fieldClass == null) {
                    this._fieldClass = Class.forName(this.getFieldClassName());
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this._fieldClass;
    }

    private Constructor getSimpleConstructor() throws UnMarshallingException {
        if (this._simpleConstructor == null) {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FieldMappingImpl.class$("java.lang.String")) : class$java$lang$String};
            try {
                this._simpleConstructor = this.getFieldClass().getConstructor(classArray);
            }
            catch (Exception exception) {
                throw new UnMarshallingException("Could not find constructor for field " + this.getFieldName() + " for class " + this.getFieldClassName());
            }
        }
        return this._simpleConstructor;
    }

    public String getCollectionClassName() {
        return this._collectionClassName;
    }

    private Class getCollectionClass() throws ClassNotFoundException {
        if (this.getCollectionClassName() == null) {
            return null;
        }
        if (this.isArray()) {
            return null;
        }
        if (this._collectionClass == null) {
            this._collectionClass = Class.forName(this.getCollectionClassName());
        }
        return this._collectionClass;
    }

    public boolean isCollection() {
        try {
            return this.getCollectionClass() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isArray() {
        return this._bIsArray;
    }

    public boolean isPrimitive() {
        try {
            this.getFieldType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return this._type != 8;
    }

    public ClassMapping getContainingClassMapping() {
        return this._containingClassMapping;
    }

    public void marshalFieldObject(Object object, XmlOutputStream xmlOutputStream) throws MarshallingException {
        if (this.marshalElementFields(object, xmlOutputStream, false) == 0) {
            throw new MarshallingException("Null value not allowed for field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
    }

    public void unMarshalFieldObject(Object object, XmlInputStream xmlInputStream) throws UnMarshallingException {
        Object object2 = this.unMarshalField(xmlInputStream);
        this.assignFieldObject(object, object2);
    }

    public void assignFieldObject(Object object, Object object2) throws UnMarshallingException {
        Object object3;
        Object[] objectArray;
        Method method;
        if (this._bSetIsIgnored) {
            return;
        }
        if (this.isIgnored()) {
            return;
        }
        try {
            method = this.getSetMethod();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.out.println(noSuchMethodException.getMessage());
            throw new UnMarshallingException(noSuchMethodException.getMessage());
        }
        if (Modifier.isStatic(method.getModifiers())) {
            objectArray = new Object[2];
            objectArray[1] = object2;
            objectArray[0] = object;
            object3 = null;
        } else {
            objectArray = new Object[]{object2};
            object3 = object;
        }
        try {
            method.invoke(object3, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnMarshallingException("Non-public set method.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnMarshallingException("Illegal argument invoking set method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnMarshallingException("Set method threw an exception.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object unMarshalField(XmlInputStream xmlInputStream) throws UnMarshallingException {
        Object object = null;
        if (this.isAttribute()) {
            String string = xmlInputStream.getAttributeValue(this._xmlName);
            if (string == null) {
                if (this.hasDefault()) {
                    string = this.getDefault();
                    object = this.unMarshalString(xmlInputStream, string);
                } else if (!this.isNullable()) {
                    if (!this.isOptional()) throw new UnMarshallingException(xmlInputStream, "Attribute tag <" + this._xmlName.getName() + "> not present for field " + this.getFieldName() + " in class " + this.getContainingClassMapping().getClassName());
                    object = null;
                }
            } else {
                object = this.unMarshalString(xmlInputStream, string);
            }
        } else if (this.isContent()) {
            String string = null;
            if (xmlInputStream.getNodeType() == 4) {
                string = xmlInputStream.getContent();
            }
            if (string == null) {
                if (this.hasDefault()) {
                    string = this.getDefault();
                    object = this.unMarshalString(xmlInputStream, string);
                } else if (!this.isNullable()) {
                    if (!this.isOptional()) throw new UnMarshallingException(xmlInputStream, "Content not present for field " + this.getFieldName() + " in class " + this.getContainingClassMapping().getClassName());
                    object = null;
                }
            } else {
                object = this.unMarshalString(xmlInputStream, string);
            }
            if (xmlInputStream.getNodeType() == 4) {
                xmlInputStream.nextNode();
            }
        } else if (!this.isReallyElement()) {
            object = xmlInputStream.unMarshal(this.getFieldClass());
        } else {
            Class clazz = this.findClass(xmlInputStream);
            if (clazz != null) {
                if (this.isArray() || this.isCollection()) {
                    if (this.isArray()) {
                        Vector<Object> vector = new Vector<Object>();
                        int n = 0;
                        while (clazz != null) {
                            if (++n > this.getMaxOccurs()) {
                                throw new UnMarshallingException(xmlInputStream, "Too many elements (exceeded maxOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            if (n < this.getMinOccurs()) {
                                throw new UnMarshallingException(xmlInputStream, "Not enough elements (less than minOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            vector.add(xmlInputStream.unMarshal(clazz));
                            if (xmlInputStream.getNodeType() != 2) break;
                            clazz = this.findClass(xmlInputStream);
                        }
                        if (n < this.getMinOccurs()) {
                            throw new UnMarshallingException(xmlInputStream, "Not enough elements (less than minOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                        }
                        Object object2 = Array.newInstance(this.getFieldClass(), vector.size());
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            Array.set(object2, n2, vector.get(n2));
                            ++n2;
                        }
                        object = object2;
                    } else {
                        Collection collection;
                        try {
                            collection = (Collection)this.getCollectionClass().newInstance();
                        }
                        catch (Exception exception) {
                            throw new UnMarshallingException(xmlInputStream, "Error instantiating collection class.");
                        }
                        int n = 0;
                        while (clazz != null) {
                            if (++n > this.getMaxOccurs()) {
                                throw new UnMarshallingException(xmlInputStream, "Too many elements (exceeded maxOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            if (n < this.getMinOccurs()) {
                                throw new UnMarshallingException(xmlInputStream, "Not enough elements (less than minOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            collection.add(xmlInputStream.unMarshal(clazz));
                            if (xmlInputStream.getNodeType() != 2) break;
                            clazz = this.findClass(xmlInputStream);
                        }
                        if (n < this.getMinOccurs()) {
                            throw new UnMarshallingException(xmlInputStream, "Not enough elements (less than minOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
                        }
                        object = collection;
                    }
                } else {
                    object = xmlInputStream.unMarshal(clazz);
                }
            } else if (0 < this.getMinOccurs()) {
                throw new UnMarshallingException(xmlInputStream, "Not enough elements (less than minOccurs) for field " + this.getFieldName() + " in class " + this.getContainClassName());
            }
        }
        if (this._referenceName == null) return object;
        xmlInputStream.getPropertySet().addProperty(this._referenceName, object);
        return object;
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "field");
        xmlOutputStream.writeAttribute("name", this._fieldName);
        if (this._enumMapping != null) {
            xmlOutputStream.writeAttribute("enumeration", this._enumMapping.getName());
        } else if (this._simpleType == null) {
            xmlOutputStream.writeAttribute("class", this._fieldClassName);
        } else {
            xmlOutputStream.writeAttribute("class", this._simpleType.getName());
        }
        if (this._collectionClassName != null) {
            xmlOutputStream.writeAttribute("collection", this._collectionClassName);
        }
        if (this.isOptional()) {
            xmlOutputStream.writeAttribute("optional", "true");
        }
        if (this.isNullable()) {
            xmlOutputStream.writeAttribute("nillable", "true");
        }
        if (this.hasDefault()) {
            xmlOutputStream.writeAttribute("default", this._default);
        }
        if (this.isAttribute()) {
            xmlOutputStream.writeAttribute("attribute", this._xmlName.getPrefixedName(xmlOutputStream));
        } else if (this.isElement()) {
            xmlOutputStream.writeAttribute("element", this._xmlName.getPrefixedName(xmlOutputStream));
        } else if (this.isContent()) {
            xmlOutputStream.writeAttribute("content", "true");
        }
        if (this._bSetIsIgnored) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "set");
            xmlOutputStream.writeAttribute("ignore", "true");
            xmlOutputStream.writeEndTag();
        } else if (!this.getAutoSetMethodName().equals(this._fieldSetMethodName)) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "set");
            xmlOutputStream.writeAttribute("method", this._fieldSetMethodName);
            xmlOutputStream.writeEndTag();
        }
        if (this._bGetIsIgnored) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "get");
            xmlOutputStream.writeAttribute("ignore", "true");
            xmlOutputStream.writeEndTag();
        } else if (!this.getAutoGetMethodName().equals(this._fieldGetMethodName)) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "get");
            xmlOutputStream.writeAttribute("method", this._fieldGetMethodName);
            xmlOutputStream.writeEndTag();
        }
        xmlOutputStream.writeEndTag();
    }

    public ClassMapping getFieldClassMapping() {
        if (!this._bClassMappingWasChecked) {
            XmlMappingEntry xmlMappingEntry = this._containingClassMapping.getRegistry().get(this._fieldClassName);
            if (xmlMappingEntry == null && !this.isContent() && !this.isAttribute()) {
                System.out.println("Could not find registry entry for class " + this._fieldClassName);
            }
            if (xmlMappingEntry instanceof ClassMapping) {
                this._fieldClassMapping = (ClassMapping)xmlMappingEntry;
            }
            this._bClassMappingWasChecked = true;
        }
        return this._fieldClassMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        String string;
        String string2;
        this._minOccurs = 1;
        this._maxOccurs = 1;
        HashMap hashMap = (HashMap)xmlInputStream.getPropertySet().getProperty("Aliases");
        HashMap hashMap2 = (HashMap)xmlInputStream.getPropertySet().getProperty("SimpleTypes");
        this._fieldName = xmlInputStream.getAttributeValue("name");
        if (this._fieldName == null) {
            throw new UnMarshallingException(xmlInputStream, "Field name not given.");
        }
        this._fieldClassName = xmlInputStream.getAttributeValue("class");
        if (this._fieldClassName == null) {
            string2 = xmlInputStream.getAttributeValue("enumeration");
            if (string2 == null) {
                throw new UnMarshallingException(xmlInputStream, "Field needs to be enumeration or class.  Field name: " + this._fieldName);
            }
            this._enumMapping = xmlInputStream.getMapping().getEnumeration(string2);
            if (this._enumMapping == null) {
                throw new UnMarshallingException(xmlInputStream, "Could not find enumeration: " + string2);
            }
            this._fieldClassName = this._enumMapping.getClassName();
        }
        this._simpleType = xmlInputStream.getMapping().getSimpleType(this._fieldClassName);
        if (this._simpleType != null) {
            this._fieldClassName = this._simpleType.getClassName();
        } else if (hashMap != null && hashMap.containsKey(this._fieldClassName)) {
            this._fieldClassName = (String)hashMap.get(this._fieldClassName);
        }
        this._collectionClassName = xmlInputStream.getAttributeValue("collection");
        this._bIsArray = false;
        if (this._collectionClassName != null) {
            if (hashMap != null && hashMap.containsKey(this._collectionClassName)) {
                this._collectionClassName = (String)hashMap.get(this._collectionClassName);
                this._maxOccurs = Integer.MAX_VALUE;
            } else if (this._collectionClassName.equals("array")) {
                this._bIsArray = true;
                this._maxOccurs = Integer.MAX_VALUE;
            }
        }
        this._default = xmlInputStream.getAttributeValue("default");
        string2 = xmlInputStream.getAttributeValue("optional");
        if (string2 != null) {
            if (string2.equals("true")) {
                this._bIsOptional = true;
                this._minOccurs = 0;
            } else {
                if (!string2.equals("false")) throw new UnMarshallingException(xmlInputStream, "Bad value for attribute 'optional'");
                this._bIsOptional = false;
            }
        } else {
            this._bIsOptional = false;
        }
        this._referenceName = xmlInputStream.getAttributeValue("reference");
        if (this._referenceName != null) {
            xmlInputStream.getMapping().addReference(this);
        }
        if ((string2 = xmlInputStream.getAttributeValue("nillable")) != null) {
            if (string2.equals("true")) {
                this._bIsNullable = true;
                this._minOccurs = 0;
            } else {
                if (!string2.equals("false")) throw new UnMarshallingException(xmlInputStream, "Bad value for attribute 'nillable'");
                this._bIsNullable = false;
            }
        } else {
            this._bIsNullable = false;
        }
        string2 = xmlInputStream.getAttributeValue("minOccurs");
        if (string2 != null) {
            this._minOccurs = Integer.parseInt(string2);
        }
        if ((string2 = xmlInputStream.getAttributeValue("maxOccurs")) != null) {
            this._maxOccurs = Integer.parseInt(string2);
        }
        string2 = xmlInputStream.getAttributeValue("incremental");
        this._isIndexed = false;
        this._isIterator = false;
        if (string2 != null) {
            if (string2.equals("index")) {
                this._isIndexed = true;
                this.getContainingClassMapping().setHasIncrementalFields();
            } else {
                if (!string2.equals("iterator")) throw new UnMarshallingException(xmlInputStream, "Bad value for attribute 'incremental'");
                this._isIterator = true;
                this.getContainingClassMapping().setHasIncrementalFields();
            }
        }
        if ((string = xmlInputStream.getAttributeValue("element")) != null) {
            this._part = XmlPart.ELEMENT;
            this._xmlName = new XmlName(xmlInputStream, string);
            if (this._xmlName.getURI() == null && xmlInputStream.isNamespaceAware()) {
                throw new UnMarshallingException(xmlInputStream, "Element has no namespace: " + this._xmlName.getName());
            }
        } else {
            string = xmlInputStream.getAttributeValue("attribute");
            if (string != null) {
                this._part = XmlPart.ATTRIBUTE;
                this._xmlName = new XmlName(xmlInputStream, string);
            } else {
                string2 = xmlInputStream.getAttributeValue("content");
                if (string2 != null && string2.equals("true")) {
                    this._part = XmlPart.CONTENT;
                }
            }
        }
        xmlInputStream.nextNode();
        while (xmlInputStream.getNodeType() == 2) {
            String string3;
            if (xmlInputStream.getStartTag().equals("set")) {
                this._fieldSetMethodName = xmlInputStream.getAttributeValue("method");
                string3 = xmlInputStream.getAttributeValue("ignore");
                if (string3 != null && string3.equals("true")) {
                    this._bSetIsIgnored = true;
                }
            }
            if (xmlInputStream.getStartTag().equals("get")) {
                this._fieldGetMethodName = xmlInputStream.getAttributeValue("method");
                string3 = xmlInputStream.getAttributeValue("ignore");
                if (string3 != null && string3.equals("true")) {
                    this._bGetIsIgnored = true;
                }
            }
            xmlInputStream.nextNode();
            xmlInputStream.nextNode();
        }
        xmlInputStream.nextNode();
    }

    private Integer getAndIncrementCount(Object object, boolean bl) {
        if (bl) {
            FieldAccessor fieldAccessor = (FieldAccessor)object;
            int n = fieldAccessor.getFieldIndex(this);
            if (n == -1) {
                n = fieldAccessor.addField(this, null);
            }
            int n2 = fieldAccessor.getCount(n);
            fieldAccessor.incrementCount(n);
            return new Integer(n2);
        }
        return new Integer(0);
    }

    private String objectToString(XmlOutputStream xmlOutputStream, Object object) throws MarshallingException {
        if (this._simpleType == null) {
            return object.toString();
        }
        return this._simpleType.objectToString(xmlOutputStream, object);
    }

    private String getFieldAsString(XmlOutputStream xmlOutputStream, Object object, boolean bl) throws MarshallingException {
        int n;
        Object object2 = bl ? ((FieldAccessor)object).getObject() : object;
        try {
            n = this.getFieldType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MarshallingException("Error getting field type and constructor for field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
        if (this.isArray()) {
            StringBuffer stringBuffer = new StringBuffer();
            Object object3 = this.invokeGetMethod(object, bl);
            if (object3 == null) {
                return null;
            }
            if (!this.isPrimitive()) {
                Object[] objectArray = (Object[])object3;
                if (objectArray.length > 0) {
                    stringBuffer.append(this.valueToString(this.objectToString(xmlOutputStream, objectArray[0])));
                }
                int n2 = 1;
                while (n2 < objectArray.length) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.valueToString(this.objectToString(xmlOutputStream, objectArray[n2])));
                    ++n2;
                }
            } else {
                switch (n) {
                    case 0: {
                        double[] dArray = (double[])object3;
                        if (dArray.length > 0) {
                            stringBuffer.append(this.valueToString(Double.toString(dArray[0])));
                        }
                        int n3 = 1;
                        while (n3 < dArray.length) {
                            stringBuffer.append(" ");
                            stringBuffer.append(this.valueToString(Double.toString(dArray[n3])));
                            ++n3;
                        }
                        break;
                    }
                    case 1: {
                        int[] nArray = (int[])object3;
                        if (nArray.length > 0) {
                            stringBuffer.append(this.valueToString(Integer.toString(nArray[0])));
                        }
                        int n4 = 1;
                        while (n4 < nArray.length) {
                            stringBuffer.append(" ");
                            stringBuffer.append(this.valueToString(Integer.toString(nArray[n4])));
                            ++n4;
                        }
                        break;
                    }
                    case 3: {
                        long[] lArray = (long[])object3;
                        if (lArray.length > 0) {
                            stringBuffer.append(this.valueToString(Long.toString(lArray[0])));
                        }
                        int n5 = 1;
                        while (n5 < lArray.length) {
                            stringBuffer.append(" ");
                            stringBuffer.append(this.valueToString(Long.toString(lArray[n5])));
                            ++n5;
                        }
                        break;
                    }
                    case 2: {
                        short[] sArray = (short[])object3;
                        if (sArray.length > 0) {
                            stringBuffer.append(this.valueToString(Short.toString(sArray[0])));
                        }
                        int n6 = 1;
                        while (n6 < sArray.length) {
                            stringBuffer.append(" ");
                            stringBuffer.append(this.valueToString(Short.toString(sArray[n6])));
                            ++n6;
                        }
                        break;
                    }
                    case 7: {
                        float[] fArray = (float[])object3;
                        if (fArray.length > 0) {
                            stringBuffer.append(this.valueToString(Float.toString(fArray[0])));
                        }
                        int n7 = 1;
                        while (n7 < fArray.length) {
                            stringBuffer.append(" ");
                            stringBuffer.append(this.valueToString(Float.toString(fArray[n7])));
                            ++n7;
                        }
                        break;
                    }
                }
            }
            return stringBuffer.toString();
        }
        if (this.isCollection()) {
            Collection collection = (Collection)this.invokeGetMethod(object, bl);
            if (collection == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (collection != null) {
                Object e;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    e = iterator.next();
                    stringBuffer.append(this.valueToString(this.objectToString(xmlOutputStream, e)));
                }
                while (iterator.hasNext()) {
                    e = iterator.next();
                    stringBuffer.append(" ");
                    stringBuffer.append(this.valueToString(this.objectToString(xmlOutputStream, e)));
                }
            }
            return stringBuffer.toString();
        }
        Object object4 = this.invokeGetMethod(object, bl);
        if (object4 == null) {
            return null;
        }
        if (object4.getClass() == (class$java$lang$Double == null ? (class$java$lang$Double = FieldMappingImpl.class$("java.lang.Double")) : class$java$lang$Double) && this.getFieldClass() != (class$java$lang$Double == null ? (class$java$lang$Double = FieldMappingImpl.class$("java.lang.Double")) : class$java$lang$Double) && this.getFieldClass() != Double.TYPE) {
            return this.valueToString(Long.toString(((Double)object4).longValue()));
        }
        if (object4.getClass() == (class$java$lang$Float == null ? (class$java$lang$Float = FieldMappingImpl.class$("java.lang.Float")) : class$java$lang$Float) && this.getFieldClass() != (class$java$lang$Float == null ? (class$java$lang$Float = FieldMappingImpl.class$("java.lang.Float")) : class$java$lang$Float) && this.getFieldClass() != Float.TYPE) {
            return this.valueToString(Long.toString(((Float)object4).longValue()));
        }
        return this.valueToString(this.objectToString(xmlOutputStream, object4));
    }

    private String stringToValue(String string) throws UnMarshallingException {
        if (this._enumMapping == null) {
            return string;
        }
        String string2 = this._enumMapping.stringToValue(string);
        if (string2 == null) {
            throw new UnMarshallingException("Not a valid string for enumeration " + this._enumMapping.getName() + " :" + string);
        }
        return string2;
    }

    private String valueToString(String string) throws MarshallingException {
        if (this._enumMapping == null) {
            return string;
        }
        String string2 = this._enumMapping.valueToString(string);
        if (string2 == null) {
            throw new MarshallingException("Not a valid value for enumeration " + this._enumMapping.getName() + " :" + string);
        }
        return string2;
    }

    private void setFieldAsString(XmlInputStream xmlInputStream, Object object, String string) throws UnMarshallingException {
        Object object2 = this.unMarshalString(xmlInputStream, string);
        this.assignFieldObject(object, object2);
    }

    /*
     * Unable to fully structure code
     */
    private Object unMarshalString(XmlInputStream var1_1, String var2_2) throws UnMarshallingException {
        block51: {
            block52: {
                try {
                    var3_3 = this.getFieldType();
                }
                catch (NoSuchMethodException var4_4) {
                    throw new UnMarshallingException(var1_1, "Error getting field type and constructor for field " + this.getFieldName() + " in class " + this.getContainClassName());
                }
                if (!this.isArray() && !this.isCollection()) break block51;
                var4_5 = null;
                var5_7 = new StringTokenizer(var2_2, " ");
                var8_8 = -1;
                var9_9 = null;
                var10_10 = new Object[1];
                var11_11 = null;
                if (!this.isArray()) break block52;
                var7_12 = var5_7.countTokens();
                if (var7_12 == 0) {
                    return null;
                }
                var9_9 = Array.newInstance(this.getFieldClass(), var7_12);
                ** GOTO lbl102
            }
            try {
                var4_5 = (Collection)this.getCollectionClass().newInstance();
                if (true) ** GOTO lbl102
            }
            catch (Exception var19_13) {
                throw new UnMarshallingException(var1_1, "Error instantiating collection class.");
            }
            block30: do {
                ++var8_8;
                var6_20 = this.stringToValue(var5_7.nextToken());
                if (this.isArray()) {
                    if (!this.isPrimitive()) {
                        var10_10[0] = this.stringToObject(var1_1, var6_20);
                        Array.set(var9_9, var8_8, var11_11);
                        continue;
                    }
                    switch (var3_3) {
                        case 6: {
                            if (var6_20.equalsIgnoreCase("true") || var6_20.equals("1")) {
                                var19_14 = true;
                            } else if (var6_20.equalsIgnoreCase("false") || var6_20.equals("0")) {
                                var19_14 = false;
                            } else {
                                throw new UnMarshallingException(var1_1, "Invalid boolean parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            Array.setBoolean(var9_9, var8_8, var19_14);
                            continue block30;
                        }
                        case 0: {
                            if (var6_20.equals("Infinity")) {
                                var12_21 = Infinity;
                            } else if (var6_20.equals("-Infinity")) {
                                var12_21 = -Infinity;
                            } else {
                                try {
                                    var12_21 = Double.parseDouble(var6_20);
                                }
                                catch (NumberFormatException var19_15) {
                                    throw new UnMarshallingException(var1_1, "Invalid double parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                                }
                            }
                            Array.setDouble(var9_9, var8_8, var12_21);
                            continue block30;
                        }
                        case 1: {
                            try {
                                var17_24 = Integer.parseInt(var6_20);
                            }
                            catch (NumberFormatException var19_16) {
                                throw new UnMarshallingException(var1_1, "Invalid integer parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            Array.setInt(var9_9, var8_8, var17_24);
                            continue block30;
                        }
                        case 3: {
                            try {
                                var15_23 = Long.parseLong(var6_20);
                            }
                            catch (NumberFormatException var19_17) {
                                throw new UnMarshallingException(var1_1, "Invalid long parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            Array.setLong(var9_9, var8_8, var15_23);
                            continue block30;
                        }
                        case 2: {
                            try {
                                var18_25 = Short.parseShort(var6_20);
                            }
                            catch (NumberFormatException var19_18) {
                                throw new UnMarshallingException(var1_1, "Invalid parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                            }
                            Array.setShort(var9_9, var8_8, var18_25);
                            continue block30;
                        }
                        case 7: {
                            if (var6_20.equals("Infinity")) {
                                var14_22 = Infinityf;
                            } else if (var6_20.equals("-Infinity")) {
                                var14_22 = -Infinityf;
                            } else {
                                try {
                                    var14_22 = Float.parseFloat(var6_20);
                                }
                                catch (NumberFormatException var19_19) {
                                    throw new UnMarshallingException(var1_1, "Invalid parameter '" + var6_20 + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
                                }
                            }
                            Array.setFloat(var9_9, var8_8, var14_22);
                            continue block30;
                        }
                        default: {
                            throw new UnMarshallingException(var1_1, "Unsupported array field type in field " + this.getFieldName() + " in class " + this.getContainClassName());
                        }
                    }
                }
                if (!this.isCollection()) continue;
                var11_11 = this.stringToObject(var1_1, var6_20);
                var4_5.add(var11_11);
lbl102:
                // 11 sources

            } while (var5_7.hasMoreTokens());
            if (this.isArray()) {
                return var9_9;
            }
            return var4_5;
        }
        var2_2 = this.stringToValue(var2_2);
        var4_6 = null;
        if (var3_3 == 0 || var3_3 == 7) {
            if (var2_2.equals("Infinity")) {
                switch (var3_3) {
                    case 0: {
                        var4_6 = new Double(Infinity);
                        break;
                    }
                    case 7: {
                        var4_6 = new Float(Infinityf);
                    }
                }
            }
            if (var2_2.equals("-Infinity")) {
                switch (var3_3) {
                    case 0: {
                        var4_6 = new Double(-Infinity);
                        break;
                    }
                    case 7: {
                        var4_6 = new Float(-Infinityf);
                    }
                }
            }
        }
        if (var4_6 == null) {
            var4_6 = this.stringToObject(var1_1, var2_2);
        }
        return var4_6;
    }

    private Object stringToObject(XmlInputStream xmlInputStream, String string) throws UnMarshallingException {
        Object t;
        if (this._simpleType != null) {
            return this._simpleType.stringToObject(xmlInputStream, string);
        }
        Object[] objectArray = new Object[]{string};
        try {
            t = this.getSimpleConstructor().newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new UnMarshallingException(xmlInputStream, "Error creating new instance of field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnMarshallingException(xmlInputStream, "Non-public constructor.  Cannot create new instance of field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnMarshallingException(xmlInputStream, "Invalid parameter '" + string + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnMarshallingException(xmlInputStream, "Invalid parameter '" + string + "' for field " + this.getFieldName() + " in class " + this.getContainClassName());
        }
        return t;
    }

    private String getContainClassName() {
        return this.getContainingClassMapping().getClassName();
    }

    private int getFieldType() throws NoSuchMethodException {
        if (this._type == -1) {
            this.setType(this.getFieldClassName());
        }
        return this._type;
    }

    private void setType(String string) throws NoSuchMethodException {
        if (string.equals("double")) {
            this._type = 0;
            this._fieldClass = Double.TYPE;
            this.setConstructor(class$java$lang$Double == null ? (class$java$lang$Double = FieldMappingImpl.class$("java.lang.Double")) : class$java$lang$Double);
        } else if (string.equals("long")) {
            this._type = 3;
            this._fieldClass = Long.TYPE;
            this.setConstructor(class$java$lang$Long == null ? (class$java$lang$Long = FieldMappingImpl.class$("java.lang.Long")) : class$java$lang$Long);
        } else if (string.equals("int")) {
            this._type = 1;
            this._fieldClass = Integer.TYPE;
            this.setConstructor(class$java$lang$Integer == null ? (class$java$lang$Integer = FieldMappingImpl.class$("java.lang.Integer")) : class$java$lang$Integer);
        } else if (string.equals("boolean")) {
            this._type = 6;
            this._fieldClass = Boolean.TYPE;
            this.setConstructor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = FieldMappingImpl.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        } else if (string.equals("byte")) {
            this._type = 5;
            this._fieldClass = Byte.TYPE;
            this.setConstructor(class$java$lang$Byte == null ? (class$java$lang$Byte = FieldMappingImpl.class$("java.lang.Byte")) : class$java$lang$Byte);
        } else if (string.equals("char")) {
            this._type = 4;
            this._fieldClass = Character.TYPE;
            this.setConstructor(class$java$lang$Character == null ? (class$java$lang$Character = FieldMappingImpl.class$("java.lang.Character")) : class$java$lang$Character);
        } else if (string.equals("float")) {
            this._type = 7;
            this._fieldClass = Float.TYPE;
            this.setConstructor(class$java$lang$Float == null ? (class$java$lang$Float = FieldMappingImpl.class$("java.lang.Float")) : class$java$lang$Float);
        } else if (string.equals("short")) {
            this._type = 2;
            this._fieldClass = Short.TYPE;
            this.setConstructor(class$java$lang$Short == null ? (class$java$lang$Short = FieldMappingImpl.class$("java.lang.Short")) : class$java$lang$Short);
        } else {
            this._type = 8;
        }
    }

    private void setConstructor(Class clazz) throws NoSuchMethodException {
        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = FieldMappingImpl.class$("java.lang.String")) : class$java$lang$String};
        this._simpleConstructor = clazz.getConstructor(classArray);
    }

    public boolean isNullable() {
        return this._bIsNullable;
    }

    public boolean isIgnored() {
        return this._bIsIgnored;
    }

    public boolean isSetIgnored() {
        return this._bSetIsIgnored;
    }

    public boolean isGetIgnored() {
        return this._bGetIsIgnored;
    }

    public boolean isSetStatic() throws NoSuchMethodException {
        return Modifier.isStatic(this.getSetMethod().getModifiers());
    }

    public boolean isGetStatic() throws NoSuchMethodException {
        return Modifier.isStatic(this.getGetMethod().getModifiers());
    }

    public boolean hasDefault() {
        return this._default != null;
    }

    public String getDefault() {
        return this._default;
    }

    public boolean isOptional() {
        return this._bIsOptional;
    }

    public Class getActualFieldClass() throws ClassNotFoundException {
        Class<Object> clazz;
        if (this.isArray()) {
            String string = null;
            if (!this.isPrimitive()) {
                string = "[L" + this.getFieldClassName() + ";";
            } else {
                switch (this._type) {
                    case 0: {
                        string = "[D";
                        break;
                    }
                    case 3: {
                        string = "[J";
                        break;
                    }
                    case 1: {
                        string = "[I";
                        break;
                    }
                    case 2: {
                        string = "[S";
                        break;
                    }
                    case 7: {
                        string = "[F";
                        break;
                    }
                    case 5: {
                        string = "[B";
                        break;
                    }
                    case 4: {
                        string = "[C";
                        break;
                    }
                    case 6: {
                        string = "[Z";
                    }
                }
            }
            clazz = Class.forName(string);
        } else {
            clazz = this.isCollection() ? this.getCollectionClass() : this.getFieldClass();
        }
        return clazz;
    }

    public FieldMappingImpl(ClassMapping classMapping, String string, Method method, Method method2, Class clazz, Class clazz2, boolean bl, boolean bl2, String string2) {
        this._containingClassMapping = classMapping;
        this._type = -1;
        this._bIsNullable = true;
        this._bIsOptional = true;
        this._default = null;
        this._part = null;
        this._bClassMappingWasChecked = false;
        this._bSetIsIgnored = false;
        this._bGetIsIgnored = false;
        this._fieldName = string;
        this._fieldClass = clazz;
        this._fieldClassName = clazz.getName();
        if (clazz2 != null) {
            this._collectionClassName = clazz2.getName();
            this._collectionClass = clazz2;
        } else if (bl) {
            this._collectionClassName = "array";
        }
        this._bIsArray = bl;
        this._bIsNullable = false;
        if (bl2) {
            this._xmlName = new XmlName(string2, string.toUpperCase());
            this._part = XmlPart.ELEMENT;
        } else {
            this._xmlName = new XmlName(string2, Character.toLowerCase(string.charAt(0)) + string.substring(1));
            this._part = XmlPart.ATTRIBUTE;
        }
        this._fieldGetMethod = method;
        this._fieldSetMethod = method2;
        this._fieldGetMethodName = method.getName();
        this._fieldSetMethodName = method2.getName();
        this._minOccurs = 1;
        this._maxOccurs = bl ? Integer.MAX_VALUE : 1;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public boolean isModelGroup() {
        return false;
    }

    private Object invokeGetMethod(Object object, boolean bl) throws MarshallingException {
        try {
            Object object2;
            FieldAccessor fieldAccessor = null;
            Iterator iterator = null;
            int n = -1;
            if (bl) {
                object2 = ((FieldAccessor)object).getObject();
                if (this._isIterator && (n = (fieldAccessor = (FieldAccessor)object).getFieldIndex(this)) != -1) {
                    iterator = fieldAccessor.getIterator(n);
                }
            } else {
                object2 = object;
            }
            if (iterator == null) {
                Object object3;
                Object[] objectArray;
                Method method = this.getGetMethod();
                if (Modifier.isStatic(method.getModifiers())) {
                    if (this._isIndexed) {
                        objectArray = new Object[2];
                        objectArray[1] = this.getAndIncrementCount(object, bl);
                    } else {
                        objectArray = new Object[1];
                    }
                    object3 = null;
                    objectArray[0] = object2;
                } else {
                    objectArray = this._isIndexed ? new Object[]{this.getAndIncrementCount(object, bl)} : null;
                    object3 = object2;
                }
                if (!this._isIterator) {
                    return method.invoke(object3, objectArray);
                }
                try {
                    iterator = (Iterator)method.invoke(object3, objectArray);
                }
                catch (ClassCastException classCastException) {
                    throw new MarshallingException("Get method for field " + this._fieldName + " should be of type Iterator.");
                }
                n = fieldAccessor.addField(this, iterator);
            }
            fieldAccessor.incrementCount(n);
            if (iterator != null && iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MarshallingException("Non-public get method.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MarshallingException("Illegal argument invoking get method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new MarshallingException(noSuchMethodException.getMessage());
        }
    }

    public int marshalElementFields(Object object, XmlOutputStream xmlOutputStream, boolean bl) throws MarshallingException {
        if (this._bGetIsIgnored) {
            return 2;
        }
        if (this.isAttribute()) {
            String string = this.getFieldAsString(xmlOutputStream, object, bl);
            if (string == null) {
                if (this.isNullable()) {
                    return 1;
                }
                if (this.isOptional()) {
                    return 1;
                }
                return 0;
            }
            if (this.hasDefault() && string.equals(this.getDefault())) {
                return 1;
            }
            xmlOutputStream.writeAttribute(this._xmlName, string);
            return 1;
        }
        if (this.isContent()) {
            String string = this.getFieldAsString(xmlOutputStream, object, bl);
            if (string == null) {
                if (this.isNullable()) {
                    return 1;
                }
                if (this.isOptional()) {
                    return 1;
                }
                return 0;
            }
            xmlOutputStream.writeContent(string);
            return 1;
        }
        Object object2 = this.invokeGetMethod(object, bl);
        if (object2 == null) {
            if (this.isNullable() || this.isOptional() || this.getMinOccurs() == 0) {
                return 2;
            }
            return 0;
        }
        if (this.isArray()) {
            Object[] objectArray = (Object[])object2;
            int n = 0;
            while (n < objectArray.length) {
                XmlName xmlName = this._xmlName != null ? this._xmlName : this.findTag(objectArray[n].getClass());
                if (xmlName != null) {
                    xmlOutputStream.overwriteStartTag(xmlName);
                }
                xmlOutputStream.marshal(objectArray[n]);
                ++n;
            }
        } else if (this.isCollection()) {
            Collection collection = (Collection)object2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                XmlName xmlName = this._xmlName != null ? this._xmlName : this.findTag(e.getClass());
                if (xmlName != null) {
                    xmlOutputStream.overwriteStartTag(xmlName);
                }
                xmlOutputStream.marshal(e);
            }
        } else {
            if (this._xmlName != null) {
                xmlOutputStream.overwriteStartTag(this._xmlName);
            } else {
                XmlName xmlName = this.findTag(object2.getClass());
                if (xmlName != null) {
                    xmlOutputStream.overwriteStartTag(xmlName);
                }
            }
            xmlOutputStream.marshal(object2);
        }
        return 1;
    }

    public int unMarshalElementFields(Object object, XmlInputStream xmlInputStream, boolean bl) throws UnMarshallingException {
        if (!this.isReallyElement() || this.usesElement(xmlInputStream)) {
            if (bl) {
                Object object2 = this.unMarshalField(xmlInputStream);
                Vector vector = (Vector)object;
                vector.add(this);
                vector.add(object2);
            } else {
                this.unMarshalFieldObject(object, xmlInputStream);
            }
            return 1;
        }
        if (this.getMinOccurs() == 0) {
            return 2;
        }
        return 0;
    }

    public String getParticleName() {
        return FieldMapping.FIELD_TAG;
    }

    public String getName() {
        return this.getFieldName();
    }

    public String getDescriptiveName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getParticleName());
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

