/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.ClassMapping;
import com.esri.axl.mapping.FieldMapping;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.SelfMarshalling;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class ComplexClassConstructor
implements SelfMarshalling {
    private String _methodName;
    private String _className;
    private ClassMapping _classMapping;
    private boolean _bIsConstructor;
    private boolean _bUsesElementFields;
    private boolean _bCheckUseElements;
    private int _parameterCount;
    private String[] _parameterNames;
    private boolean[] _bIsReferences;
    private String[] _castClasses;
    private Constructor _constructor;
    private Method _method;

    public ComplexClassConstructor(ClassMapping classMapping) {
        this._classMapping = classMapping;
        this._methodName = null;
        this._bCheckUseElements = false;
    }

    public String getMethodClassName() {
        return this._className;
    }

    public boolean isConstructor() {
        return this._bIsConstructor;
    }

    private Constructor getConstructor() throws UnMarshallingException {
        if (this._constructor == null) {
            Class[] classArray = this.getClasses();
            try {
                this._constructor = this._classMapping.getEntryClass().getConstructor(classArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnMarshallingException("Class not found: " + this._classMapping.getClassName());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnMarshallingException("Constructor not found: " + this._classMapping.getClassName());
            }
        }
        return this._constructor;
    }

    private Class[] getClasses() throws UnMarshallingException {
        Class[] classArray;
        if (this._parameterCount == 0) {
            classArray = null;
        } else {
            FieldMapping fieldMapping;
            classArray = new Class[this._parameterCount];
            Iterator iterator = this._classMapping.allFields();
            while (iterator.hasNext()) {
                fieldMapping = (FieldMapping)iterator.next();
                int n = this.getParameterOrder(fieldMapping);
                if (n == -1) continue;
                if (this._castClasses[n] != null) {
                    try {
                        classArray[n] = this.getClassUsingName(this._castClasses[n]);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnMarshallingException("Class not found (constructor parameter) for field " + fieldMapping.getFieldName());
                    }
                }
                try {
                    classArray[n] = fieldMapping.getActualFieldClass();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new UnMarshallingException("Class not found (constructor parameter): " + fieldMapping.getFieldName());
                }
            }
            int n = 0;
            while (n < this._parameterCount) {
                if (this._bIsReferences[n]) {
                    fieldMapping = this._classMapping.getRegistry().getReference(this._parameterNames[n]);
                    try {
                        classArray[n] = this._castClasses[n] != null ? this.getClassUsingName(this._castClasses[n]) : fieldMapping.getActualFieldClass();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new UnMarshallingException("Class not found (constructor parameter): " + fieldMapping.getFieldName());
                    }
                }
                ++n;
            }
        }
        return classArray;
    }

    private Method getMethod() throws UnMarshallingException {
        if (this._method == null) {
            Class<?> clazz;
            Class[] classArray = this.getClasses();
            try {
                clazz = Class.forName(this._className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnMarshallingException("Class not found: " + this._className);
            }
            try {
                this._method = clazz.getMethod(this._methodName, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new UnMarshallingException("Constructor method not found: " + this._methodName);
            }
        }
        return this._method;
    }

    public int getParameterCount() {
        return this._parameterCount;
    }

    public int getParameterOrder(FieldMapping fieldMapping) {
        int n = 0;
        while (n < this._parameterCount) {
            if (!this._bIsReferences[n] && fieldMapping.getFieldName().equals(this._parameterNames[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public String getParameterName(int n) {
        return this._parameterNames[n];
    }

    public Object invoke(Object[] objectArray, XmlInputStream xmlInputStream) throws UnMarshallingException {
        try {
            int n = 0;
            while (n < this._parameterCount) {
                if (this._bIsReferences[n]) {
                    objectArray[n] = xmlInputStream.getPropertySet().getProperty(this._parameterNames[n]);
                    if (objectArray[n] == null && !xmlInputStream.getPropertySet().hasProperty(this._parameterNames[n])) {
                        throw new UnMarshallingException(xmlInputStream, "Could not find reference: " + this._parameterNames[n]);
                    }
                }
                ++n;
            }
            if (this._bIsConstructor) {
                return this.getConstructor().newInstance(objectArray);
            }
            return this.getMethod().invoke(null, objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new UnMarshallingException(xmlInputStream, "Error creating new instance of class " + this._classMapping.getClassName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnMarshallingException(xmlInputStream, "Non-public constructor.  Cannot create new instance of class " + this._classMapping.getClassName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnMarshallingException(xmlInputStream, "Invalid parameter for class constructor " + this._classMapping.getClassName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnMarshallingException(xmlInputStream, "The underlying constructor threw an exception: " + this._classMapping.getClassName());
        }
    }

    public boolean usesElementFields() {
        if (!this._bCheckUseElements) {
            Iterator iterator = this._classMapping.elementFields();
            while (iterator.hasNext()) {
                FieldMapping fieldMapping = (FieldMapping)iterator.next();
                if (this.getParameterOrder(fieldMapping) == -1) continue;
                this._bUsesElementFields = true;
                break;
            }
            this._bCheckUseElements = true;
        }
        return this._bUsesElementFields;
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        HashMap hashMap = (HashMap)xmlInputStream.getPropertySet().getProperty("Aliases");
        String string = xmlInputStream.getAttributeValue("method");
        if (string == null) {
            throw new UnMarshallingException(xmlInputStream, "<constructor> has no method attribute.");
        }
        this._bIsConstructor = false;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            this._className = this._classMapping.getClassName();
            n = this._className.lastIndexOf(46);
            if (this._className.substring(n + 1).equals(string)) {
                this._bIsConstructor = true;
            } else {
                this._methodName = string.toString();
            }
        } else {
            this._className = string.substring(0, n);
            if (hashMap != null && hashMap.containsKey(this._className)) {
                this._className = (String)hashMap.get(this._className);
            }
            this._methodName = string.substring(n + 1);
        }
        Vector<Object> vector = new Vector<Object>();
        xmlInputStream.nextNode();
        while (xmlInputStream.getNodeType() == 2) {
            if (xmlInputStream.getStartTag().equals("parameter")) {
                String string2 = xmlInputStream.getAttributeValue("fieldName");
                String string3 = xmlInputStream.getAttributeValue("class");
                if (string2 == null) {
                    string2 = xmlInputStream.getAttributeValue("reference");
                    if (string2 == null) {
                        throw new UnMarshallingException(xmlInputStream, "<parameter> does not have fieldName.");
                    }
                    vector.add(string2);
                    vector.add(Boolean.TRUE);
                    vector.add(string3);
                } else {
                    vector.add(string2);
                    vector.add(Boolean.FALSE);
                    vector.add(string3);
                }
                xmlInputStream.nextNode();
                xmlInputStream.nextNode();
                continue;
            }
            throw new UnMarshallingException("<constructor> has support for parameters only.");
        }
        this._parameterCount = vector.size() / 3;
        if (this._parameterCount != 0) {
            this._parameterNames = new String[this._parameterCount];
            this._bIsReferences = new boolean[this._parameterCount];
            this._castClasses = new String[this._parameterCount];
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                this._parameterNames[n2] = (String)vector.get(n3);
                this._bIsReferences[n2] = (Boolean)vector.get(++n3);
                this._castClasses[n2] = (String)vector.get(++n3);
                if (this._castClasses[n2] != null && hashMap != null && hashMap.containsKey(this._castClasses[n2])) {
                    this._castClasses[n2] = (String)hashMap.get(this._castClasses[n2]);
                }
                ++n2;
                ++n3;
            }
        }
        xmlInputStream.nextNode();
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "constructor");
        StringBuffer stringBuffer = new StringBuffer();
        if (this._className != this._classMapping.getClassName()) {
            stringBuffer.append(this._className);
            stringBuffer.append('.');
        }
        stringBuffer.append(this._methodName);
        if (this._bIsConstructor) {
            xmlOutputStream.writeAttribute("method", this._className.substring(this._className.lastIndexOf(46) + 1));
        } else {
            xmlOutputStream.writeAttribute("method", stringBuffer.toString());
        }
        int n = 0;
        while (n < this._parameterCount) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "parameter");
            if (this._bIsReferences[n]) {
                xmlOutputStream.writeAttribute("reference", this._parameterNames[n]);
            } else {
                xmlOutputStream.writeAttribute("fieldName", this._parameterNames[n]);
            }
            if (this._castClasses[n] != null) {
                xmlOutputStream.writeAttribute("class", this._castClasses[n]);
            }
            xmlOutputStream.writeEndTag();
            ++n;
        }
        xmlOutputStream.writeEndTag();
    }

    private Class getClassUsingName(String string) throws ClassNotFoundException {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals("double")) {
                return Double.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            throw new ClassNotFoundException();
        }
    }
}

