/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.AttributeMatchInfo;
import com.esri.axl.mapping.ClassMapping;
import com.esri.axl.mapping.ElementMatchInfo;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.SelfMarshalling;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlName;
import com.esri.axl.marshal.XmlOutputStream;
import java.util.Vector;

class ClassMatchInfo
implements SelfMarshalling {
    private ElementMatchInfo _exterior;
    private ElementMatchInfo _elementMatches;
    private AttributeMatchInfo[] _attributeMatches;
    private ClassMapping _classMapping;

    ClassMatchInfo(ClassMapping classMapping) {
        this._classMapping = classMapping;
    }

    boolean isElementClass() {
        return this._elementMatches != null;
    }

    XmlName getStartTag() {
        if (this._elementMatches == null) {
            return null;
        }
        return this._elementMatches.getName();
    }

    boolean matches(XmlInputStream xmlInputStream) throws UnMarshallingException {
        if (this._exterior != null && !this._exterior.matches(xmlInputStream, true, false)) {
            return false;
        }
        if (this._attributeMatches != null) {
            int n = 0;
            while (n < this._attributeMatches.length) {
                if (!this._attributeMatches[n].matches(xmlInputStream)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (this._elementMatches != null) {
            return this._elementMatches.matches(xmlInputStream, false, false);
        }
        return true;
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        xmlInputStream.nextNode();
        if (xmlInputStream.getNodeType() == 2) {
            if (xmlInputStream.getStartTag().equals("exterior")) {
                xmlInputStream.nextNode();
                if (xmlInputStream.getNodeType() == 2) {
                    this._exterior = new ElementMatchInfo();
                    if (xmlInputStream.getStartTag().equals("element")) {
                        this._exterior.unMarshal(xmlInputStream);
                    }
                }
                xmlInputStream.nextNode();
            } else if (xmlInputStream.getStartTag().equals("element")) {
                this._elementMatches = new ElementMatchInfo();
                this._elementMatches.unMarshal(xmlInputStream);
            } else if (xmlInputStream.getStartTag().equals("attribute")) {
                Vector<AttributeMatchInfo> vector = new Vector<AttributeMatchInfo>();
                do {
                    AttributeMatchInfo attributeMatchInfo = new AttributeMatchInfo();
                    attributeMatchInfo.unMarshal(xmlInputStream);
                    vector.add(attributeMatchInfo);
                } while (xmlInputStream.getNodeType() == 2);
                this._attributeMatches = new AttributeMatchInfo[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    this._attributeMatches[n] = (AttributeMatchInfo)vector.get(n);
                    ++n;
                }
            }
        }
        if (xmlInputStream.getNodeType() != 3) {
            throw new UnMarshallingException(xmlInputStream, "Unmatched match tag in class:" + this._classMapping.getClassName());
        }
        xmlInputStream.nextNode();
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "match");
        if (this._exterior != null) {
            xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "exterior");
            this._exterior.marshal(xmlOutputStream);
            xmlOutputStream.writeEndTag();
        }
        if (this._elementMatches != null) {
            this._elementMatches.marshal(xmlOutputStream);
        }
        xmlOutputStream.writeEndTag();
    }
}

