/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.mapping.AllModelGroup;
import com.esri.axl.mapping.ChoiceModelGroup;
import com.esri.axl.mapping.ClassMapping;
import com.esri.axl.mapping.ElementModelGroup;
import com.esri.axl.mapping.FieldMappingImpl;
import com.esri.axl.mapping.ModelGroup;
import com.esri.axl.mapping.Particle;
import com.esri.axl.mapping.SequenceModelGroup;
import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.Utils;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlOutputStream;
import java.util.Vector;

public abstract class BaseModelGroup
implements ModelGroup {
    protected ClassMapping _classMapping;
    protected int _minOccurs;
    protected int _maxOccurs;
    protected Particle[] _particles;

    public BaseModelGroup(ClassMapping classMapping) {
        this._classMapping = classMapping;
    }

    public int getMinOccurs() {
        return this._minOccurs;
    }

    public int getMaxOccurs() {
        return this._maxOccurs;
    }

    public boolean isModelGroup() {
        return true;
    }

    public boolean isElement() {
        return false;
    }

    private String getStartTag() {
        switch (this.getType()) {
            case 1: {
                return ModelGroup.ALL_TAG;
            }
            case 0: {
                return ModelGroup.SEQUENCE_TAG;
            }
            case 2: {
                return ModelGroup.CHOICE_TAG;
            }
            case 3: {
                return ModelGroup.ELEMENT_TAG;
            }
        }
        return null;
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), this.getStartTag());
        xmlOutputStream.writeAttribute("minOccurs", Integer.toString(this._minOccurs));
        xmlOutputStream.writeAttribute("maxOccurs", Integer.toString(this._maxOccurs));
        if (this._particles != null) {
            int n = 0;
            while (n < this._particles.length) {
                this._particles[n].marshal(xmlOutputStream);
                ++n;
            }
        }
        xmlOutputStream.writeEndTag();
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        this._minOccurs = Utils.parseOccursInteger(xmlInputStream.getAttributeValue("minOccurs"), 1);
        this._maxOccurs = Utils.parseOccursInteger(xmlInputStream.getAttributeValue("maxOccurs"), 1);
        if (this._maxOccurs <= 0) {
            throw new UnMarshallingException(xmlInputStream, "All model group has bad maxOccurs value");
        }
        if (this._minOccurs < 0 || this._minOccurs > this._maxOccurs) {
            throw new UnMarshallingException(xmlInputStream, "All model group has bad minOccurs value");
        }
        xmlInputStream.nextNode();
        Vector<Particle> vector = new Vector<Particle>();
        while (xmlInputStream.getNodeType() == 2 && (xmlInputStream.getStartTag().equals("field") || xmlInputStream.getStartTag().equals("sequence") || xmlInputStream.getStartTag().equals("all") || xmlInputStream.getStartTag().equals("choice") || xmlInputStream.getStartTag().equals("element"))) {
            BaseModelGroup baseModelGroup;
            if (xmlInputStream.getStartTag().equals("field")) {
                FieldMappingImpl fieldMappingImpl = new FieldMappingImpl(this._classMapping);
                fieldMappingImpl.unMarshal(xmlInputStream);
                if (fieldMappingImpl.isContent() || fieldMappingImpl.isAttribute()) {
                    throw new UnMarshallingException(xmlInputStream, "Field has to be an element field.");
                }
                vector.add(fieldMappingImpl);
                this._classMapping.addField(fieldMappingImpl);
                continue;
            }
            if (xmlInputStream.getStartTag().equals("element")) {
                baseModelGroup = new ElementModelGroup(this._classMapping);
                baseModelGroup.unMarshal(xmlInputStream);
                vector.add(baseModelGroup);
                continue;
            }
            if (xmlInputStream.getStartTag().equals("sequence")) {
                baseModelGroup = new SequenceModelGroup(this._classMapping);
                baseModelGroup.unMarshal(xmlInputStream);
                vector.add(baseModelGroup);
                continue;
            }
            if (xmlInputStream.getStartTag().equals("all")) {
                baseModelGroup = new AllModelGroup(this._classMapping);
                baseModelGroup.unMarshal(xmlInputStream);
                vector.add(baseModelGroup);
                continue;
            }
            if (!xmlInputStream.getStartTag().equals("choice")) continue;
            baseModelGroup = new ChoiceModelGroup(this._classMapping);
            baseModelGroup.unMarshal(xmlInputStream);
            vector.add(baseModelGroup);
        }
        this._particles = null;
        if (vector.size() > 0) {
            this._particles = new Particle[vector.size()];
            int n = 0;
            while (n < this._particles.length) {
                this._particles[n] = (Particle)vector.get(n);
                ++n;
            }
        }
        xmlInputStream.nextNode();
    }

    public Particle[] getParticles() {
        return this._particles;
    }

    public String getName() {
        return null;
    }

    public String getDescriptiveName() {
        return this.getParticleName();
    }
}

