/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.mapping;

import com.esri.axl.marshal.MarshallingException;
import com.esri.axl.marshal.SelfMarshalling;
import com.esri.axl.marshal.UnMarshallingException;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlName;
import com.esri.axl.marshal.XmlOutputStream;

class AttributeMatchInfo
implements SelfMarshalling {
    private XmlName _name;
    private String _value;
    private boolean _bAbsentValue;

    AttributeMatchInfo() {
    }

    XmlName getName() {
        return this._name;
    }

    String getValue() {
        return this._value;
    }

    boolean matches(XmlInputStream xmlInputStream) throws UnMarshallingException {
        if (this._bAbsentValue) {
            return true;
        }
        String string = xmlInputStream.getAttributeValue(this._name);
        if (string == null) {
            return false;
        }
        return string.equals(this._value);
    }

    public void unMarshal(XmlInputStream xmlInputStream) throws UnMarshallingException {
        String string = xmlInputStream.getAttributeValue("name");
        this._name = new XmlName(xmlInputStream, string);
        this._value = xmlInputStream.getAttributeValue("value");
        this._bAbsentValue = this._value == null;
        xmlInputStream.nextNode();
        xmlInputStream.nextNode();
    }

    public void marshal(XmlOutputStream xmlOutputStream) throws MarshallingException {
        xmlOutputStream.writeStartTag(xmlOutputStream.getMapping().getMappingFileURI(), "attribute");
        xmlOutputStream.writeAttribute(xmlOutputStream.getMapping().getMappingFileURI(), "name", this._name.getPrefixedName(xmlOutputStream));
        if (!this._bAbsentValue) {
            xmlOutputStream.writeAttribute(xmlOutputStream.getMapping().getMappingFileURI(), "value", this._value);
        }
        xmlOutputStream.writeEndTag();
    }
}

