/*
 * Decompiled with CFR 0.152.
 */
package com.esri.axl.indiana.xpp;

import com.esri.axl.indiana.sxt.XmlTokenizer;
import com.esri.axl.indiana.sxt.XmlTokenizerException;
import com.esri.axl.indiana.xpp.Attribute;
import com.esri.axl.indiana.xpp.EndTag;
import com.esri.axl.indiana.xpp.StartTag;
import com.esri.axl.indiana.xpp.XmlPullParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class XmlPullParser {
    public static final byte END_DOCUMENT = 1;
    public static final byte START_TAG = 2;
    public static final byte END_TAG = 3;
    public static final byte CONTENT = 4;
    private static final boolean CHECK_ATTRIB_UNIQ = true;
    private boolean emptyElement;
    private boolean seenRootElement;
    private String elContent;
    protected XmlTokenizer tokenizer = new XmlTokenizer();
    protected byte eventType;
    private byte token;
    private boolean supportNs = true;
    private Map prefix2Ns = new HashMap();
    private int attrPosEnd;
    private int attrPosSize;
    private Attribute[] attrPos;
    private int elStackDepth;
    private int elStackSize;
    private ElementContent[] elStack;
    private String _defaultNamespaceURI;

    public void reset() {
        this.tokenizer.reset();
        this.resetState();
    }

    public void setDefaultNamespace(String string) {
        this._defaultNamespaceURI = string;
    }

    private void resetState() {
        this.tokenizer.paramNotifyDoctype = false;
        this.eventType = (byte)-1;
        this.token = (byte)-1;
        this.elStackDepth = 0;
        this.prefix2Ns.clear();
        this.prefix2Ns.put("xml", "http://www.w3.org/XML/1998/namespace");
        if (this._defaultNamespaceURI != null) {
            this.prefix2Ns.put("", this._defaultNamespaceURI);
        }
        this.emptyElement = false;
        this.seenRootElement = false;
    }

    public void setInput(char[] cArray) {
        this.resetState();
        this.tokenizer.setInput(cArray);
    }

    public void setInput(Reader reader) {
        this.resetState();
        this.tokenizer.setInput(reader);
    }

    public void setMixedContent(boolean bl) {
        this.tokenizer.setMixedContent(bl);
    }

    public boolean isNamespaceAware() {
        return this.supportNs;
    }

    public void setNamespaceAware(boolean bl) throws XmlPullParserException {
        if (this.elStackDepth > 0 || this.seenRootElement) {
            throw new XmlPullParserException("namespace support can only be set when not parsing");
        }
        this.supportNs = bl;
    }

    public void setSupportNamespaces(boolean bl) throws XmlPullParserException {
        this.setNamespaceAware(bl);
    }

    public void setHardLimit(int n) throws XmlPullParserException {
        try {
            this.tokenizer.setHardLimit(n);
        }
        catch (XmlTokenizerException xmlTokenizerException) {
            throw new XmlPullParserException("could not set hard limit to " + n, xmlTokenizerException);
        }
    }

    public void setSoftLimit(int n) throws XmlPullParserException {
        try {
            this.tokenizer.setSoftLimit(n);
        }
        catch (XmlTokenizerException xmlTokenizerException) {
            throw new XmlPullParserException("could not set soft limit to " + n, xmlTokenizerException);
        }
    }

    public String getQNameLocal(String string) {
        int n = string.lastIndexOf(58);
        return string.substring(n + 1);
    }

    public String getQNameUri(String string) throws XmlPullParserException {
        if (this.elStackDepth == 0) {
            throw new XmlPullParserException("parsing must be started to get uri from qname");
        }
        int n = string.lastIndexOf(58);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return (String)this.prefix2Ns.get(string2);
        }
        return this.elStack[this.elStackDepth - 1].defaultNs;
    }

    public void setNamespacePrefixes(boolean bl) {
    }

    public int prefixesLentrh() {
        return this.elStack[this.elStackDepth - 1].prefixes.length;
    }

    public String prefixes(int n) {
        return this.elStack[this.elStackDepth - 1].prefixes[n];
    }

    public String[] namespacePrefixes(int n) {
        return this.elStack[this.elStackDepth - 1].prefixes;
    }

    public String prefix2Namespace(String string) {
        return (String)this.prefix2Ns.get(string);
    }

    public byte skipSubTree() throws XmlPullParserException, IOException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("start tag must be read before skiping subtree" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        int n = 1;
        byte by = 3;
        while (n > 0) {
            by = this.next();
            switch (by) {
                case 2: {
                    ++n;
                    break;
                }
                case 3: {
                    --n;
                }
            }
        }
        return by;
    }

    public String getPosDesc() {
        String string;
        switch (this.eventType) {
            case 2: {
                string = "START_TAG";
                break;
            }
            case 4: {
                string = "CONTENT";
                break;
            }
            case 3: {
                string = "END_TAG";
                break;
            }
            case 1: {
                string = "END_DOCUMENT";
                break;
            }
            default: {
                string = "UNKNONW_EVENT";
            }
        }
        return this.tokenizer.getPosDesc() + " (parser state " + string + ")";
    }

    public int getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    public int getColumnNumber() {
        return this.tokenizer.getColumnNumber();
    }

    public int getDepth() {
        return this.elStackDepth;
    }

    public byte next() throws XmlPullParserException, IOException {
        if (this.emptyElement) {
            --this.elStackDepth;
            if (this.elStackDepth == 0) {
                this.seenRootElement = true;
            }
            this.emptyElement = false;
            this.eventType = 3;
            return 3;
        }
        Attribute attribute = null;
        ElementContent elementContent = null;
        try {
            block13: do {
                this.token = this.tokenizer.next();
                switch (this.token) {
                    case 2: {
                        if (this.elStackDepth > 0) {
                            throw new XmlPullParserException("expected element end tag '" + this.elStack[this.elStackDepth - 1].qName + "' not end of document" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        this.eventType = 1;
                        return 1;
                    }
                    case 10: {
                        if (this.elStackDepth > 0) {
                            this.elContent = null;
                            this.eventType = 4;
                            return 4;
                        }
                        if (!this.tokenizer.seenContent) continue block13;
                        throw new XmlPullParserException("only whitespace content allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    case 110: {
                        int n;
                        if (this.seenRootElement) {
                            throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        String string = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        --this.elStackDepth;
                        if (this.elStackDepth == 0) {
                            this.seenRootElement = true;
                        }
                        if (this.elStackDepth < 0) {
                            throw new XmlPullParserException("end tag without start stag" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        if (!string.equals(this.elStack[this.elStackDepth].qName)) {
                            throw new XmlPullParserException("end tag name should be " + this.elStack[this.elStackDepth].qName + " not " + string + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        elementContent = this.elStack[this.elStackDepth];
                        if (this.supportNs && elementContent.prefixes != null) {
                            n = elementContent.prefixesEnd - 1;
                            while (n >= 0) {
                                this.prefix2Ns.put(elementContent.prefixes[n], elementContent.prefixPrevNs[n]);
                                --n;
                            }
                            elementContent.prefixesEnd = 0;
                        }
                        this.eventType = 3;
                        return 3;
                    }
                    case 120: {
                        if (this.seenRootElement) {
                            throw new XmlPullParserException("no markup allowed outside root element" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                        }
                        this.emptyElement = false;
                        if (this.elStackDepth >= this.elStackSize) {
                            this.ensureCapacity(this.elStackDepth);
                        }
                        elementContent = this.elStack[this.elStackDepth];
                        elementContent.prefixesEnd = 0;
                        this.attrPosEnd = 0;
                        elementContent.defaultNs = this._defaultNamespaceURI;
                        elementContent.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                            if (this.tokenizer.nsColonCount > 1) {
                                throw new XmlPullParserException("only one colon allowed in prefixed element name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            elementContent.prefix = elementContent.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                            elementContent.localName = elementContent.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                        } else {
                            elementContent.prefix = null;
                            elementContent.localName = elementContent.qName;
                        }
                        elementContent.uri = null;
                        ++this.elStackDepth;
                        break;
                    }
                    case 122: {
                        if (this.attrPosEnd >= this.attrPosSize) {
                            this.ensureAttribs(this.attrPosEnd + 1);
                        }
                        attribute = this.attrPos[this.attrPosEnd];
                        attribute.qName = new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        attribute.uri = null;
                        if (this.supportNs && this.tokenizer.posNsColon >= 0) {
                            if (this.tokenizer.nsColonCount > 1) {
                                throw new XmlPullParserException("only one colon allowed in prefixed attribute name" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            attribute.prefix = attribute.qName.substring(0, this.tokenizer.posNsColon - this.tokenizer.posStart);
                            attribute.localName = attribute.qName.substring(this.tokenizer.posNsColon - this.tokenizer.posStart + 1);
                            break;
                        }
                        attribute.prefix = null;
                        attribute.localName = attribute.qName;
                        break;
                    }
                    case 127: {
                        int n;
                        attribute.value = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
                        if (this.supportNs) {
                            if ("xmlns".equals(attribute.prefix)) {
                                if (elementContent.prefixesEnd >= elementContent.prefixesSize) {
                                    elementContent.ensureCapacity(elementContent.prefixesEnd);
                                }
                                elementContent.prefixes[elementContent.prefixesEnd] = attribute.localName;
                                elementContent.prefixPrevNs[elementContent.prefixesEnd] = (String)this.prefix2Ns.get(attribute.localName);
                                n = 0;
                                while (n < elementContent.prefixesEnd) {
                                    if (attribute.localName.equals(elementContent.prefixes[n])) {
                                        throw new XmlPullParserException("duplicate xmlns declaration name '" + attribute.localName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                    }
                                    ++n;
                                }
                                ++elementContent.prefixesEnd;
                                this.prefix2Ns.put(attribute.localName, attribute.value);
                                break;
                            }
                            if ("xmlns".equals(attribute.qName)) {
                                if (elementContent.defaultNs != null) {
                                    throw new XmlPullParserException("default namespace was alredy declared by xmlns attribute" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                                elementContent.defaultNs = attribute.value;
                                break;
                            }
                            ++this.attrPosEnd;
                            break;
                        }
                        n = 0;
                        while (n < this.attrPosEnd) {
                            if (attribute.qName.equals(this.attrPos[n].qName)) {
                                throw new XmlPullParserException("duplicate attribute name '" + attribute.qName + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                            }
                            ++n;
                        }
                        ++this.attrPosEnd;
                        break;
                    }
                    case 111: {
                        this.emptyElement = true;
                        break;
                    }
                    case 112: {
                        int n;
                        if (this.supportNs) {
                            if (elementContent.defaultNs == null) {
                                elementContent.defaultNs = this.elStackDepth > 1 ? this.elStack[this.elStackDepth - 2].defaultNs : "";
                            }
                            if (elementContent.uri == null) {
                                elementContent.uri = elementContent.defaultNs;
                            }
                            if (elementContent.prefix != null) {
                                elementContent.uri = (String)this.prefix2Ns.get(elementContent.prefix);
                                if (elementContent.uri == null) {
                                    throw new XmlPullParserException("no namespace for prefix '" + elementContent.prefix + "'" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                }
                            } else {
                                elementContent.uri = elementContent.defaultNs;
                                elementContent.localName = elementContent.qName;
                            }
                            n = 0;
                            while (n < this.attrPosEnd) {
                                attribute = this.attrPos[n];
                                if (attribute.uri == null && attribute.prefix != null) {
                                    attribute.uri = (String)this.prefix2Ns.get(attribute.prefix);
                                    if (attribute.uri == null) {
                                        throw new XmlPullParserException("no namespace for prefix " + attribute.prefix + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                    }
                                }
                                ++n;
                            }
                            int n2 = 1;
                            while (n2 < this.attrPosEnd) {
                                attribute = this.attrPos[n2];
                                int n3 = 0;
                                while (n3 < n2) {
                                    if (attribute.localName.equals(this.attrPos[n3].localName) && (attribute.uri != null && attribute.uri.equals(this.attrPos[n3].uri) || attribute.uri == null && this.attrPos[n3].uri == null)) {
                                        throw new XmlPullParserException("duplicate attribute name '" + attribute.qName + "'" + (attribute.uri != null ? " (with namespace '" + attribute.uri + "')" : "") + " and " + (attribute.uri != null ? " (with namespace '" + attribute.uri + "')" : "") + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                                    }
                                    ++n3;
                                }
                                ++n2;
                            }
                        } else {
                            elementContent.prefix = null;
                            elementContent.localName = elementContent.qName;
                            elementContent.uri = "";
                        }
                        this.eventType = 2;
                        return 2;
                    }
                    case 50: {
                        throw new XmlPullParserException("<![DOCTYPE declarations not supported" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                    default: {
                        throw new XmlPullParserException("unknown token " + this.token + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
                    }
                }
            } while (this.token != 112);
        }
        catch (XmlTokenizerException xmlTokenizerException) {
            throw new XmlPullParserException("tokenizer exception", xmlTokenizerException);
        }
        throw new XmlPullParserException("invalid state of tokenizer token=" + this.token);
    }

    public boolean whitespaceContent() throws XmlPullParserException {
        if (this.eventType != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        return !this.tokenizer.seenContent;
    }

    public String readContent() throws XmlPullParserException {
        if (this.eventType != 4) {
            throw new XmlPullParserException("no content available to read");
        }
        if (this.elContent == null) {
            this.elContent = this.tokenizer.parsedContent ? new String(this.tokenizer.pc, this.tokenizer.pcStart, this.tokenizer.pcEnd - this.tokenizer.pcStart) : new String(this.tokenizer.buf, this.tokenizer.posStart, this.tokenizer.posEnd - this.tokenizer.posStart);
        }
        return this.elContent;
    }

    public void readEndTag(EndTag endTag) throws XmlPullParserException {
        if (this.eventType != 3) {
            throw new XmlPullParserException("no end tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        endTag.qName = this.elStack[this.elStackDepth].qName;
        endTag.uri = this.elStack[this.elStackDepth].uri;
        endTag.localName = this.elStack[this.elStackDepth].localName;
    }

    public void readStartTag(StartTag startTag) throws XmlPullParserException, IOException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("no start tag available to read" + this.getPosDesc(), this.getLineNumber(), this.getColumnNumber());
        }
        ElementContent elementContent = this.elStack[this.elStackDepth - 1];
        startTag.qName = elementContent.qName;
        startTag.uri = elementContent.uri;
        startTag.localName = elementContent.localName;
        startTag.ensureCapacity(this.attrPosEnd);
        startTag.attEnd = this.attrPosEnd;
        int n = 0;
        while (n < this.attrPosEnd) {
            Attribute attribute = this.attrPos[n];
            Attribute attribute2 = startTag.attArr[n];
            attribute2.qName = attribute.qName;
            attribute2.localName = attribute.localName;
            attribute2.value = attribute.value;
            attribute2.uri = attribute.uri;
            attribute2.beenRead = false;
            ++n;
        }
    }

    private void ensureCapacity(int n) {
        int n2 = 2 * n;
        if (n2 == 0) {
            n2 = 25;
        }
        if (this.elStackSize < n2) {
            ElementContent[] elementContentArray = new ElementContent[n2];
            if (this.elStack != null) {
                System.arraycopy(this.elStack, 0, elementContentArray, 0, this.elStackSize);
            }
            int n3 = this.elStackSize;
            while (n3 < n2) {
                elementContentArray[n3] = new ElementContent();
                ++n3;
            }
            this.elStack = elementContentArray;
            this.elStackSize = n2;
        }
    }

    private void ensureAttribs(int n) {
        int n2 = 2 * n;
        if (n2 == 0) {
            n2 = 25;
        }
        if (this.attrPosEnd < n2) {
            Attribute[] attributeArray = new Attribute[n2];
            if (this.attrPos != null) {
                System.arraycopy(this.attrPos, 0, attributeArray, 0, this.attrPosSize);
            }
            int n3 = this.attrPosSize;
            while (n3 < n2) {
                attributeArray[n3] = new Attribute();
                ++n3;
            }
            this.attrPos = attributeArray;
            this.attrPosSize = n2;
        }
    }

    private class ElementContent {
        String qName;
        String uri;
        String localName;
        String prefix;
        String defaultNs;
        int prefixesEnd;
        int prefixesSize;
        String[] prefixes;
        String[] prefixPrevNs;

        private ElementContent() {
        }

        private void ensureCapacity(int n) {
            int n2 = 2 * n;
            if (n2 == 0) {
                n2 = 25;
            }
            if (this.prefixesSize < n2) {
                String[] stringArray = new String[n2];
                String[] stringArray2 = new String[n2];
                if (this.prefixes != null) {
                    System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixesEnd);
                    System.arraycopy(this.prefixPrevNs, 0, stringArray2, 0, this.prefixesEnd);
                }
                this.prefixes = stringArray;
                this.prefixPrevNs = stringArray2;
                this.prefixesSize = n2;
            }
        }
    }
}

