/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ae.xap;

import com.esri.ae.xap.Util;
import com.esri.ae.xap.Workspaces;
import com.esri.mo.axl.map.DatasetElement;
import com.esri.mo.axl.map.WorkspaceElement;
import com.esri.mo.axl.map.WorkspacesElement;
import com.esri.mo.client.aims.ImageServer;
import com.esri.mo.client.av.ArcViewIMS;
import com.esri.mo.client.mo.AEWeb;
import com.esri.mo.data.feat.FeatureClass;
import com.esri.mo.map.dpy.DatasetLayer;
import com.esri.mo.map.dpy.FeatureLayer;
import com.esri.mo.map.dpy.Layer;
import com.esri.mo.map.dpy.LayerSource;
import com.esri.mo.map.img.BaseImageDirectoryLayerSource;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import org.w3c.dom.Node;

public class Dataset {
    public static com.esri.mo.data.feat.Dataset getDataset(DatasetElement datasetElement) throws IOException {
        String string = datasetElement.getWorkspace();
        WorkspacesElement workspacesElement = Util.getWorkspacesElement((Node)datasetElement);
        WorkspaceElement workspaceElement = workspacesElement.getWorkspaceElement(string);
        LayerSource layerSource = workspaceElement.getLayerSource();
        int n2 = -1;
        if (datasetElement.getType() == 0) {
            n2 = 0;
        } else if (datasetElement.getType() == 1) {
            n2 = 1;
        } else if (datasetElement.getType() == 2) {
            n2 = 2;
        }
        DatasetLayer datasetLayer = (DatasetLayer)layerSource.getLayer(datasetElement.getName(), n2);
        return datasetLayer.getDataset();
    }

    public static DatasetElement getDatasetElement(XmlDocument xmlDocument, Layer layer) {
        DatasetElement datasetElement = (DatasetElement)xmlDocument.createElement("DATASET");
        if (layer.getLayerSource() instanceof ImageServer) {
            datasetElement.setName(((DatasetLayer)layer).getDataset().getName());
            datasetElement.setType(3);
        } else if (layer.getLayerSource() instanceof BaseImageDirectoryLayerSource) {
            datasetElement.setName(((DatasetLayer)layer).getDataset().getName());
            datasetElement.setType(3);
        } else if (layer.getLayerSource() instanceof AEWeb) {
            datasetElement.setName(((DatasetLayer)layer).getDataset().getName());
            datasetElement.setType(3);
        } else if (layer.getLayerSource() instanceof ArcViewIMS) {
            datasetElement.setName(((DatasetLayer)layer).getDataset().getName());
            datasetElement.setType(3);
        } else {
            FeatureClass featureClass = ((FeatureLayer)layer).getFeatureClass();
            datasetElement.setName(featureClass.getName());
            if (featureClass.getFeatureType() == 0) {
                datasetElement.setType(0);
            } else if (featureClass.getFeatureType() == 1) {
                datasetElement.setType(1);
            } else if (featureClass.getFeatureType() == 2) {
                datasetElement.setType(2);
            }
        }
        datasetElement.setWorkspace(Workspaces.getWorkspaceName(xmlDocument, layer.getLayerSource()));
        return datasetElement;
    }
}

