/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

public abstract class ColorSpaceJAI
extends ColorSpace {
    private boolean isRGBPreferredIntermediary;

    public static WritableRaster CIEXYZToRGB(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.CIEXYZToRGBByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.CIEXYZToRGBShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.CIEXYZToRGBInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.CIEXYZToRGBFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.CIEXYZToRGBDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    protected static void checkParameters(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI0"));
        }
        if (raster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI1"));
        }
        if (writableRaster != null && writableRaster.getNumBands() != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI2"));
        }
        if (nArray != null && nArray.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI3"));
        }
        if (nArray2 != null && nArray2.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("ColorSpaceJAI4"));
        }
    }

    protected static void convertToSigned(double[] dArray, int n) {
        block3: {
            block2: {
                if (n != 2) break block2;
                int n2 = 0;
                while (n2 < dArray.length) {
                    short s = (short)((int)dArray[n2] & 0xFFFF);
                    dArray[n2] = s;
                    ++n2;
                }
                break block3;
            }
            if (n != 3) break block3;
            int n3 = 0;
            while (n3 < dArray.length) {
                int n4 = (int)((long)dArray[n3] & 0xFFFFFFFFL);
                dArray[n3] = n4;
                ++n3;
            }
        }
    }

    private static void CIEXYZToRGBByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double d;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        int n = 8 - nArray[0];
        int n2 = 8 - nArray[1];
        int n3 = 8 - nArray[2];
        double d2 = d = 0.00392156862745098;
        double d3 = d;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        if (n4 < 4) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 255.0;
            d2 = d5 / 255.0;
            d3 = d6 / 255.0;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                int n18 = (byArray[n15] & 0xFF) << n;
                int n19 = (byArray2[n16] & 0xFF) << n2;
                int n20 = (byArray3[n17] & 0xFF) << n3;
                double d7 = (3.240479 * (double)n18 - 1.53715 * (double)n19 - 0.498535 * (double)n20) * d;
                double d8 = (-0.969256 * (double)n18 + 1.875992 * (double)n19 + 0.041556 * (double)n20) * d2;
                double d9 = (0.055648 * (double)n18 - 0.204043 * (double)n19 + 1.057311 * (double)n20) * d3;
                dArray[n12++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void CIEXYZToRGBShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double d;
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        int n = 16 - nArray[0];
        int n2 = 16 - nArray[1];
        int n3 = 16 - nArray[2];
        double d2 = d = 1.5259021896696422E-5;
        double d3 = d;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        if (n4 < 4) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 65535.0;
            d2 = d5 / 65535.0;
            d3 = d6 / 65535.0;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                int n18 = (sArray[n15] & 0xFFFF) << n;
                int n19 = (sArray2[n16] & 0xFFFF) << n2;
                int n20 = (sArray3[n17] & 0xFFFF) << n3;
                double d7 = (3.240479 * (double)n18 - 1.53715 * (double)n19 - 0.498535 * (double)n20) * d;
                double d8 = (-0.969256 * (double)n18 + 1.875992 * (double)n19 + 0.041556 * (double)n20) * d2;
                double d9 = (0.055648 * (double)n18 - 0.204043 * (double)n19 + 1.057311 * (double)n20) * d3;
                dArray[n12++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void CIEXYZToRGBInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double d;
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        int n = 32 - nArray[0];
        int n2 = 32 - nArray[1];
        int n3 = 32 - nArray[2];
        double d2 = 4.294967295E9;
        double d3 = d = 1.0 / d2;
        double d4 = d;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        if (n4 < 4) {
            d5 = (1L << nArray2[0]) - 1L;
            d6 = (1L << nArray2[1]) - 1L;
            d7 = (1L << nArray2[2]) - 1L;
            d = d5 / d2;
            d3 = d6 / d2;
            d4 = d7 / d2;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                long l = ((long)nArray3[n15] & 0xFFFFFFFFL) << n;
                long l2 = ((long)nArray4[n16] & 0xFFFFFFFFL) << n2;
                long l3 = ((long)nArray5[n17] & 0xFFFFFFFFL) << n3;
                double d8 = (3.240479 * (double)l - 1.53715 * (double)l2 - 0.498535 * (double)l3) * d;
                double d9 = (-0.969256 * (double)l + 1.875992 * (double)l2 + 0.041556 * (double)l3) * d3;
                double d10 = (0.055648 * (double)l - 0.204043 * (double)l2 + 1.057311 * (double)l3) * d4;
                dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                dArray[n12++] = d10 < 0.0 ? 0.0 : (d10 > d7 ? d7 : d10);
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void CIEXYZToRGBFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = d4 = (double)((1L << nArray2[0]) - 1L);
            d2 = d5 = (double)((1L << nArray2[1]) - 1L);
            d3 = d6 = (double)((1L << nArray2[2]) - 1L);
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                float f = fArray[n12];
                float f2 = fArray2[n13];
                float f3 = fArray3[n14];
                double d7 = (3.240479 * (double)f - 1.53715 * (double)f2 - 0.498535 * (double)f3) * d;
                double d8 = (-0.969256 * (double)f + 1.875992 * (double)f2 + 0.041556 * (double)f3) * d2;
                double d9 = (0.055648 * (double)f - 0.204043 * (double)f2 + 1.057311 * (double)f3) * d3;
                dArray[n9++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                dArray[n9++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                dArray[n9++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void CIEXYZToRGBDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d = d4 = (double)((1L << nArray2[0]) - 1L);
            d2 = d5 = (double)((1L << nArray2[1]) - 1L);
            d3 = d6 = (double)((1L << nArray2[2]) - 1L);
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d7 = dArray[n12];
                double d8 = dArray2[n13];
                double d9 = dArray3[n14];
                double d10 = (3.240479 * d7 - 1.53715 * d8 - 0.498535 * d9) * d;
                double d11 = (-0.969256 * d7 + 1.875992 * d8 + 0.041556 * d9) * d2;
                double d12 = (0.055648 * d7 - 0.204043 * d8 + 1.057311 * d9) * d3;
                dArray4[n9++] = d10 < 0.0 ? 0.0 : (d10 > d4 ? d4 : d10);
                dArray4[n9++] = d11 < 0.0 ? 0.0 : (d11 > d5 ? d5 : d11);
                dArray4[n9++] = d12 < 0.0 ? 0.0 : (d12 > d6 ? d6 : d12);
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray4, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray4);
    }

    public static WritableRaster RGBToCIEXYZ(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                ColorSpaceJAI.RGBToCIEXYZByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                ColorSpaceJAI.RGBToCIEXYZShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                ColorSpaceJAI.RGBToCIEXYZInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                ColorSpaceJAI.RGBToCIEXYZFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                ColorSpaceJAI.RGBToCIEXYZDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    private static void RGBToCIEXYZByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double d;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        int n = 8 - nArray[0];
        int n2 = 8 - nArray[1];
        int n3 = 8 - nArray[2];
        double d2 = d = 0.00392156862745098;
        double d3 = d;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 < 4;
        if (bl) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 255.0 / 0.950456;
            d2 = d5 / 255.0;
            d3 = d6 / 255.0 / 1.088754;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                int n18 = (byArray[n15] & 0xFF) << n;
                int n19 = (byArray2[n16] & 0xFF) << n2;
                int n20 = (byArray3[n17] & 0xFF) << n3;
                if (bl) {
                    double d7 = (0.412453 * (double)n18 + 0.35758 * (double)n19 + 0.180423 * (double)n20) * d;
                    double d8 = (0.212671 * (double)n18 + 0.71516 * (double)n19 + 0.072169 * (double)n20) * d2;
                    double d9 = (0.019334 * (double)n18 + 0.119193 * (double)n19 + 0.950227 * (double)n20) * d3;
                    dArray[n12++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                    dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                    dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                } else {
                    dArray[n12++] = (0.412453 * (double)n18 + 0.35758 * (double)n19 + 0.180423 * (double)n20) * d;
                    dArray[n12++] = (0.212671 * (double)n18 + 0.71516 * (double)n19 + 0.072169 * (double)n20) * d2;
                    dArray[n12++] = (0.019334 * (double)n18 + 0.119193 * (double)n19 + 0.950227 * (double)n20) * d3;
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void RGBToCIEXYZShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double d;
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        int n = 16 - nArray[0];
        int n2 = 16 - nArray[1];
        int n3 = 16 - nArray[2];
        double d2 = d = 1.5259021896696422E-5;
        double d3 = d;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 < 4;
        if (bl) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 65535.0 / 0.950456;
            d2 = d5 / 65535.0;
            d3 = d6 / 65535.0 / 1.088754;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                int n18 = (sArray[n15] & 0xFFFF) << n;
                int n19 = (sArray2[n16] & 0xFFFF) << n2;
                int n20 = (sArray3[n17] & 0xFFFF) << n3;
                if (bl) {
                    double d7 = (0.412453 * (double)n18 + 0.35758 * (double)n19 + 0.180423 * (double)n20) * d;
                    double d8 = (0.212671 * (double)n18 + 0.71516 * (double)n19 + 0.072169 * (double)n20) * d2;
                    double d9 = (0.019334 * (double)n18 + 0.119193 * (double)n19 + 0.950227 * (double)n20) * d3;
                    dArray[n12++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                    dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                    dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                } else {
                    dArray[n12++] = (0.412453 * (double)n18 + 0.35758 * (double)n19 + 0.180423 * (double)n20) * d;
                    dArray[n12++] = (0.212671 * (double)n18 + 0.71516 * (double)n19 + 0.072169 * (double)n20) * d2;
                    dArray[n12++] = (0.019334 * (double)n18 + 0.119193 * (double)n19 + 0.950227 * (double)n20) * d3;
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void RGBToCIEXYZInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double d;
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        int n = 32 - nArray[0];
        int n2 = 32 - nArray[1];
        int n3 = 32 - nArray[2];
        double d2 = 4.294967295E9;
        double d3 = d = 1.0 / d2;
        double d4 = d;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 < 4;
        if (bl) {
            d5 = (1L << nArray2[0]) - 1L;
            d6 = (1L << nArray2[1]) - 1L;
            d7 = (1L << nArray2[2]) - 1L;
            d = d5 / d2 / 0.950456;
            d3 = d6 / d2;
            d4 = d7 / d2 / 1.088754;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = new double[3 * n5 * n6];
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                long l = ((long)nArray3[n15] & 0xFFFFFFFFL) << n;
                long l2 = ((long)nArray4[n16] & 0xFFFFFFFFL) << n2;
                long l3 = ((long)nArray5[n17] & 0xFFFFFFFFL) << n3;
                if (bl) {
                    double d8 = (0.412453 * (double)l + 0.35758 * (double)l2 + 0.180423 * (double)l3) * d;
                    double d9 = (0.212671 * (double)l + 0.71516 * (double)l2 + 0.072169 * (double)l3) * d3;
                    double d10 = (0.019334 * (double)l + 0.119193 * (double)l2 + 0.950227 * (double)l3) * d4;
                    dArray[n12++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                    dArray[n12++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                    dArray[n12++] = d10 < 0.0 ? 0.0 : (d10 > d7 ? d7 : d10);
                } else {
                    dArray[n12++] = (0.412453 * (double)l + 0.35758 * (double)l2 + 0.180423 * (double)l3) * d;
                    dArray[n12++] = (0.212671 * (double)l + 0.71516 * (double)l2 + 0.072169 * (double)l3) * d3;
                    dArray[n12++] = (0.019334 * (double)l + 0.119193 * (double)l2 + 0.950227 * (double)l3) * d4;
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        ColorSpaceJAI.convertToSigned(dArray, n4);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
    }

    private static void RGBToCIEXYZFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 0.950456;
            d2 = d5;
            d3 = d6 / 1.088754;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                float f = fArray[n12];
                float f2 = fArray2[n13];
                float f3 = fArray3[n14];
                if (bl) {
                    double d7 = (0.412453 * (double)f + 0.35758 * (double)f2 + 0.180423 * (double)f3) * d;
                    double d8 = (0.212671 * (double)f + 0.71516 * (double)f2 + 0.072169 * (double)f3) * d2;
                    double d9 = (0.019334 * (double)f + 0.119193 * (double)f2 + 0.950227 * (double)f3) * d3;
                    dArray[n9++] = d7 < 0.0 ? 0.0 : (d7 > d4 ? d4 : d7);
                    dArray[n9++] = d8 < 0.0 ? 0.0 : (d8 > d5 ? d5 : d8);
                    dArray[n9++] = d9 < 0.0 ? 0.0 : (d9 > d6 ? d6 : d9);
                } else {
                    dArray[n9++] = 0.412453 * (double)f + 0.35758 * (double)f2 + 0.180423 * (double)f3;
                    dArray[n9++] = 0.212671 * (double)f + 0.71516 * (double)f2 + 0.072169 * (double)f3;
                    dArray[n9++] = 0.019334 * (double)f + 0.119193 * (double)f2 + 0.950227 * (double)f3;
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private static void RGBToCIEXYZDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d = 1.0;
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n < 4;
        if (bl) {
            d4 = (1L << nArray2[0]) - 1L;
            d5 = (1L << nArray2[1]) - 1L;
            d6 = (1L << nArray2[2]) - 1L;
            d = d4 / 0.950456;
            d2 = d5;
            d3 = d6 / 1.088754;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d7 = dArray[n12];
                double d8 = dArray2[n13];
                double d9 = dArray3[n14];
                if (bl) {
                    double d10 = (0.412453 * d7 + 0.35758 * d8 + 0.180423 * d9) * d;
                    double d11 = (0.212671 * d7 + 0.71516 * d8 + 0.072169 * d9) * d2;
                    double d12 = (0.019334 * d7 + 0.119193 * d8 + 0.950227 * d9) * d3;
                    dArray4[n9++] = d10 < 0.0 ? 0.0 : (d10 > d4 ? d4 : d10);
                    dArray4[n9++] = d11 < 0.0 ? 0.0 : (d11 > d5 ? d5 : d11);
                    dArray4[n9++] = d12 < 0.0 ? 0.0 : (d12 > d6 ? d6 : d12);
                } else {
                    dArray4[n9++] = 0.412453 * d7 + 0.35758 * d8 + 0.180423 * d9;
                    dArray4[n9++] = 0.212671 * d7 + 0.71516 * d8 + 0.072169 * d9;
                    dArray4[n9++] = 0.019334 * d7 + 0.119193 * d8 + 0.950227 * d9;
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray4, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray4);
    }

    protected ColorSpaceJAI(int n, int n2, boolean bl) {
        super(n, n2);
        this.isRGBPreferredIntermediary = bl;
    }

    public boolean isRGBPreferredIntermediary() {
        return this.isRGBPreferredIntermediary;
    }

    public abstract WritableRaster fromCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster fromRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toCIEXYZ(Raster var1, int[] var2, WritableRaster var3, int[] var4);

    public abstract WritableRaster toRGB(Raster var1, int[] var2, WritableRaster var3, int[] var4);
}

