/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.ImageServer;
import com.sun.media.jai.rmi.RMIServerProxy;
import com.sun.media.jai.rmi.RenderableRMIServerProxy;
import com.sun.media.jai.rmi.SerializableRenderableImage;
import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteCRIF;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteRenderableOp;
import javax.media.jai.remote.RemoteRenderedImage;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileDecoderFactory;

public class JAIRMICRIF
implements RemoteCRIF {
    public RenderContext mapRenderContext(String string, String string2, int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) throws RemoteImagingException {
        RemoteRenderableOp remoteRenderableOp = (RemoteRenderableOp)renderableImage;
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        SerializableState serializableState = SerializerFactory.getState(renderContext, null);
        try {
            SerializableState serializableState2 = renderableRMIServerProxy.getImageServer(string).mapRenderContext(n, renderableRMIServerProxy.getRMIID(), string2, serializableState);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        return (RenderContext)serializableState.getObject();
    }

    public Rectangle2D getBounds2D(String string, String string2, ParameterBlock parameterBlock) throws RemoteImagingException {
        SerializableState serializableState = null;
        RemoteRenderableOp remoteRenderableOp = new RemoteRenderableOp("jairmi", string, string2, parameterBlock);
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        try {
            serializableState = renderableRMIServerProxy.getImageServer(string).getBounds2D(renderableRMIServerProxy.getRMIID(), string2);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        return (Rectangle2D.Float)serializableState.getObject();
    }

    public Object getProperty(String string, String string2, ParameterBlock parameterBlock, String string3) throws RemoteImagingException {
        ParameterBlock parameterBlock2 = null;
        parameterBlock2 = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        RemoteRenderableOp remoteRenderableOp = new RemoteRenderableOp("jairmi", string, string2, parameterBlock);
        RenderableRMIServerProxy renderableRMIServerProxy = this.createProxy(remoteRenderableOp);
        try {
            return renderableRMIServerProxy.getProperty(string3);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
    }

    public String[] getPropertyNames(String string, String string2) throws RemoteImagingException {
        ImageServer imageServer = this.getImageServer(string);
        try {
            return imageServer.getPropertyNames(string2);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
    }

    private ImageServer getImageServer(String string) {
        if (string == null) {
            try {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        String string2 = new String("rmi://" + string + "/" + "JAIRMIRemoteServer1.1");
        try {
            return (ImageServer)Naming.lookup(string2);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
    }

    public boolean isDynamic(String string, String string2) throws RemoteImagingException {
        ImageServer imageServer = this.getImageServer(string);
        try {
            return imageServer.isDynamic(string2);
        }
        catch (Exception exception) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(exception));
        }
    }

    public RemoteRenderedImage create(String string, String string2, ParameterBlock parameterBlock, RenderingHints renderingHints) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy = new RMIServerProxy(string, string2, parameterBlock, renderingHints);
        boolean bl = rMIServerProxy.canBeRendered();
        if (!bl) {
            return null;
        }
        return rMIServerProxy;
    }

    public RemoteRenderedImage create(PlanarImageServerProxy planarImageServerProxy, OperationNode operationNode, PropertyChangeEventJAI propertyChangeEventJAI) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy;
        if (!(operationNode instanceof RemoteRenderedOp)) {
            return null;
        }
        String string = propertyChangeEventJAI.getPropertyName();
        if (string.equals("servername")) {
            rMIServerProxy = new RMIServerProxy(planarImageServerProxy, operationNode, (String)propertyChangeEventJAI.getNewValue());
        } else {
            if (string.equals("operationregistry") || string.equals("protocolname") || string.equals("protocolandservername")) {
                return this.create(((RemoteRenderedOp)operationNode).getServerName(), operationNode.getOperationName(), operationNode.getParameterBlock(), operationNode.getRenderingHints());
            }
            rMIServerProxy = new RMIServerProxy(planarImageServerProxy, operationNode, propertyChangeEventJAI);
        }
        return rMIServerProxy;
    }

    public RemoteRenderedImage create(String string, String string2, RenderContext renderContext, ParameterBlock parameterBlock) throws RemoteImagingException {
        RMIServerProxy rMIServerProxy = new RMIServerProxy(string, string2, parameterBlock, renderContext, true);
        Long l = rMIServerProxy.getRenderingID();
        return new RMIServerProxy(string + "::" + l, parameterBlock, string2, renderContext.getRenderingHints());
    }

    public NegotiableCapabilitySet getClientCapabilities() {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        String string = "tileDecoder";
        String[] stringArray = operationRegistry.getDescriptorNames(string);
        TileDecoderFactory tileDecoderFactory = null;
        NegotiableCapabilitySet negotiableCapabilitySet = new NegotiableCapabilitySet(false);
        int n = 0;
        while (n < stringArray.length) {
            Iterator iterator = operationRegistry.getFactoryIterator(string, stringArray[n]);
            while (iterator.hasNext()) {
                tileDecoderFactory = (TileDecoderFactory)iterator.next();
                negotiableCapabilitySet.add(tileDecoderFactory.getDecodeCapability());
            }
            ++n;
        }
        return negotiableCapabilitySet;
    }

    private RenderableRMIServerProxy createProxy(RemoteRenderableOp remoteRenderableOp) {
        Long l;
        ParameterBlock parameterBlock = remoteRenderableOp.getParameterBlock();
        ParameterBlock parameterBlock2 = (ParameterBlock)parameterBlock.clone();
        Vector<Object> vector = parameterBlock.getSources();
        parameterBlock2.removeSources();
        ImageServer imageServer = this.getImageServer(remoteRenderableOp.getServerName());
        try {
            l = imageServer.getRemoteID();
            imageServer.createRenderableOp(l, remoteRenderableOp.getOperationName(), parameterBlock2);
        }
        catch (RemoteException remoteException) {
            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Object object;
                Object object2 = vector.elementAt(n);
                if (object2 instanceof RemoteRenderedOp) {
                    object = (RMIServerProxy)((RemoteRenderedOp)object2).getRendering();
                    try {
                        if (((PlanarImageServerProxy)object).getServerName().equalsIgnoreCase(remoteRenderableOp.getServerName())) {
                            imageServer.setRenderedSource(l, ((RMIServerProxy)object).getRMIID(), n);
                            parameterBlock2.setSource(object, n);
                        }
                        imageServer.setRenderedSource(l, ((RMIServerProxy)object).getRMIID(), ((PlanarImageServerProxy)object).getServerName(), ((PlanarImageServerProxy)object).getOperationName(), n);
                        parameterBlock2.setSource(object, n);
                    }
                    catch (RemoteException remoteException) {
                        throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                    }
                } else {
                    Serializable serializable;
                    if (object2 instanceof RenderedOp) {
                        object = ((RenderedOp)object2).getRendering();
                        try {
                            serializable = new SerializableRenderedImage((RenderedImage)object);
                            imageServer.setRenderedSource(l, (RenderedImage)((Object)serializable), n);
                            parameterBlock2.setSource(serializable, n);
                        }
                        catch (RemoteException remoteException) {
                            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                        }
                    }
                    if (object2 instanceof RenderedImage) {
                        object = (RenderedImage)object2;
                        try {
                            serializable = new SerializableRenderedImage((RenderedImage)object);
                            imageServer.setRenderedSource(l, (RenderedImage)((Object)serializable), n);
                            parameterBlock2.setSource(serializable, n);
                        }
                        catch (RemoteException remoteException) {
                            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                        }
                    }
                    if (object2 instanceof RemoteRenderableOp) {
                        object = this.createProxy((RemoteRenderableOp)object2);
                        try {
                            if (((RenderableRMIServerProxy)object).getServerName().equalsIgnoreCase(remoteRenderableOp.getServerName())) {
                                imageServer.setRenderableSource(l, ((RenderableRMIServerProxy)object).getRMIID(), n);
                                parameterBlock2.setSource(object, n);
                            }
                            imageServer.setRenderableRMIServerProxyAsSource(l, ((RenderableRMIServerProxy)object).getRMIID(), ((RenderableRMIServerProxy)object).getServerName(), ((RenderableRMIServerProxy)object).getOperationName(), n);
                            parameterBlock2.setSource(object, n);
                        }
                        catch (RemoteException remoteException) {
                            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                        }
                    } else if (object2 instanceof RenderableImage) {
                        object = (RenderableImage)object2;
                        try {
                            serializable = new SerializableRenderableImage((RenderableImage)object);
                            imageServer.setRenderableSource(l, (SerializableRenderableImage)serializable, n);
                            parameterBlock2.setSource(serializable, n);
                        }
                        catch (RemoteException remoteException) {
                            throw new RemoteImagingException(ImageUtil.getStackTraceString(remoteException));
                        }
                    }
                }
                ++n;
            }
        }
        RenderableRMIServerProxy renderableRMIServerProxy = new RenderableRMIServerProxy(remoteRenderableOp.getServerName(), remoteRenderableOp.getOperationName(), parameterBlock2, l);
        return renderableRMIServerProxy;
    }
}

