/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import com.sun.media.jai.rmi.SerializableStateImpl;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.media.jai.FloatDoubleColorModel;

public class ColorModelState
extends SerializableStateImpl {
    private static final int COLORSPACE_OTHERS = 0;
    private static final int COLORSPACE_PREDEFINED = 1;
    private static final int COLORSPACE_ICC = 2;
    private static final int COLORMODEL_NULL = 0;
    private static final int COLORMODEL_FLOAT_DOUBLE_COMPONENT = 1;
    private static final int COLORMODEL_COMPONENT = 2;
    private static final int COLORMODEL_INDEX = 3;
    private static final int COLORMODEL_DIRECT = 4;
    private transient ColorModel colorModel = null;
    static /* synthetic */ Class class$java$awt$image$ComponentColorModel;
    static /* synthetic */ Class class$javax$media$jai$FloatDoubleColorModel;
    static /* synthetic */ Class class$java$awt$image$IndexColorModel;
    static /* synthetic */ Class class$java$awt$image$DirectColorModel;
    static /* synthetic */ Class class$com$sun$media$jai$codecimpl$util$FloatDoubleColorModel;

    private static int[] getPredefinedColorSpace(ColorSpace colorSpace) {
        int[] nArray = new int[]{1001, 1003, 1004, 1002, 1000};
        int n = 0;
        while (n < nArray.length) {
            if (colorSpace.equals(ColorSpace.getInstance(nArray[n]))) {
                return new int[]{nArray[n]};
            }
            ++n;
        }
        int n2 = colorSpace.getNumComponents();
        int n3 = colorSpace.getType();
        if (n2 == 1 && n3 == 6) {
            return new int[]{1003};
        }
        if (n2 == 3) {
            if (n3 == 5) {
                return new int[]{1000};
            }
            if (n3 == 0) {
                return new int[]{1001};
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean serializeColorSpace(ColorSpace colorSpace, ObjectOutputStream objectOutputStream) throws IOException {
        int[] nArray = ColorModelState.getPredefinedColorSpace(colorSpace);
        boolean bl = colorSpace instanceof ICC_ColorSpace;
        if (nArray != null) {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeInt(nArray[0]);
            return true;
        }
        objectOutputStream.writeInt(0);
        Object object = colorSpace;
        boolean bl2 = false;
        try {
            block5: {
                try {
                    Class<?> clazz = colorSpace.getClass();
                    Method method = clazz.getMethod("getInstance", null);
                    if (!Modifier.isPublic(clazz.getModifiers())) break block5;
                    bl2 = true;
                    object = clazz.getName();
                }
                catch (Exception exception) {
                    Object var9_10 = null;
                    objectOutputStream.writeBoolean(bl2);
                    objectOutputStream.writeObject(object);
                    return true;
                }
            }
            Object var9_9 = null;
            objectOutputStream.writeBoolean(bl2);
            objectOutputStream.writeObject(object);
            return true;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            objectOutputStream.writeBoolean(bl2);
            objectOutputStream.writeObject(object);
            throw throwable;
        }
    }

    private static ColorSpace deserializeColorSpace(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ColorSpace colorSpace = null;
        int n = objectInputStream.readInt();
        if (n == 0) {
            if (objectInputStream.readBoolean()) {
                String string = (String)objectInputStream.readObject();
                try {
                    Class<?> clazz = Class.forName(string);
                    Method method = clazz.getMethod("getInstance", null);
                    colorSpace = (ColorSpace)method.invoke(null, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                colorSpace = (ColorSpace)objectInputStream.readObject();
            }
        } else if (n == 1) {
            colorSpace = ColorSpace.getInstance(objectInputStream.readInt());
        }
        return colorSpace;
    }

    public static Class[] getSupportedClasses() {
        return new Class[]{class$java$awt$image$ComponentColorModel == null ? (class$java$awt$image$ComponentColorModel = ColorModelState.class$("java.awt.image.ComponentColorModel")) : class$java$awt$image$ComponentColorModel, class$javax$media$jai$FloatDoubleColorModel == null ? (class$javax$media$jai$FloatDoubleColorModel = ColorModelState.class$("javax.media.jai.FloatDoubleColorModel")) : class$javax$media$jai$FloatDoubleColorModel, class$java$awt$image$IndexColorModel == null ? (class$java$awt$image$IndexColorModel = ColorModelState.class$("java.awt.image.IndexColorModel")) : class$java$awt$image$IndexColorModel, class$java$awt$image$DirectColorModel == null ? (class$java$awt$image$DirectColorModel = ColorModelState.class$("java.awt.image.DirectColorModel")) : class$java$awt$image$DirectColorModel, class$com$sun$media$jai$codecimpl$util$FloatDoubleColorModel == null ? (class$com$sun$media$jai$codecimpl$util$FloatDoubleColorModel = ColorModelState.class$("com.sun.media.jai.codecimpl.util.FloatDoubleColorModel")) : class$com$sun$media$jai$codecimpl$util$FloatDoubleColorModel};
    }

    public ColorModelState(Class clazz, Object object, RenderingHints renderingHints) {
        super(clazz, object, renderingHints);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ColorModel colorModel = (ColorModel)this.theObject;
        if (colorModel == null) {
            objectOutputStream.writeInt(0);
        } else if (colorModel instanceof ComponentColorModel) {
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            int n = 2;
            if (colorModel instanceof FloatDoubleColorModel) {
                n = 1;
            }
            objectOutputStream.writeInt(n);
            ColorModelState.serializeColorSpace(componentColorModel.getColorSpace(), objectOutputStream);
            if (n == 2) {
                objectOutputStream.writeObject(componentColorModel.getComponentSize());
            }
            objectOutputStream.writeBoolean(componentColorModel.hasAlpha());
            objectOutputStream.writeBoolean(componentColorModel.isAlphaPremultiplied());
            objectOutputStream.writeInt(componentColorModel.getTransparency());
            SampleModel sampleModel = componentColorModel.createCompatibleSampleModel(1, 1);
            objectOutputStream.writeInt(sampleModel.getTransferType());
        } else if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            objectOutputStream.writeInt(3);
            int n = indexColorModel.getMapSize();
            int[] nArray = new int[n];
            indexColorModel.getRGBs(nArray);
            objectOutputStream.writeInt(indexColorModel.getPixelSize());
            objectOutputStream.writeInt(n);
            objectOutputStream.writeObject(nArray);
            objectOutputStream.writeBoolean(indexColorModel.hasAlpha());
            objectOutputStream.writeInt(indexColorModel.getTransparentPixel());
            SampleModel sampleModel = indexColorModel.createCompatibleSampleModel(1, 1);
            objectOutputStream.writeInt(sampleModel.getTransferType());
        } else if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            objectOutputStream.writeInt(4);
            boolean bl = ColorModelState.serializeColorSpace(directColorModel.getColorSpace(), objectOutputStream);
            if (!bl) {
                objectOutputStream.writeBoolean(directColorModel.hasAlpha());
            }
            objectOutputStream.writeInt(directColorModel.getPixelSize());
            objectOutputStream.writeInt(directColorModel.getRedMask());
            objectOutputStream.writeInt(directColorModel.getGreenMask());
            objectOutputStream.writeInt(directColorModel.getBlueMask());
            if (bl || directColorModel.hasAlpha()) {
                objectOutputStream.writeInt(directColorModel.getAlphaMask());
            }
            if (bl) {
                objectOutputStream.writeBoolean(directColorModel.isAlphaPremultiplied());
                SampleModel sampleModel = directColorModel.createCompatibleSampleModel(1, 1);
                objectOutputStream.writeInt(sampleModel.getTransferType());
            }
        } else {
            throw new RuntimeException(JaiI18N.getString("ColorModelState0"));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ColorModel colorModel = null;
        ColorSpace colorSpace = null;
        switch (objectInputStream.readInt()) {
            case 0: {
                colorModel = null;
                break;
            }
            case 1: {
                colorSpace = ColorModelState.deserializeColorSpace(objectInputStream);
                if (colorSpace == null) {
                    colorModel = null;
                    return;
                }
                colorModel = new FloatDoubleColorModel(colorSpace, objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 2: {
                colorSpace = ColorModelState.deserializeColorSpace(objectInputStream);
                if (colorSpace == null) {
                    colorModel = null;
                    return;
                }
                colorModel = new ComponentColorModel(colorSpace, (int[])objectInputStream.readObject(), objectInputStream.readBoolean(), objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 3: {
                colorModel = new IndexColorModel(objectInputStream.readInt(), objectInputStream.readInt(), (int[])objectInputStream.readObject(), 0, objectInputStream.readBoolean(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            case 4: {
                colorSpace = ColorModelState.deserializeColorSpace(objectInputStream);
                if (colorSpace != null) {
                    colorModel = new DirectColorModel(colorSpace, objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readBoolean(), objectInputStream.readInt());
                    break;
                }
                if (objectInputStream.readBoolean()) {
                    colorModel = new DirectColorModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                    break;
                }
                colorModel = new DirectColorModel(objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt(), objectInputStream.readInt());
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ColorModelState1"));
            }
        }
        this.theObject = colorModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

