/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.OperationRegistry;
import javax.media.jai.TileCache;
import javax.media.jai.registry.RIFRegistry;

public class StreamRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        SeekableStream seekableStream = (SeekableStream)parameterBlock.getObjectParameter(0);
        try {
            seekableStream.seek(0L);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        ImageDecodeParam imageDecodeParam = null;
        if (parameterBlock.getNumParameters() > 1) {
            imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
        }
        String[] stringArray = ImageCodec.getDecoderNames((SeekableStream)seekableStream);
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        int n = 2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (renderingHints != null) {
            RenderingHints.Key key = JAI.KEY_OPERATION_REGISTRY;
            if (renderingHints.containsKey(key)) {
                operationRegistry = (OperationRegistry)renderingHints.get(key);
            }
            if (renderingHints.containsKey(key = JAI.KEY_OPERATION_BOUND)) {
                n = (Integer)renderingHints.get(key);
            }
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            RenderedImage renderedImage;
            RenderedImageFactory renderedImageFactory = null;
            try {
                renderedImageFactory = RIFRegistry.get(operationRegistry, stringArray[n2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (renderedImageFactory != null && (renderedImage = RIFRegistry.create(operationRegistry, stringArray[n2], parameterBlock, renderingHints)) != null) {
                return renderedImage;
            }
            ++n2;
        }
        boolean bl = seekableStream.canSeekBackwards();
        long l = Long.MIN_VALUE;
        if (bl) {
            try {
                l = seekableStream.getFilePointer();
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)stringArray[n3], (SeekableStream)seekableStream, (ImageDecodeParam)imageDecodeParam);
            RenderedImage renderedImage = null;
            try {
                renderedImage = imageDecoder.decodeAsRenderedImage();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (bl) {
                    TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
                    if (tileCache != null) {
                        tileCache.flush();
                    }
                    System.gc();
                    try {
                        seekableStream.seek(l);
                        renderedImage = imageDecoder.decodeAsRenderedImage();
                    }
                    catch (IOException iOException) {
                        renderedImage = null;
                    }
                }
                throw outOfMemoryError;
            }
            catch (IOException iOException) {
                renderedImage = null;
            }
            if (renderedImage != null) {
                return new NullOpImage(renderedImage, imageLayout, (Map)renderingHints, n);
            }
            ++n3;
        }
        return null;
    }
}

