/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecodeParam;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.OpImage;
import javax.media.jai.TileCache;

public class CodecRIFUtil {
    private CodecRIFUtil() {
    }

    public static RenderedImage create(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        SeekableStream seekableStream = (SeekableStream)parameterBlock.getObjectParameter(0);
        ImageDecodeParam imageDecodeParam = null;
        if (parameterBlock.getNumParameters() > 1) {
            imageDecodeParam = (ImageDecodeParam)parameterBlock.getObjectParameter(1);
        }
        int n = 0;
        if (parameterBlock.getNumParameters() > 2) {
            n = parameterBlock.getIntParameter(2);
        }
        ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)string, (SeekableStream)seekableStream, (ImageDecodeParam)imageDecodeParam);
        try {
            RenderingHints.Key key;
            int n2 = 2;
            ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
            if (renderingHints != null && renderingHints.containsKey(key = JAI.KEY_OPERATION_BOUND)) {
                n2 = (Integer)renderingHints.get(key);
            }
            boolean bl = seekableStream.canSeekBackwards();
            long l = Long.MIN_VALUE;
            if (bl) {
                try {
                    l = seekableStream.getFilePointer();
                }
                catch (IOException iOException) {
                    bl = false;
                }
            }
            OpImage opImage = null;
            try {
                opImage = new NullOpImage(imageDecoder.decodeAsRenderedImage(n), imageLayout, (Map)renderingHints, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (bl) {
                    TileCache tileCache;
                    TileCache tileCache2 = tileCache = opImage != null ? opImage.getTileCache() : RIFUtil.getTileCacheHint(renderingHints);
                    if (tileCache != null) {
                        tileCache.flush();
                    }
                    System.gc();
                    seekableStream.seek(l);
                    opImage = new NullOpImage(imageDecoder.decodeAsRenderedImage(n), imageLayout, (Map)renderingHints, n2);
                }
                throw outOfMemoryError;
            }
            return opImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

