/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineNearestOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.util.Range;

final class AffineNearestBinaryOpImage
extends AffineNearestOpImage {
    public AffineNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle);
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n11 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n12 = dataBufferByte2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f5);
            int n21 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n20;
            double d2 = (double)f6 - (double)n21;
            int n22 = (int)Math.floor(d * 1048576.0);
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f, f2, f3, f4, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31 = (n19 - n8) * n10 + n12;
                int n32 = n9 + (n13 - n7);
                int n33 = (n21 - n2) * n4 + n11;
                int n34 = n20 - n + n3;
                int n35 = n13;
                while (n35 < n28) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n35;
                }
                int n36 = n28;
                while (n36 < n29) {
                    n30 = n33 + (n34 >> 3);
                    byte by = byArray[n30];
                    int n37 = by >> 7 - (n34 & 7) & 1;
                    int n38 = n31 + (n32 >> 3);
                    int n39 = 7 - (n32 & 7);
                    int n40 = byArray2[n38];
                    byArray2[n38] = (byte)(n40 |= n37 << n39);
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n36;
                }
                n30 = n29;
                while (n30 < n15) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n30;
                }
            }
            ++n19;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferShort dataBufferShort2 = (DataBufferShort)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferShort.getData();
        int n11 = dataBufferShort.getOffset();
        short[] sArray2 = dataBufferShort2.getData();
        int n12 = dataBufferShort2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f5);
            int n21 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n20;
            double d2 = (double)f6 - (double)n21;
            int n22 = (int)Math.floor(d * 1048576.0);
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f, f2, f3, f4, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31 = (n19 - n8) * n10 + n12;
                int n32 = n9 + (n13 - n7);
                int n33 = (n21 - n2) * n4 + n11;
                int n34 = n20 - n + n3;
                int n35 = n13;
                while (n35 < n28) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n35;
                }
                int n36 = n28;
                while (n36 < n29) {
                    n30 = n33 + (n34 >> 4);
                    short s = sArray[n30];
                    int n37 = s >> 15 - (n34 & 0xF) & 1;
                    int n38 = n31 + (n32 >> 4);
                    int n39 = 15 - (n32 & 0xF);
                    int n40 = sArray2[n38];
                    sArray2[n38] = (short)(n40 |= n37 << n39);
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n36;
                }
                n30 = n29;
                while (n30 < n15) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n30;
                }
            }
            ++n19;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f = raster.getMinX();
        float f2 = raster.getMinY();
        float f3 = f + (float)raster.getWidth();
        float f4 = f2 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n11 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n12 = dataBufferInt2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint(float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f5);
            int n21 = (int)Math.floor(f6);
            double d = (double)f5 - (double)n20;
            double d2 = (double)f6 - (double)n21;
            int n22 = (int)Math.floor(d * 1048576.0);
            int n23 = (int)Math.floor(d2 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f, f2, f3, f4, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31 = (n19 - n8) * n10 + n12;
                int n32 = n9 + (n13 - n7);
                int n33 = (n21 - n2) * n4 + n11;
                int n34 = n20 - n + n3;
                int n35 = n13;
                while (n35 < n28) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n35;
                }
                int n36 = n28;
                while (n36 < n29) {
                    n30 = n33 + (n34 >> 5);
                    int n37 = nArray[n30];
                    int n38 = n37 >> 31 - (n34 & 0x1F) & 1;
                    int n39 = n31 + (n32 >> 5);
                    int n40 = 31 - (n32 & 0x1F);
                    int n41 = nArray2[n39];
                    nArray2[n39] = n41 |= n38 << n40;
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n36;
                }
                n30 = n29;
                while (n30 < n15) {
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n34 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n34 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n33 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n33 += n18;
                    }
                    ++n32;
                    ++n30;
                }
            }
            ++n19;
        }
    }
}

