/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibSubsampleBinaryToGrayOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.ImageLayout;

public class MlibSubsampleBinaryToGrayRIF
implements RenderedImageFactory {
    private int blockX;
    private int blockY;

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibBinaryCompatible(parameterBlock, null)) {
            return null;
        }
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        if (imageLayout != null && imageLayout.isValid(256) && !MediaLibAccessor.isMediaLibCompatible(imageLayout.getSampleModel(null), imageLayout.getColorModel(null), false) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        if (f == 1.0f && f2 == 1.0f) {
            return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        return new MlibSubsampleBinaryToGrayOpImage(renderedImage, imageLayout, renderingHints, f, f2);
    }
}

