/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;

class MlibSubsampleBinaryToGrayOpImage
extends GeometricOpImage {
    protected float scaleX;
    protected float scaleY;
    private float invScaleX;
    private float invScaleY;
    private float floatTol;
    private int blockX;
    private int blockY;
    private int dWidth;
    private int dHeight;
    private int[] xValues;
    private int[] yValues;
    private byte[] lutGray;

    public MlibSubsampleBinaryToGrayOpImage(RenderedImage renderedImage, ImageLayout imageLayout, Map map, float f, float f2) {
        super(OpImage.vectorize(renderedImage), MlibSubsampleBinaryToGrayOpImage.layoutHelper(renderedImage, f, f2, imageLayout, map), map, true, null, null);
        this.scaleX = f;
        this.scaleY = f2;
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        this.computeDestInfo(n3, n4);
        this.computableBounds = this.extender == null ? new Rectangle(0, 0, this.dWidth, this.dHeight) : this.getBounds();
        this.buildLookupTables();
        this.computeXYValues(n3, n4, n, n2);
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, float f, float f2, ImageLayout imageLayout, Map map) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = renderedImage.getWidth();
        int n2 = renderedImage.getHeight();
        float f3 = f * (float)n;
        float f4 = f2 * (float)n2;
        float f5 = 0.1f * Math.min(f / (f3 + 1.0f), f2 / (f4 + 1.0f));
        int n3 = (int)f3;
        int n4 = (int)f4;
        if (Math.abs((float)Math.round(f3) - f3) < f5) {
            n3 = Math.round(f3);
        }
        if (Math.abs((float)Math.round(f4) - f4) < f5) {
            n4 = Math.round(f4);
        }
        imageLayout2.setMinX((int)(f * (float)renderedImage.getMinX()));
        imageLayout2.setMinY((int)(f2 * (float)renderedImage.getMinY()));
        imageLayout2.setWidth(n3);
        imageLayout2.setHeight(n4);
        if (!imageLayout2.isValid(64)) {
            imageLayout2.setTileWidth(n3);
        }
        if (!imageLayout2.isValid(128)) {
            imageLayout2.setTileHeight(n4);
        }
        SampleModel sampleModel = imageLayout2.getSampleModel(null);
        int n5 = imageLayout2.getTileWidth(null);
        int n6 = imageLayout2.getTileHeight(null);
        if (sampleModel != null && n5 > 0 && n6 > 0 && (n5 != sampleModel.getWidth() || n6 != sampleModel.getHeight())) {
            sampleModel = sampleModel.createCompatibleSampleModel(n5, n6);
        }
        if (sampleModel == null || sampleModel.getDataType() != 0) {
            sampleModel = new PixelInterleavedSampleModel(0, imageLayout2.getTileWidth(null), imageLayout2.getTileHeight(null), 1, imageLayout2.getTileWidth(null), new int[]{0});
        }
        imageLayout2.setSampleModel(sampleModel);
        ColorModel colorModel = imageLayout2.getColorModel(null);
        if (colorModel == null || !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
            imageLayout2.setColorModel(ImageUtil.getCompatibleColorModel(sampleModel, map));
        }
        return imageLayout2;
    }

    protected Rectangle forwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = rectangle.x - this.blockX + 1;
        int n3 = rectangle.y - this.blockY + 1;
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        int n4 = (int)((float)n2 * this.scaleX);
        int n5 = (int)((float)n3 * this.scaleY);
        while (this.xValues[n4] > n2 && n4 > 0) {
            --n4;
        }
        while (this.yValues[n5] > n3 && n5 > 0) {
            --n5;
        }
        int n6 = rectangle.x + rectangle.width - 1;
        int n7 = rectangle.y + rectangle.height - 1;
        int n8 = Math.round((float)n6 * this.scaleX);
        int n9 = Math.round((float)n7 * this.scaleY);
        n8 = n8 >= this.dWidth ? this.dWidth - 1 : n8;
        n9 = n9 >= this.dHeight ? this.dHeight - 1 : n9;
        while (this.xValues[n8] < n6 && n8 < this.dWidth - 1) {
            ++n8;
        }
        while (this.yValues[n9] < n7 && n9 < this.dHeight - 1) {
            ++n9;
        }
        return new Rectangle(n4 += this.minX, n5 += this.minY, (n8 += this.minX) - n4 + 1, (n9 += this.minY) - n5 + 1);
    }

    protected Rectangle backwardMapRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        int n2 = this.xValues[rectangle.x - this.minX];
        int n3 = this.yValues[rectangle.y - this.minY];
        int n4 = this.xValues[rectangle.x - this.minX + rectangle.width - 1];
        int n5 = this.yValues[rectangle.y - this.minY + rectangle.height - 1];
        return new Rectangle(n2, n3, n4 - n2 + this.blockX, n5 - n3 + this.blockY);
    }

    private void computeDestInfo(int n, int n2) {
        this.invScaleX = 1.0f / this.scaleX;
        this.invScaleY = 1.0f / this.scaleY;
        this.blockX = (int)Math.ceil(this.invScaleX);
        this.blockY = (int)Math.ceil(this.invScaleY);
        float f = this.scaleX * (float)n;
        float f2 = this.scaleY * (float)n2;
        this.floatTol = 0.1f * Math.min(this.scaleX / (f + 1.0f), this.scaleY / (f2 + 1.0f));
        this.dWidth = (int)f;
        this.dHeight = (int)f2;
        if (Math.abs((float)Math.round(f) - f) < this.floatTol) {
            this.dWidth = Math.round(f);
        }
        if (Math.abs((float)Math.round(f2) - f2) < this.floatTol) {
            this.dHeight = Math.round(f2);
        }
        if (Math.abs((float)Math.round(this.invScaleX) - this.invScaleX) < this.floatTol) {
            this.invScaleX = Math.round(this.invScaleX);
            this.blockX = (int)this.invScaleX;
        }
        if (Math.abs((float)Math.round(this.invScaleY) - this.invScaleY) < this.floatTol) {
            this.invScaleY = Math.round(this.invScaleY);
            this.blockY = (int)this.invScaleY;
        }
    }

    private final void buildLookupTables() {
        int n;
        if (this.lutGray != null) {
            return;
        }
        this.lutGray = new byte[this.blockX * this.blockY + 1];
        int n2 = 0;
        while (n2 < this.lutGray.length) {
            n = Math.round(255.0f * (float)n2 / (float)(this.lutGray.length - 1));
            this.lutGray[n2] = (byte)(n > 255 ? -1 : (byte)n);
            ++n2;
        }
        if (MlibSubsampleBinaryToGrayOpImage.isMinWhite(this.getSourceImage(0).getColorModel())) {
            n = 0;
            while (n < this.lutGray.length) {
                this.lutGray[n] = (byte)(255 - (0xFF & this.lutGray[n]));
                ++n;
            }
        }
    }

    static boolean isMinWhite(ColorModel colorModel) {
        if (colorModel == null || !(colorModel instanceof IndexColorModel)) {
            return false;
        }
        byte[] byArray = new byte[256];
        ((IndexColorModel)colorModel).getReds(byArray);
        return byArray[0] == -1;
    }

    private void computeXYValues(int n, int n2, int n3, int n4) {
        float f;
        if (this.xValues == null || this.yValues == null) {
            this.xValues = new int[this.dWidth];
            this.yValues = new int[this.dHeight];
        }
        int n5 = 0;
        while (n5 < this.dWidth) {
            f = this.invScaleX * (float)n5;
            this.xValues[n5] = Math.round(f);
            ++n5;
        }
        if (this.xValues[this.dWidth - 1] + this.blockX > n) {
            int n6 = this.dWidth - 1;
            this.xValues[n6] = this.xValues[n6] - 1;
        }
        int n7 = 0;
        while (n7 < this.dHeight) {
            f = this.invScaleY * (float)n7;
            this.yValues[n7] = Math.round(f);
            ++n7;
        }
        if (this.yValues[this.dHeight - 1] + this.blockY > n2) {
            int n8 = this.dHeight - 1;
            this.xValues[n8] = this.xValues[n8] - 1;
        }
        if (n3 != 0) {
            int n9 = 0;
            while (n9 < this.dWidth) {
                int n10 = n9++;
                this.xValues[n10] = this.xValues[n10] + n3;
            }
        }
        if (n4 != 0) {
            int n11 = 0;
            while (n11 < this.dHeight) {
                int n12 = n11++;
                this.yValues[n12] = this.yValues[n12] + n4;
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = writableRaster.getSampleModel().getDataType() | 0x100 | 0;
        int n2 = MediaLibAccessor.findCompatibleTag(null, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n, true);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n2);
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    Image.SubsampleBinaryToGray((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double)this.scaleX, (double)this.scaleY, (byte[])this.lutGray);
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(JaiI18N.getString("MlibUshort"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

