/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibScaleBicubicOpImage;
import com.sun.media.jai.mlib.MlibScaleBilinearOpImage;
import com.sun.media.jai.mlib.MlibScaleNearestOpImage;
import com.sun.media.jai.mlib.MlibScaleTableOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;

public class MlibScaleRIF
implements RenderedImageFactory {
    private static final float TOLERANCE = 0.01f;

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        boolean bl2;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        boolean bl3 = bl2 = !(interpolation instanceof InterpolationTable) || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2;
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, bl2) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        SampleModel sampleModel = renderedImage.getSampleModel();
        boolean bl4 = bl = sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3);
        if (bl) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        float f3 = parameterBlock.getFloatParameter(2);
        float f4 = parameterBlock.getFloatParameter(3);
        if (f == 1.0f && f2 == 1.0f && f3 == 0.0f && f4 == 0.0f && MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, false)) {
            return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        if (f == 1.0f && f2 == 1.0f && Math.abs(f3 - (float)((int)f3)) < 0.01f && Math.abs(f4 - (float)((int)f4)) < 0.01f) {
            return new TranslateIntOpImage(renderedImage, (int)f3, (int)f4);
        }
        if (interpolation instanceof InterpolationNearest) {
            return new MlibScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f, f2, f3, f4, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f, f2, f3, f4, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f, f2, f3, f4, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibScaleTableOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f, f2, f3, f4, interpolation);
        }
        return null;
    }
}

