/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibAffineBicubicOpImage;
import com.sun.media.jai.mlib.MlibAffineBilinearOpImage;
import com.sun.media.jai.mlib.MlibAffineNearestOpImage;
import com.sun.media.jai.mlib.MlibAffineTableOpImage;
import com.sun.media.jai.mlib.MlibCopyOpImage;
import com.sun.media.jai.mlib.MlibTransposeOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.InterpolationTable;

public class MlibRotateRIF
implements RenderedImageFactory {
    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        boolean bl;
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(3);
        boolean bl2 = bl = !(interpolation instanceof InterpolationTable) || interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2;
        if (!MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, bl) || !MediaLibAccessor.hasSameNumBands(parameterBlock, imageLayout)) {
            return null;
        }
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        float f3 = parameterBlock.getFloatParameter(2);
        double d = (double)(180.0f * f3) / Math.PI;
        double d2 = Math.round(d);
        if (Math.abs(d2 - d) < 1.0E-4) {
            int n = (int)d2 % 360;
            if (n < 0) {
                n += 360;
            }
            if (n == 0 && MediaLibAccessor.isMediaLibCompatible(parameterBlock, imageLayout, false)) {
                return new MlibCopyOpImage(renderedImage, renderingHints, imageLayout);
            }
            int n2 = Math.round(f);
            int n3 = Math.round(f2);
            if (n % 90 == 0 && (double)Math.abs(f - (float)n2) < 1.0E-4 && (double)Math.abs(f2 - (float)n3) < 1.0E-4) {
                int n4 = -1;
                int n5 = 0;
                int n6 = 0;
                int n7 = renderedImage.getMinX();
                int n8 = renderedImage.getMinY();
                int n9 = n7 + renderedImage.getWidth();
                int n10 = n8 + renderedImage.getHeight();
                if (n == 90) {
                    n4 = 4;
                    n5 = n2 - (n10 - n3);
                    n6 = n3 - (n2 - n7);
                } else if (n == 180) {
                    n4 = 5;
                    n5 = 2 * n2 - n9;
                    n6 = 2 * n3 - n10;
                } else {
                    n4 = 6;
                    n5 = n2 - (n3 - n8);
                    n6 = n3 - (n9 - n2);
                }
                MlibTransposeOpImage mlibTransposeOpImage = new MlibTransposeOpImage(renderedImage, renderingHints, imageLayout, n4);
                int n11 = mlibTransposeOpImage.getMinX();
                int n12 = mlibTransposeOpImage.getMinY();
                return new TranslateIntOpImage(mlibTransposeOpImage, n5 - n11, n6 - n12);
            }
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f3, f, f2);
        if (interpolation instanceof InterpolationNearest) {
            return new MlibAffineNearestOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            return new MlibAffineBilinearOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new MlibAffineBicubicOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        if (interpolation instanceof InterpolationTable) {
            return new MlibAffineTableOpImage(renderedImage, borderExtender, (Map)renderingHints, imageLayout, affineTransform, interpolation);
        }
        return null;
    }
}

