/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.viewer.extensions;

import com.esri.ogc.client.ConnException;
import com.esri.ogc.client.WMSUtil;
import com.esri.ogc.viewer.extensions.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class WMSConnectionDialog
extends JDialog {
    JPanel panel_WMSConnection = new JPanel();
    JButton jButton_OK = new JButton();
    JButton jButton_Cancel = new JButton();
    JTextField jTextField_ServiceName = new JTextField();
    JPanel jPanel_WMSConnectionParameters = new JPanel();
    JLabel jLabel_Version = new JLabel();
    JComboBox jComboBox_Version = new JComboBox();
    JLabel jLabel_ServerURL = new JLabel();
    JLabel jLabel_ServiceName = new JLabel();
    JComboBox jComboBox_ServerURL = new JComboBox();
    private WMSUtil _$3464;

    private void _$3465() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public WMSConnectionDialog(Frame frame, String title, boolean modal, WMSUtil ogcUtil) {
        super(frame, title, modal);
        try {
            this._$3464 = ogcUtil;
            this.jbInit();
            this._$3465();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WMSConnectionDialog(WMSUtil ogcUtil) {
        this(null, "", false, ogcUtil);
        this._$3465();
    }

    void jbInit() throws Exception {
        this.panel_WMSConnection.setLayout(new FlowLayout());
        this.jButton_OK.setText(Resource.getBundleText("OK"));
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WMSConnectionDialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setText(Resource.getBundleText("Cancel"));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WMSConnectionDialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jTextField_ServiceName.setText("");
        this.jTextField_ServiceName.setMaximumSize(new Dimension(110, 20));
        this.jTextField_ServiceName.setPreferredSize(new Dimension(110, 20));
        this.jTextField_ServiceName.setMaximumSize(new Dimension(110, 20));
        this.jPanel_WMSConnectionParameters.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), ""));
        this.jLabel_Version.setText("Version:");
        this.jLabel_ServerURL.setText(Resource.getBundleText("URL"));
        this.jLabel_ServiceName.setText(String.valueOf(String.valueOf(Resource.getBundleText("ServiceName"))).concat("   "));
        this.jComboBox_ServerURL.setUI(new BasicComboBoxUI());
        this.jComboBox_ServerURL.setMinimumSize(new Dimension(440, 20));
        this.jComboBox_ServerURL.setPreferredSize(new Dimension(440, 20));
        this.jComboBox_ServerURL.addItem(Resource.getBundleText("HTTP"));
        this.jComboBox_ServerURL.setEditable(true);
        this.setTitle(Resource.getBundleText("WMSConnection"));
        this.panel_WMSConnection.add(this.jButton_OK);
        this.panel_WMSConnection.add(this.jButton_Cancel);
        this.jPanel_WMSConnectionParameters.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.jPanel_WMSConnectionParameters.add((Component)this.jLabel_ServerURL, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        this.jPanel_WMSConnectionParameters.add((Component)this.jLabel_ServiceName, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        this.jPanel_WMSConnectionParameters.add((Component)this.jComboBox_ServerURL, c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        this.jPanel_WMSConnectionParameters.add((Component)this.jTextField_ServiceName, c);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel_WMSConnectionParameters, "Center");
        this.getContentPane().add((Component)this.panel_WMSConnection, "South");
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        String url = "";
        String vsp = "";
        String version = "";
        url = (String)this.jComboBox_ServerURL.getSelectedItem();
        url = url.trim();
        int count = 0;
        for (int i = 0; i < this.jComboBox_ServerURL.getItemCount(); ++i) {
            String itemUrl = (String)this.jComboBox_ServerURL.getItemAt(i);
            if (!url.equals(itemUrl.trim())) continue;
            ++count;
        }
        if (count < 1) {
            this.jComboBox_ServerURL.addItem(url.trim());
        }
        if (this.jTextField_ServiceName.getText() != null && this.jTextField_ServiceName.getText().trim().length() > 0) {
            vsp = "SERVICENAME=".concat(String.valueOf(String.valueOf(this.jTextField_ServiceName.getText().trim())));
        }
        int type = this.getCursor().getType();
        this.setCursor(new Cursor(3));
        try {
            this._$3464.AddWMSLayer(url, vsp, version);
        }
        catch (ConnException ec) {
            JOptionPane.showMessageDialog(this, "A connection with the server could not be established.", "Error", 0);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "Invalid Capabilities File. Check Server URL");
        }
        this.setCursor(new Cursor(type));
        this.dispose();
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.hideDialog();
        this.disposeDialog();
    }

    void hideDialog() {
        this.hide();
    }

    void disposeDialog() {
        this.dispose();
    }
}

