/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.viewer.extensions;

import com.esri.mo.map.dpy.LayerInfo;
import com.esri.ogc.client.WFSServer;
import com.esri.ogc.client.WMSUtil;
import com.esri.ogc.viewer.extensions.Resource;
import com.esri.ogc.viewer.extensions.WFSLayerSelectionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class WFSConnectionDialog
extends JDialog {
    JPanel panel_WFSConnection = new JPanel();
    JButton jButton_OK = new JButton();
    JButton jButton_Cancel = new JButton();
    JButton jButton_conn = new JButton();
    JTextField jTextField_ServiceName = new JTextField();
    JPanel jPanel_WFSConnectionParameters = new JPanel();
    JLabel jLabel_Version = new JLabel();
    JComboBox jComboBox_Version = new JComboBox();
    JLabel jLabel_ServerURL = new JLabel();
    JLabel jLabel_ServiceName = new JLabel();
    JComboBox jComboBox_ServerURL = new JComboBox();
    JLabel jLabel_layer = new JLabel();
    JComboBox jComboBox_layer = new JComboBox();
    WMSUtil _ogcUtil;
    WFSLayerSelectionDialog _layersDialog;
    private WFSServer _$12825;

    private void _$3465() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        ((Component)this).setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public WFSConnectionDialog(Frame frame, String title, boolean modal, WMSUtil ogcUtil) {
        super(frame, title, modal);
        try {
            this._ogcUtil = ogcUtil;
            this.jbInit();
            this._$3465();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public WFSConnectionDialog(WMSUtil ogcUtil) {
        this(null, "", false, ogcUtil);
        this._$3465();
    }

    void jbInit() throws Exception {
        this.panel_WFSConnection.setLayout(new FlowLayout());
        this.jButton_conn.setText(Resource.getBundleText("Create"));
        this.jButton_conn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WFSConnectionDialog.this.jButton_Conn_actionPerformed(e);
            }
        });
        this.jButton_OK.setText(Resource.getBundleText("OK"));
        this.jButton_OK.setEnabled(false);
        this.jButton_OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WFSConnectionDialog.this.jButton_OK_actionPerformed(e);
            }
        });
        this.jButton_Cancel.setText(Resource.getBundleText("Cancel"));
        this.jButton_Cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WFSConnectionDialog.this.jButton_Cancel_actionPerformed(e);
            }
        });
        this.jTextField_ServiceName.setText("");
        this.jTextField_ServiceName.setColumns(20);
        this.jPanel_WFSConnectionParameters.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), ""));
        this.jLabel_Version.setText("Version:");
        this.jLabel_ServerURL.setText(Resource.getBundleText("URL"));
        this.jLabel_ServiceName.setText(String.valueOf(String.valueOf(Resource.getBundleText("ServiceName"))).concat("   "));
        this.jComboBox_ServerURL.setMinimumSize(new Dimension(440, 20));
        this.jComboBox_ServerURL.setPreferredSize(new Dimension(440, 20));
        this.jComboBox_ServerURL.addItem(Resource.getBundleText("HTTP"));
        this.jComboBox_ServerURL.setEditable(true);
        this.jComboBox_ServerURL.setUI(new BasicComboBoxUI());
        this.jComboBox_Version.setEditable(true);
        this.setTitle(Resource.getBundleText("WFSConnection"));
        this.jPanel_WFSConnectionParameters.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        this.jPanel_WFSConnectionParameters.add((Component)this.jLabel_ServerURL, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        this.jPanel_WFSConnectionParameters.add((Component)this.jLabel_ServiceName, c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        this.jPanel_WFSConnectionParameters.add((Component)this.jComboBox_ServerURL, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 17;
        this.jPanel_WFSConnectionParameters.add((Component)this.jTextField_ServiceName, c);
        c.gridy = 2;
        c.anchor = 16;
        this.jPanel_WFSConnectionParameters.add((Component)this.jButton_conn, c);
        JPanel jPanel_above = new JPanel();
        jPanel_above.setLayout(new GridBagLayout());
        JPanel jPanel_layer = new JPanel();
        jPanel_layer.setLayout(new FlowLayout(0));
        jPanel_layer.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134)), ""));
        this.jLabel_layer.setText(Resource.getBundleText("WFSLayer"));
        this.jLabel_layer.disable();
        this.jComboBox_layer.setMinimumSize(new Dimension(110, 20));
        this.jComboBox_layer.setPreferredSize(new Dimension(110, 20));
        this.jComboBox_layer.disable();
        jPanel_layer.add(this.jLabel_layer);
        jPanel_layer.add(this.jComboBox_layer);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        jPanel_above.add((Component)this.jPanel_WFSConnectionParameters, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.anchor = 17;
        jPanel_above.add((Component)jPanel_layer, c);
        this.panel_WFSConnection.add(this.jButton_OK);
        this.panel_WFSConnection.add(this.jButton_Cancel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel_above, "Center");
        this.getContentPane().add((Component)this.panel_WFSConnection, "South");
    }

    void jButton_Conn_actionPerformed(ActionEvent e) {
        try {
            String url = "";
            String vsp = "";
            String version = "";
            this.jComboBox_layer.removeAllItems();
            int type = this.getCursor().getType();
            this.setCursor(new Cursor(3));
            if (version.equals("")) {
                version = "1.0.0";
            } else if (version == null) {
                version = "1.0.0";
            }
            url = (String)this.jComboBox_ServerURL.getSelectedItem();
            url = url.trim();
            int count = 0;
            for (int i = 0; i < this.jComboBox_ServerURL.getItemCount(); ++i) {
                String itemUrl = (String)this.jComboBox_ServerURL.getItemAt(i);
                if (!url.equals(itemUrl.trim())) continue;
                ++count;
            }
            if (count < 1) {
                this.jComboBox_ServerURL.addItem(url.trim());
            }
            if (this.jTextField_ServiceName.getText() != null && this.jTextField_ServiceName.getText().trim().length() > 0) {
                vsp = this.jTextField_ServiceName.getText();
            }
            try {
                this._$12825 = this._ogcUtil.connectWFS(url, vsp, version);
                if (this._$12825 != null) {
                    LayerInfo[] layerinfo = this._$12825.getLayerInfo();
                    LayerInfo linfo = null;
                    for (int i = 0; i < layerinfo.length; ++i) {
                        linfo = layerinfo[i];
                        this.jComboBox_layer.addItem(linfo.getDataset().getName());
                    }
                }
            }
            catch (Exception eeeee) {
                JOptionPane.showMessageDialog(this, "No layers available. Check URL and Service name.", "Error", 0);
            }
            this.jLabel_layer.setEnabled(true);
            this.jComboBox_layer.setEditable(false);
            this.jComboBox_layer.setEnabled(true);
            this.jButton_OK.setEnabled(true);
            this.setCursor(new Cursor(type));
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(this, "WFS capabilities can't be parsed");
        }
    }

    void jButton_OK_actionPerformed(ActionEvent e) {
        int type = this.getCursor().getType();
        this.setCursor(new Cursor(3));
        this._ogcUtil.AddWFSLayer(this._$12825, (String)this.jComboBox_layer.getSelectedItem());
        this.setCursor(new Cursor(type));
        this.dispose();
    }

    void jButton_Cancel_actionPerformed(ActionEvent e) {
        this.hideDialog();
        this.disposeDialog();
    }

    void hideDialog() {
        this.hide();
        this.dispose();
    }

    void disposeDialog() {
        this.dispose();
    }
}

