/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.viewer;

import com.esri.mo.map.dpy.Layer;
import com.esri.mo.ui.bean.Legend;
import com.esri.mo.ui.bean.Map;
import com.esri.mo.ui.bean.Print;
import com.esri.mo.ui.gn.GeographyNetwork;
import com.esri.mo.ui.tb.BaseToolBar;
import com.esri.mo.util.MessageCentre;
import com.esri.ogc.viewer.BrowserFileDialog;
import com.esri.ogc.viewer.DataSourceUI;
import com.esri.ogc.viewer.FileToolBarActions;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class FileToolBar
extends BaseToolBar {
    public static final String OPEN_DATA = "OpenData";
    public static final String PRINT = "Print";
    public static final String REMOVE_DATA = "Remove Data";
    public static final String GN_DATA = "Geography Network";
    Map _map;
    Legend _legend;
    DataSourceUI _dataSourceUI;

    public FileToolBar() {
        this(true);
    }

    public FileToolBar(boolean createDefaultActions) {
        if (createDefaultActions) {
            this.addDefaultActions();
        }
    }

    public void addDefaultActions() {
        this.actions = new FileToolBarActions(this);
        this.setButtonAction(this.actions.getActionIndex(OPEN_DATA), true);
        this.setButtonAction(this.actions.getActionIndex(GN_DATA), true);
        this.setButtonAction(this.actions.getActionIndex(PRINT), true);
        this.setButtonAction(this.actions.getActionIndex(REMOVE_DATA), true);
        this.actions.getAction(OPEN_DATA).setEnabled(true);
        this.actions.getAction(GN_DATA).setEnabled(true);
        this.actions.getAction(PRINT).setEnabled(true);
        this.actions.getAction(REMOVE_DATA).setEnabled(false);
        this.refresh();
    }

    public void setMap(Map map) {
        this._map = map;
    }

    public void setLegend(Legend legend) {
        this._legend = legend;
    }

    void openData() {
        if (this._dataSourceUI == null) {
            this._dataSourceUI = new DataSourceUI(this.findFrame());
            this._dataSourceUI.setMap(this._map);
        }
        ((Component)this._dataSourceUI).setVisible(true);
        this.actions.getAction(REMOVE_DATA).setEnabled(true);
    }

    JFrame findFrame() {
        return (JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    void print() {
        Print mapPrint = new Print();
        mapPrint.setMap(this._map);
        mapPrint.doPrint();
    }

    void openGN() {
        try {
            GeographyNetwork gnb = new GeographyNetwork();
            FileInputStream gnDefaultsFileIn = null;
            gnb.setMap(this._map);
            Properties prop = new Properties();
            File file = new File(System.getProperty("user.home"), "aimsclient.properties");
            if (!file.exists() && !(file = new File("c:/temp/gnbrowser.properties")).exists()) {
                this.setGNPath();
            }
            gnDefaultsFileIn = new FileInputStream(file);
            prop.load(gnDefaultsFileIn);
            gnb.setBrowser(prop.getProperty("WebBrowser"));
            gnb.setMode("javaviewer");
            gnb.setVisible(true);
            this.actions.getAction(REMOVE_DATA).setEnabled(true);
        }
        catch (FileNotFoundException gnb) {
        }
        catch (Exception exp) {
            MessageCentre.get().log((Object)this, exp);
        }
    }

    void removeData() {
        try {
            Layer layer = this._legend.getLayer();
            this._map.getLayerset().removeLayer(layer);
            this._legend.setSelected(false);
            if (this._map.getLayerset() instanceof Map) {
                this.actions.getAction(REMOVE_DATA).setEnabled(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._map.redraw();
    }

    void setGNPath() {
        BrowserFileDialog dialog = new BrowserFileDialog(null, true, GN_DATA);
        ((Component)dialog).setVisible(true);
    }

    static {
        OPEN_DATA = OPEN_DATA;
        PRINT = PRINT;
        REMOVE_DATA = REMOVE_DATA;
        GN_DATA = GN_DATA;
    }
}

