/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client.service;

import com.esri.mo.cs.geom.BasePolygon;
import com.esri.mo.cs.geom.BasePolyline;
import com.esri.mo.cs.geom.MultiPoint;
import com.esri.mo.cs.geom.Path;
import com.esri.mo.cs.geom.PointCollection;
import com.esri.mo.cs.geom.Ring;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.Fields;
import com.esri.ogc.client.gml.Features;
import com.esri.ogc.client.service.FeatureTypeDesc;
import com.esri.ogc.client.service.OgcHttpConnection;
import com.esri.ogc.client.service.WFSFeature_new;
import com.esri.ogc.client.service.WFSServiceProxy;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class WriteToGML {
    private BaseFeature _$590;
    private String _$593;
    private String _$21364 = "\n";
    private FileWriter _$595;
    private Fields _$597;
    private PointCollection _$599;

    public WriteToGML(BaseFeature bf, String name) {
        this._$590 = bf;
        this._$593 = name;
        this._$597 = this._$590.getFields();
    }

    public void writeSchemaToFile() throws IOException {
        this._$595 = new FileWriter("ogc_ext_config/schemaOut_client.xml");
        String schema = String.valueOf(String.valueOf(new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n").append(this._$21364).append("<schema targetNamespace=\"http://www.esri.com/WFS\"").append(" xmlns:xsd=\"http://www.w3.org/2000/XMLSchema\"").append(" xmlns:gml=\"http://www.opengis.net/gml\"").append(" xmlns:wfs=\"http://www.esri.com/WFS\">").append(this._$21364).append("<import namespace=\"http://www.opengis.net/gml\" schemaLocation=\"feature.xsd\" />").append(this._$21364).append("<element name=\"Features\" type=\"wfs:featuresType\" substitutionGroup=\"gml:_FeatureCollection\" />").append(this._$21364).append("<complexType name=\"featuresType\"><complexContent><extension base=\"gml:AbstractFeatureCollectionType\" />").append(this._$21364).append("</complexContent></complexType>")));
        schema = String.valueOf(String.valueOf(schema)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._$21364))).append("<element name=\"").append(this._$593).append("\" type=\"wfs:").append(this._$593).append("Type\" substitutionGroup=\"gml:_Feature\" />"))))));
        schema = String.valueOf(String.valueOf(schema)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._$21364))).append("<complexType name=\"").append(this._$593).append("Type\">\n<complexContent><extension base=\"gml:AbstractFeatureType\">\n<sequence>"))))));
        System.out.println(this._$590.getGeometry());
        for (int i = 0; i < this._$597.getNumFields(); ++i) {
            String type = "";
            if (this._$597.getField(i).getType() == 12) {
                type = "string";
            } else if (this._$597.getField(i).getType() == 4) {
                type = "integer";
            } else if (this._$597.getField(i).getType() == -98) {
                type = this._$590.getGeometry() instanceof BasePolygon ? "gml:MultiPolygonPropertyType" : (this._$590.getGeometry() instanceof BasePolyline ? "gml:MultiLineStringPropertyType" : "gml:MultiPointPropertyType");
            }
            schema = String.valueOf(String.valueOf(schema)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._$21364))).append("<element name=\"").append(this._$597.getField(i).getName()).append("\" type=\"").append(type).append("\"/>"))))));
        }
        schema = String.valueOf(String.valueOf(schema)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this._$21364)).concat("</sequence>\n</extension></complexContent></complexType></schema>"))));
        this._$595.write(schema);
        this._$595.close();
    }

    public void createGMLFile() throws IOException {
        this._$595 = new FileWriter("ogc_ext_config/gmlOut_client.xml", true);
        String gml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
        gml = String.valueOf(String.valueOf(gml)).concat("<gml:featureCollection xmlns=\"http://www.arcxml.net/efs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" xsi:schemaLocation=\"http://www.arcxml.net/efs C:\\data\\wfs.xsd http://www.esri.com/gml/feature.xsd\" >\n");
        this._$595.write(gml);
    }

    public void writeFeatureToFile() throws IOException {
        String gml = "";
        gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("<gml:featureMember>\n<").append(this._$593.replace(' ', '_')).append(">\n"))))));
        for (int i = 0; i < this._$597.getNumFields() - 1; ++i) {
            gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("<").append(this._$597.getField(i).getName().replace('#', '_')).append(">").append(this._$590.getValue(i)).append("</").append(this._$597.getField(i).getName().replace('#', '_')).append(">"))))));
        }
        gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("<").append(this._$590.getShapeField().getName().replace('#', '_')).append(">"))))));
        if (this._$590.getGeometry() instanceof BasePolygon) {
            gml = String.valueOf(String.valueOf(gml)).concat("<gml:MultiPolygon>\n");
            BasePolygon polygon = (BasePolygon)this._$590.getGeometry();
            Ring[] rings = polygon.getRings();
            for (int i = 0; i < rings.length; ++i) {
                this._$599 = rings[i].getPoints();
                gml = String.valueOf(String.valueOf(gml)).concat("<gml:polygonMember>\n<gml:Polygon><gml:outerBoundaryIs>\n<gml:LinearRing>\n<gml:coordinates decimal=\".\" cs=\",\" ts=\" \">");
                gml = this.addPoints(gml, this._$599);
                gml = String.valueOf(String.valueOf(gml)).concat("\n</gml:coordinates>\n</gml:LinearRing>\n</gml:outerBoundaryIs>\n</gml:Polygon>\n</gml:polygonMember>\n");
            }
            gml = String.valueOf(String.valueOf(gml)).concat("</gml:MultiPolygon>\n");
        } else if (this._$590.getGeometry() instanceof BasePolyline) {
            gml = String.valueOf(String.valueOf(gml)).concat("<gml:MultilineString>");
            BasePolyline polyline = (BasePolyline)this._$590.getGeometry();
            Path[] paths = polyline.getPaths();
            for (int i = 0; i < paths.length; ++i) {
                gml = String.valueOf(String.valueOf(gml)).concat("<gml:lineStringMember>\n<gml:LineString>\n<gml:coordinates decimal=\".\" cs=\",\" ts=\" \">");
                this._$599 = paths[i].getPoints();
                gml = this.addPoints(gml, this._$599);
                gml = String.valueOf(String.valueOf(gml)).concat("\n</gml:coordinates>\n</gml:LineString>\n</gml:lineStringMember></gml:MultilineString>");
            }
        } else {
            gml = String.valueOf(String.valueOf(gml)).concat("<gml:MultiPoint>");
            MultiPoint mp = (MultiPoint)this._$590.getGeometry();
            this._$599 = mp.getPoints();
            gml = this.addPoints(gml, this._$599);
            gml = String.valueOf(String.valueOf(gml)).concat("</gml:MultiPoint>");
        }
        gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("</").append(this._$590.getShapeField().getName().replace('#', '_')).append(">"))))));
        gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("</").append(this._$593).append("></gml:featureMember>\n"))))));
        this._$595.write(gml);
    }

    public void writeEnd() throws IOException {
        String gml = "";
        gml = String.valueOf(String.valueOf(gml)).concat("</gml:featureCollection>");
        this._$595.write(gml);
        this._$595.close();
    }

    public String addPoints(String gml, PointCollection pc) {
        double[] xs = pc.getX();
        double[] ys = pc.getY();
        for (int i = 0; i < xs.length; ++i) {
            gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(xs[i]))).append(",").append(ys[i]).append(" "))))));
        }
        return gml;
    }

    public static void main(String[] args) {
        try {
            String urlString = "http://weihongzhu/servlet/com.esri.ogc.wfs.WFSServlet?";
            String serviceName = "";
            String version = "0.0.15";
            String shapeField = "";
            BaseFields fields = null;
            OgcHttpConnection connection = new OgcHttpConnection(urlString, serviceName);
            connection.createConnection();
            WFSServiceProxy wfsService = new WFSServiceProxy(connection, version);
            FeatureTypeDesc[] ftd = wfsService.describeAllFeatureType(serviceName, version);
            FeatureTypeDesc ft_layer = null;
            for (int i = 0; i < ftd.length; ++i) {
                if (!ftd[i].getFeatureName().equalsIgnoreCase("cities")) continue;
                fields = ftd[i].getFeatureFields();
                shapeField = ftd[i].getShapeColumnName();
                ft_layer = ftd[i];
            }
            String wfsFilter = "<Filter><Inside><PropertyName>_SHAPE_</PropertyName><gml:Box srsName=\"EPSG:4326\"><coordinates>-74.042304577117,40.68460874440004 -73.98188585980914,40.741551596414375</coordinates></gml:Box></Inside></Filter>";
            InputStream is = wfsService.getFeatureStream(5, "cities", wfsFilter, fields);
            WFSFeature_new wfsFeature = new WFSFeature_new(is, ft_layer.getFeatureFields(), "cities");
            Features features = wfsFeature.unMarshalling();
            wfsFeature.generateWFSFeatures(features);
            Vector fs = wfsFeature.getWFSFeatures();
            Enumeration vfs = fs.elements();
            BaseFeature bf = (BaseFeature)vfs.nextElement();
            WriteToGML wGML = new WriteToGML(bf, "cities");
            wGML.writeFeatureToFile();
        }
        catch (Exception e) {
            System.out.println("exception from main ".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
    }
}

