/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client.service;

import com.esri.mo.file.shp.DbfField;
import com.esri.mo.file.shp.DbfFile;
import com.esri.mo.file.shp.PointShp;
import com.esri.mo.file.shp.PolygonShp;
import com.esri.mo.file.shp.ShpFile;
import com.esri.ogc.client.service.PointShape;
import com.esri.ogc.client.service.PolygonShape;
import java.util.Vector;

public class SaveToShape {
    protected void writeShapefile(int intDatasetType, Vector v, String path) {
        double doubleVal = 0.0;
        try {
            if (intDatasetType == 0) {
                String fileName = String.valueOf(String.valueOf(path)).concat("/point");
                System.out.println("creating shapefile...");
                ShpFile shpfile = new ShpFile(String.valueOf(String.valueOf(fileName)).concat(".shp"));
                shpfile.openNew(1);
                PointShp pointshp = (PointShp)shpfile.getField();
                DbfFile dbf = new DbfFile(String.valueOf(String.valueOf(fileName)).concat(".dbf"));
                dbf.openNew();
                DbfField doubleField = DbfField.create((String)"DOUBLE", (int)8, (int)17, (int)4);
                dbf.addField(doubleField);
                for (int i = 0; i < v.size(); ++i) {
                    PointShape pt = (PointShape)v.get(i);
                    double x = pt.getX();
                    double y = pt.getY();
                    System.out.println("X = ".concat(String.valueOf(String.valueOf(x))));
                    pointshp.setNumPoints(1);
                    pointshp.setXAt(0, x);
                    pointshp.setYAt(0, y);
                    pointshp.putValue();
                    shpfile.putRecord();
                    doubleField.putValue((Object)new Double(doubleVal));
                    doubleVal += 1.0;
                    if (doubleVal > 9.99999999999999E14) {
                        doubleVal = 0.0;
                    }
                    dbf.putRecord();
                }
                dbf.close();
                shpfile.close();
                System.out.println("shapefile completed...");
            } else if (intDatasetType == 2) {
                String fileName = String.valueOf(String.valueOf(path)).concat("/polygons");
                ShpFile shpfile = new ShpFile(String.valueOf(String.valueOf(fileName)).concat(".shp"));
                shpfile.openNew(5);
                PolygonShp polyshp = (PolygonShp)shpfile.getField();
                DbfFile dbf = new DbfFile(String.valueOf(String.valueOf(fileName)).concat(".dbf"));
                dbf.openNew();
                DbfField doubleField = DbfField.create((String)"DOUBLE", (int)8, (int)17, (int)4);
                dbf.addField(doubleField);
                for (int i = 0; i < v.size(); ++i) {
                    if (!(v.get(i) instanceof PolygonShape)) continue;
                    PolygonShape poly = (PolygonShape)v.get(i);
                    double[] xlist = poly.getXPoints();
                    double[] ylist = poly.getYPoints();
                    for (int j = 0; j < xlist.length; ++j) {
                        double x = xlist[j];
                        double y = ylist[j];
                        System.out.println("X = ".concat(String.valueOf(String.valueOf(x))));
                    }
                    polyshp.setNumParts(1);
                    polyshp.setNumPoints(0, xlist.length);
                    polyshp.setX(0, xlist);
                    polyshp.setY(0, ylist);
                    polyshp.putValue();
                    shpfile.putRecord();
                    doubleField.putValue((Object)new Double(doubleVal));
                    doubleVal += 1.0;
                    if (doubleVal > 9.99999999999999E14) {
                        doubleVal = 0.0;
                    }
                    dbf.putRecord();
                }
                dbf.close();
                shpfile.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error writing shapefile: ".concat(String.valueOf(String.valueOf(e))));
            e.printStackTrace();
        }
    }
}

