/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client.service;

import com.esri.mo.cs.geom.BaseMultiPoint;
import com.esri.mo.cs.geom.BasePath;
import com.esri.mo.cs.geom.BasePointsArray;
import com.esri.mo.cs.geom.BasePolygon;
import com.esri.mo.cs.geom.BasePolyline;
import com.esri.mo.cs.geom.BaseRing;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.MultiPoint;
import com.esri.mo.cs.geom.Path;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.PointCollection;
import com.esri.mo.cs.geom.Polygon;
import com.esri.mo.cs.geom.Polyline;
import com.esri.mo.cs.geom.Ring;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.BaseField;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.DataID;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.data.feat.Row;
import com.esri.mo.data.omc.ScaleDataID;
import com.esri.mo.util.Date;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.LinkedList;

final class FeatureStream
extends DataInputStream {
    private static final boolean _$192031 = false;
    private static final boolean _$192032 = false;
    private static final boolean _$192033 = false;
    private static final boolean _$192034 = false;
    private static final boolean _$192035 = false;
    private final byte _$192036 = 1;
    private final byte _$192037 = (byte)2;
    private final byte _$192038 = (byte)3;
    private final byte _$192039 = (byte)4;
    private final byte _$192040 = (byte)5;
    private final byte _$192041 = (byte)6;
    private final byte _$192042 = (byte)7;
    private final byte _$192043 = (byte)8;
    private final byte _$192044 = (byte)9;
    private final byte _$192045 = (byte)10;
    private final byte _$192046 = (byte)-1;
    private final byte _$192047 = (byte)11;
    private final byte _$192048 = (byte)12;
    private final byte _$192049 = (byte)13;
    private final byte _$192050 = (byte)14;
    private double _$192051;
    private int _$192052;
    private int _$192053;
    private byte _$188357;
    private BitCollection _$192055;
    private BaseFields _$1995;
    private BaseFields _$192056;
    private int[] _$192057;
    private Field _$192058;
    private int _$192059;
    private final int[] _$192060 = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private String _$192061;
    private double _$18751;
    private StringReader _$192062;

    FeatureStream(InputStream inbound, String source, Field shapeField, Field featureIdField, Fields queryFields, double scale) throws IOException {
        super(inbound);
        this._$192061 = source;
        this._$18751 = scale;
        int version = 30;
        int num_fields = 0;
        byte sentry1 = this.readByte();
        if (sentry1 != 5) {
            int limit = 200;
            byte[] buffer = new byte[limit];
            buffer[0] = sentry1;
            for (int i = 1; i < limit; ++i) {
                try {
                    buffer[i] = this.readByte();
                    continue;
                }
                catch (IOException ex) {
                    break;
                }
            }
            String i = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf((char)sentry1))).append("' \"").append(new String(buffer)).append("\"")));
        }
        int sentry2 = this.readUnsignedByte();
        switch (sentry2) {
            case 23: {
                this._$192062 = new StringReader30();
                break;
            }
            case 24: {
                version = 31;
                this._$192062 = new StringReader31();
                break;
            }
        }
        this._$188357 = this.readByte();
        if (this._$188357 == 2) {
            int stlen = this.readInt();
            byte[] errBytes = new byte[stlen];
            this.read(errBytes);
            String ex = new String(errBytes);
        }
        int gLength = this.readInt();
        this._$1995 = null;
        if (gLength > 1) {
            num_fields = this.readUnsignedByte();
            this._$1995 = new BaseFields(num_fields);
            int num_nulls = 0;
            if (num_fields > 0) {
                for (int i = 0; i < num_fields; ++i) {
                    short field_type = this.readShort();
                    int field_scale = this.readUnsignedByte();
                    int field_width = this.readUnsignedShort();
                    String name = this._$192062.readFieldName();
                    Field field = null;
                    if (name.equalsIgnoreCase(shapeField.getName())) {
                        field = shapeField;
                    } else {
                        field = new BaseField(name, (int)field_type, field_width, field_scale);
                        ++num_nulls;
                    }
                    this._$1995.addField(field);
                    if (field_type != 12) continue;
                    this._$192062.setMaximumValueLength(field_width);
                }
                this._$192055 = new BitCollection(this, num_nulls);
            }
            this._$192058 = shapeField;
            if (version == 30) {
                this._$1995.addField(shapeField);
            }
            this.createFeatureFields(queryFields);
            this._$192059 = this._$1995.findField(shapeField);
        }
        this._$192053 = 0;
        this._$192052 = 0;
    }

    public final void createFeatureFields(Fields queryFields) {
        this._$192056 = new BaseFields(queryFields.getNumFields());
        this._$192056.addFields(queryFields);
        int num = this._$1995.getNumFields();
        this._$192057 = new int[num];
        for (int i = 0; i < num; ++i) {
            Field field = this._$1995.getField(i);
            this._$192057[i] = this._$192056.findField(field);
        }
    }

    public void padBits() {
        int check = this._$192053 % 8;
        if (check != 0) {
            this._$192053 += 8 - check;
        }
        if (this._$192053 == 8) {
            this._$192053 = 0;
        }
    }

    public int readBits(int numBits) throws IOException {
        int end;
        int number = 0;
        for (int numread = 0; numread != numBits; numread += end - this._$192053) {
            if (this._$192053 == 0) {
                int b1 = 0;
                boolean b2 = false;
                boolean b3 = false;
                this._$192052 = b1 = this.read();
            }
            if ((end = numBits - numread + this._$192053) > 8) {
                end = 8;
            }
            number |= ((this._$192060[this._$192053] ^ this._$192060[end]) & this._$192052) >> this._$192053 << numread;
            this._$192053 = end;
            if (this._$192053 != 8) continue;
            this._$192053 = 0;
        }
        return number;
    }

    public double readBitDouble(int numBits) throws IOException {
        int lnum = this.readBits(numBits);
        double num = (lnum & 1 << numBits - 1) != 0 ? -((double)(lnum &= ~(1 << numBits - 1))) / this._$192051 : (double)lnum / this._$192051;
        return num;
    }

    public Row readRow() throws IOException {
        byte geom_cmd = 0;
        boolean bDone = false;
        this._$192103();
        block17: while (!bDone) {
            geom_cmd = this.readByte();
            switch (geom_cmd) {
                case -1: {
                    bDone = true;
                    continue block17;
                }
                case 4: {
                    continue block17;
                }
                case 11: {
                    continue block17;
                }
                case 12: {
                    continue block17;
                }
                case 13: {
                    continue block17;
                }
                case 14: {
                    continue block17;
                }
                case 5: {
                    continue block17;
                }
                case 6: {
                    continue block17;
                }
                case 7: {
                    continue block17;
                }
                case 8: {
                    this._$192051 = this.readDouble();
                    continue block17;
                }
                case 9: {
                    this._$192105();
                    continue block17;
                }
                case 10: {
                    return this.makeRow(null);
                }
                case 1: {
                    return this.makeRow((FeatureGeometry)this._$192107());
                }
                case 2: {
                    return this.makeRow((FeatureGeometry)this.readPolyline());
                }
                case 3: {
                    return this.makeRow((FeatureGeometry)this.readPolygon());
                }
            }
            bDone = true;
        }
        return null;
    }

    private final void _$192105() throws IOException {
        int count = this._$192055.getByteCount();
        for (int i = 0; i < count; ++i) {
            byte b = this.readByte();
            this._$192055.addByte(b);
        }
    }

    private final void _$192103() {
        this._$192055.clear();
    }

    public Row makeRow(FeatureGeometry geometry) throws IOException {
        int num = this._$1995.getNumFields();
        Object[] streamValues = new Object[num];
        int featureId = this._$192115(streamValues);
        if (geometry == null && this._$192059 >= 0) {
            return this.readRow();
        }
        if (this._$192059 >= 0) {
            streamValues[this._$192059] = geometry;
        }
        BaseFeature feature = new BaseFeature();
        feature.setDataID((DataID)new ScaleDataID(this._$192061, featureId, this._$18751));
        feature.setFields((Fields)this._$192056);
        for (int i = 0; i < num; ++i) {
            int index = this._$192057[i];
            if (index < 0) continue;
            feature.setValue(index, streamValues[i]);
        }
        return feature;
    }

    public Polygon readPolygon() throws IOException {
        int count = this.readInt();
        if (count <= 0) {
            throw new NegativeArraySizeException();
        }
        LinkedList<Ring> ll = new LinkedList<Ring>();
        for (int i = 0; i < count; ++i) {
            try {
                Ring ring = this.readRing();
                ll.add(ring);
                continue;
            }
            catch (IllegalArgumentException ring) {
                // empty catch block
            }
        }
        count = ll.size();
        if (count == 0) {
            return null;
        }
        Ring[] rings = new Ring[count];
        for (int i = 0; i < count; ++i) {
            rings[i] = (Ring)ll.get(i);
        }
        BasePolygon pol = new BasePolygon(rings);
        return pol;
    }

    public Polyline readPolyline() throws IOException {
        int count = this.readInt();
        if (count <= 0) {
            throw new NegativeArraySizeException();
        }
        LinkedList<Path> ll = new LinkedList<Path>();
        for (int i = 0; i < count; ++i) {
            try {
                Path path = this.readPath();
                ll.add(path);
                continue;
            }
            catch (IllegalArgumentException path) {
                // empty catch block
            }
        }
        count = ll.size();
        if (count == 0) {
            return null;
        }
        BasePolyline pol = new BasePolyline(count);
        for (int i = 0; i < count; ++i) {
            pol.setPath((Path)ll.get(i), i);
        }
        return pol;
    }

    public Ring readRing() throws IOException {
        int count = this.readInt();
        if (count <= 0) {
            throw new NegativeArraySizeException();
        }
        double[] x = new double[count + 1];
        double[] y = new double[count + 1];
        this.readPathPoints(x, y, count);
        x[count] = x[0];
        y[count] = y[0];
        return new BaseRing((PointCollection)new BasePointsArray(x, y));
    }

    public Path readPath() throws IOException {
        int count = this.readInt();
        if (count <= 0) {
            throw new NegativeArraySizeException();
        }
        double[] x = new double[count];
        double[] y = new double[count];
        this.readPathPoints(x, y, count);
        return new BasePath((PointCollection)new BasePointsArray(x, y));
    }

    public void readPathPoints(double[] x, double[] y, int num_points) throws IOException {
        int max_bits;
        int actual_bitsx = max_bits = this.readByte();
        int actual_bitsy = max_bits;
        double ptx_before = this.readDouble();
        double pty_before = this.readDouble();
        x[0] = ptx_before;
        y[0] = pty_before;
        if (max_bits > 32) {
            for (int iPoint = 1; iPoint < num_points; ++iPoint) {
                double dx = this.readDouble();
                double ptx_current = ptx_before + dx;
                double dy = this.readDouble();
                double pty_current = pty_before + dy;
                x[iPoint] = ptx_current;
                y[iPoint] = pty_current;
                pty_before = pty_current;
                ptx_before = ptx_current;
            }
        } else {
            for (int iPoint = 1; iPoint < num_points; ++iPoint) {
                if (iPoint % 16 == 1) {
                    int bit_adjustx = this.readBits(3);
                    int bit_adjusty = this.readBits(3);
                    actual_bitsx = max_bits - (byte)bit_adjustx;
                    actual_bitsy = max_bits - (byte)bit_adjusty;
                }
                double dx = this.readBitDouble(actual_bitsx);
                double ptx_current = ptx_before + dx;
                double dy = this.readBitDouble(actual_bitsy);
                double pty_current = pty_before + dy;
                x[iPoint] = ptx_current;
                y[iPoint] = pty_current;
                pty_before = pty_current;
                ptx_before = ptx_current;
            }
            this.padBits();
        }
    }

    private Point _$192135() throws IOException {
        Point p = new Point();
        p.x = this.readDouble();
        p.y = this.readDouble();
        return p;
    }

    private MultiPoint _$192107() throws IOException {
        int count = this.readInt();
        if (count == 1) {
            return this._$192135();
        }
        double[] x = new double[count];
        double[] y = new double[count];
        for (int i = 0; i < count; ++i) {
            x[i] = this.readDouble();
            y[i] = this.readDouble();
        }
        return new BaseMultiPoint((PointCollection)new BasePointsArray(x, y));
    }

    private int _$192115(Object[] objects) throws IOException {
        int featureId = 0;
        int numAttributes = objects.length;
        int iNull = 0;
        Object val = null;
        for (int i = 0; i < numAttributes; ++i) {
            Field fld = this._$1995.getField(i);
            if (fld.isShape()) continue;
            boolean addVal = true;
            switch (fld.getType()) {
                case 57: {
                    int length = this.readInt();
                    byte[] blob = new byte[length];
                    this.read(blob);
                    val = blob;
                    break;
                }
                case -7: {
                    byte bit = this.readByte();
                    val = new Boolean(bit != 0);
                    break;
                }
                case 4: {
                    int lng = this.readInt();
                    val = new Integer(lng);
                    break;
                }
                case 6: {
                    float flt = this.readFloat();
                    val = new Float(flt);
                    break;
                }
                case 8: {
                    double d = this.readDouble();
                    val = new Double(d);
                    break;
                }
                case 5: {
                    short s = this.readShort();
                    val = new Short(s);
                    break;
                }
                case 91: {
                    long l = this.readLong();
                    val = new Date(l);
                    break;
                }
                case 12: {
                    int length = fld.getDisplaySize();
                    val = this._$192062.readValue(length);
                }
            }
            if (!addVal) continue;
            if (this._$192155(iNull++)) {
                val = null;
            }
            objects[i] = val;
        }
        return featureId;
    }

    private final boolean _$192155(int n) {
        return this._$192055.size() > 0 && this._$192055.getBit(n);
    }

    static {
        _$192031 = false;
        _$192032 = false;
        _$192033 = false;
        _$192034 = false;
        _$192035 = false;
    }

    private final class StringReader30
    extends StringReader {
        private StringReader30() {
            super(FeatureStream.this);
        }

        String readFieldName() throws IOException {
            int field_name_length = FeatureStream.this.readUnsignedByte();
            this.setBufferLength(field_name_length);
            FeatureStream.this.read(this.buffer, 0, field_name_length);
            return new String(this.buffer, 0, field_name_length);
        }

        String readValue(int displayLength) throws IOException {
            this.setBufferLength(displayLength);
            byte b = 0;
            int length = -1;
            do {
                this.buffer[++length] = b = FeatureStream.this.readByte();
            } while (b != 0 && length < displayLength - 1);
            if (b != 0) {
                ++length;
            }
            return new String(this.buffer, 0, length);
        }
    }

    private final class StringReader31
    extends StringReader {
        private StringReader31() {
            super(FeatureStream.this);
        }

        String readFieldName() throws IOException {
            return this.readValue(0);
        }

        String readValue(int displayLength) throws IOException {
            byte b = FeatureStream.this.readByte();
            int length = 0;
            while (b != 0) {
                this.setMaximumValueLength(length);
                this.buffer[length] = b;
                b = FeatureStream.this.readByte();
                ++length;
            }
            return new String(this.buffer, 0, length, "UTF-8");
        }
    }

    private abstract class StringReader {
        byte[] buffer;

        private StringReader(FeatureStream this$0) {
        }

        final void setMaximumValueLength(int maxdatasize) {
            this.setBufferLength(maxdatasize * 3);
        }

        final void setBufferLength(int buffersize) {
            if (this.buffer == null) {
                this.buffer = this._$192169(buffersize);
            } else if (buffersize > this.buffer.length) {
                byte[] newbuf = this._$192169(buffersize);
                System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
                this.buffer = newbuf;
            }
        }

        private final byte[] _$192169(int size) {
            return new byte[size + 10];
        }

        abstract String readFieldName() throws IOException;

        abstract String readValue(int var1) throws IOException;
    }

    private final class BitCollection {
        private int _$192157;
        private int _$192158;
        private int _$192159;
        private byte[] _$192160;
        private BigInteger _$192163;

        BitCollection(FeatureStream this$0, int numBits) {
            int numBytes = (numBits - 1) / 8 + 1;
            this._$192160 = new byte[numBytes];
            this._$192158 = numBits;
            this._$192157 = 0;
            this._$192159 = numBytes * 8 - 1;
        }

        void addByte(byte b) {
            if (this._$192157 < this._$192160.length) {
                this._$192160[this._$192157] = b;
                ++this._$192157;
                if (this._$192157 == this._$192160.length) {
                    this._$192163 = new BigInteger(this._$192160);
                }
            }
        }

        int getByteCount() {
            return this._$192160.length;
        }

        int size() {
            return Math.min(this._$192157 * 8, this._$192158);
        }

        boolean getBit(int n) {
            return this._$192163.testBit(this._$192159 - n);
        }

        void clear() {
            this._$192157 = 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[BitCollection ");
            int count = this.size();
            sb.append(count);
            sb.append(":");
            for (int i = 0; i < count; ++i) {
                if (!this.getBit(i)) continue;
                sb.append(" ");
                sb.append(i);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

