/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client.service;

import com.esri.axl.mapping.ClassMappingEntryImpl;
import com.esri.axl.mapping.XmlMappingEntry;
import com.esri.axl.mapping.XmlMappingRegistry;
import com.esri.axl.mapping.XmlMappingRegistryImpl;
import com.esri.axl.marshal.XmlInputStream;
import com.esri.axl.marshal.XmlInputStreamImpl;
import com.esri.axl.marshal.XmlOutputStreamImpl;
import com.esri.mo.cs.geom.BaseMultiPoint;
import com.esri.mo.cs.geom.BasePointsArray;
import com.esri.mo.cs.geom.BasePolygon;
import com.esri.mo.cs.geom.BasePolyline;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.PointCollection;
import com.esri.mo.cs.geom.Ring;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.Fields;
import com.esri.ogc.client.gml.BoundedBy;
import com.esri.ogc.client.gml.FeatureMember;
import com.esri.ogc.client.gml.Features;
import com.esri.ogc.client.gml.LayerClass;
import com.esri.ogc.client.gml.MultiPolygon;
import com.esri.ogc.client.gml.PolygonMember;
import com.esri.ogc.client.gml.Shape;
import com.esri.ogc.client.ogcWfsSchema.BasicElement;
import com.esri.ogc.client.ogcWfsSchema.ComplexContent;
import com.esri.ogc.client.ogcWfsSchema.ComplexType;
import com.esri.ogc.client.ogcWfsSchema.Element;
import com.esri.ogc.client.ogcWfsSchema.Extension;
import com.esri.ogc.client.ogcWfsSchema.Import;
import com.esri.ogc.client.ogcWfsSchema.Schema;
import com.esri.ogc.client.ogcWfsSchema.Sequence;
import com.esri.ogc.client.service.InStreamToString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FeaToGML {
    private BaseFeature _$590;
    private Cursor _$592;
    private String _$593;
    private FileOutputStream _$595;
    private Fields _$597;
    private PointCollection _$599;
    private String _$600;
    private String _$601;

    public FeaToGML(BaseFeature bf, String name) {
        this._$590 = bf;
        this._$593 = name;
        this._$597 = this._$590.getFields();
    }

    public FeaToGML(Cursor cursor, String name) {
        this._$590 = (BaseFeature)cursor.next();
        this._$592 = cursor;
        this._$593 = name;
        this._$597 = this._$590.getFields();
    }

    public void writeSchemaToFile(String schema_file) throws IOException {
        try {
            this._$595 = new FileOutputStream(schema_file);
            Schema schema = this.createSchema();
            String _encoding = "UTF-8";
            String mapping = "ogc_ext_config/wfsSchemaMapping.xml";
            XmlMappingRegistryImpl registry = new XmlMappingRegistryImpl((InputStream)new FileInputStream(mapping), false);
            XmlOutputStreamImpl outputStream = new XmlOutputStreamImpl((OutputStream)this._$595, (XmlMappingRegistry)registry, _encoding);
            outputStream.setNamespaceURI("http://www.w3.org/2001/XMLSchema", "");
            outputStream.setNamespaceURI("http://www.opengis.net/gml", "gml");
            outputStream.setNamespaceURI("http://www.esri.com/WFS", "wfs");
            outputStream.marshal((Object)schema);
            outputStream.close();
            this._$595.close();
        }
        catch (Exception e) {
            System.out.println("**** Exception from writeSchema:".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
    }

    public void writeFeatureToFile(String gml_file) throws IOException {
        try {
            this._$595 = new FileOutputStream(gml_file);
            Features features = this.createFeatures();
            String _encoding = "UTF-8";
            String mapping = "ogc_ext_config/wfs_GML_mapping.xml";
            if (this._$590.getGeometry() instanceof BasePolygon) {
                mapping = "ogc_ext_config/wfs_GML_mapping_polygon.xml";
            } else if (this._$590.getGeometry() instanceof BaseMultiPoint || this._$590.getGeometry() instanceof Point) {
                mapping = "ogc_ext_config/wfs_GML_mapping_point.xml";
            }
            XmlMappingRegistryImpl registry = new XmlMappingRegistryImpl((InputStream)new FileInputStream(mapping), true);
            this._$593 = this._$593.trim().replace(' ', '_');
            String newClass1 = String.valueOf(String.valueOf(new StringBuffer("<class xmlns:mx=\"http://www.opengis.net/gml\" xmlns:my=\"http://www.esri.com/WFS\" name=\"com.esri.ogc.client.gml.LayerClass\" extends=\"com.esri.ogc.client.ogcWfsSchema.BasicElement\" element=\"my:").append(this._$593).append("\">").append("<sequence>")));
            for (int i = 0; i < this._$597.getNames().length; ++i) {
                String name = this._$597.getNames()[i];
                newClass1 = !(name = name.replace('#', '_')).equals("_SHAPE_") ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newClass1))).append("<element name=\"my:").append(name).append("\"><field name=\"fields\" class=\"java.lang.String\" content=\"true\" optional=\"true\" /></element>"))) : String.valueOf(String.valueOf(newClass1)).concat("<field name=\"shape\" class=\"com.esri.ogc.client.gml.Shape\" element=\"my:_SHAPE_\"/>");
            }
            newClass1 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(newClass1))).append("</sequence>").append("</class>")));
            ByteArrayInputStream stream = new ByteArrayInputStream(newClass1.getBytes("UTF-8"));
            XmlInputStreamImpl istream = new XmlInputStreamImpl((InputStream)stream, (XmlMappingRegistry)registry);
            ClassMappingEntryImpl entry = new ClassMappingEntryImpl("com.esri.ogc.client.gml.LayerClass", (XmlMappingRegistry)registry);
            entry.unMarshal((XmlInputStream)istream);
            registry.add((XmlMappingEntry)entry);
            XmlOutputStreamImpl outputStream = new XmlOutputStreamImpl((OutputStream)this._$595, (XmlMappingRegistry)registry, _encoding);
            outputStream.setNamespaceURI("http://www.opengis.net/gml", "gml");
            outputStream.setNamespaceURI("http://www.esri.com/WFS", "");
            outputStream.marshal((Object)features);
            outputStream.close();
            this._$595.close();
            this.addSrs(gml_file);
        }
        catch (Exception e) {
            System.out.println("**** Exception from writeSchema:".concat(String.valueOf(String.valueOf(e.getMessage()))));
        }
    }

    public Schema createSchema() {
        Schema schema = new Schema();
        Import import1 = new Import();
        Element element = null;
        ComplexType complexType = null;
        ComplexContent complexContent = null;
        Extension extension = null;
        import1.setSchemaLocation("feature.xsd");
        import1.setNamespace("http://www.opengis.net/gml");
        schema.setImport(import1);
        schema.setTargetNamespace("http://www.esri.com/WFS");
        schema.setDefault("qualified");
        BasicElement[] basicElement = new BasicElement[4];
        complexType = new ComplexType();
        complexContent = new ComplexContent();
        extension = new Extension();
        element = new Element();
        element.setName("Features");
        element.setType("wfs:featuresType");
        element.setSubstitutionGroup("gml:_FeatureCollection");
        basicElement[0] = element;
        complexType.setName("featuresType");
        extension.setBase("gml:AbstractFeatureCollectionType");
        complexContent.setExtension(extension);
        complexType.setComplexContent(complexContent);
        basicElement[1] = complexType;
        element = new Element();
        element.setName(this._$593);
        element.setType(String.valueOf(String.valueOf(new StringBuffer("wfs:").append(this._$593).append("Type"))));
        element.setSubstitutionGroup("gml:_FeatureCollection");
        basicElement[2] = element;
        complexType = new ComplexType();
        complexContent = new ComplexContent();
        extension = new Extension();
        complexType.setName(String.valueOf(String.valueOf(this._$593)).concat("Type"));
        extension.setBase("gml:AbstractFeatureType");
        Sequence sequence = new Sequence();
        Element[] eleArray = new Element[this._$597.getFields().length];
        for (int i = 0; i < this._$597.getFields().length; ++i) {
            element = new Element();
            String type = "";
            element.setName(this._$597.getField(i).getName().replace('#', '_'));
            if (this._$597.getField(i).isString()) {
                type = "string";
            } else if (this._$597.getField(i).isInteger() || this._$597.getField(i).isShort() || this._$597.getField(i).isByte()) {
                type = "integer";
            } else if (this._$597.getField(i).isDouble()) {
                type = "double";
            } else if (this._$597.getField(i).isBigDecimal()) {
                type = "double";
            } else if (this._$597.getField(i).isFloat()) {
                type = "float";
            } else if (this._$597.getField(i).isDate()) {
                type = "date";
            } else if (this._$597.getField(i).isLong()) {
                type = "double";
            } else if (this._$597.getField(i).isShape()) {
                type = this._$590.getGeometry() instanceof BasePolygon ? "gml:MultiPolygonPropertyType" : (this._$590.getGeometry() instanceof BasePolyline ? "gml:MultiLineStringPropertyType" : "gml:MultiPointPropertyType");
            }
            element.setType(type);
            eleArray[i] = element;
        }
        sequence.setElement(eleArray);
        extension.setSequence(sequence);
        complexContent.setExtension(extension);
        complexType.setComplexContent(complexContent);
        basicElement[3] = complexType;
        schema.setBasicElement(basicElement);
        return schema;
    }

    public Features createFeatures() {
        Features features = new Features();
        ArrayList<FeatureMember> feaArraylist = new ArrayList<FeatureMember>();
        FeatureMember feaMember = null;
        LayerClass layerClass = null;
        Shape shape = null;
        int count = 0;
        do {
            String gml = "";
            if (count != 0) {
                this._$590 = (BaseFeature)this._$592.next();
            }
            feaMember = new FeatureMember();
            layerClass = new LayerClass();
            shape = new Shape();
            if (this._$590.getGeometry() instanceof BasePolyline) {
                BasePolyline basePolyline = (BasePolyline)this._$590.getGeometry();
                shape.setMultilineString(basePolyline);
            } else if (this._$590.getGeometry() instanceof BasePolygon) {
                BasePolygon basePolygon = (BasePolygon)this._$590.getGeometry();
                Ring[] rings = basePolygon.getRings();
                MultiPolygon multiPoly = new MultiPolygon();
                PolygonMember[] polyMember = new PolygonMember[rings.length];
                for (int i = 0; i < rings.length; ++i) {
                    BasePolygon polygon = new BasePolygon(rings[i]);
                    PolygonMember pMember = new PolygonMember();
                    pMember.setPolygon(polygon);
                    polyMember[i] = pMember;
                }
                multiPoly.setPolygonMember(polyMember);
                shape.setMultiPolygon(multiPoly);
            } else {
                BaseMultiPoint mp = null;
                if (this._$590.getGeometry() instanceof BaseMultiPoint) {
                    mp = (BaseMultiPoint)this._$590.getGeometry();
                } else if (this._$590.getGeometry() instanceof Point) {
                    Point point = (Point)this._$590.getGeometry();
                    Point[] points = new Point[]{point};
                    BasePointsArray ba = new BasePointsArray(points);
                    mp = new BaseMultiPoint((PointCollection)ba);
                }
                shape.setMultiPoint(mp);
            }
            layerClass.setShape(shape);
            layerClass = this.setLayerFields(layerClass);
            feaMember.setBasicElement(layerClass);
            feaArraylist.add(feaMember);
            ++count;
        } while (this._$592.hasMore());
        FeatureMember[] feaArray = new FeatureMember[feaArraylist.size()];
        feaArray = feaArraylist.toArray(feaArray);
        features.setFeatureMember(feaArray);
        BoundedBy boundedBy = new BoundedBy();
        Envelope envelope = this._$590.getGeometry().getEnvelope();
        boundedBy.setBox(envelope);
        features.setBoundedBy(boundedBy);
        return features;
    }

    public String addPoints(String gml, PointCollection pc) {
        double[] xs = pc.getX();
        double[] ys = pc.getY();
        for (int i = 0; i < xs.length; ++i) {
            gml = String.valueOf(String.valueOf(gml)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(xs[i]))).append(",").append(ys[i]).append(" "))))));
        }
        return gml;
    }

    public LayerClass setLayerFields(LayerClass layerClass) {
        for (int i = 0; i < this._$590.getValues().length; ++i) {
            if (this._$590.getFields().getField(i).isShape()) continue;
            String value = String.valueOf(String.valueOf(new StringBuffer("").append(this._$590.getValue(i)).append("")));
            layerClass.setFields(value);
        }
        return layerClass;
    }

    public void addSrs(String gml_file) {
        try {
            File _gml_file = new File(gml_file);
            FileInputStream _in = new FileInputStream(_gml_file);
            InStreamToString inString = new InStreamToString(_in);
            String outString = inString.getOutString();
            StringBuffer replaceBuf = new StringBuffer(outString);
            int index = 0;
            while ((index = outString.indexOf("<gml:MultiPoint>", index)) > 0) {
                replaceBuf.replace(index, index + 16, "<gml:MultiPoint srsName=\"\">");
                index = 0;
                outString = replaceBuf.toString();
            }
            while ((index = outString.indexOf("<gml:MultiLineString>", index)) > 0) {
                replaceBuf.replace(index, index + 21, "<gml:MultiLineString srsName=\"\">");
                index = 0;
                outString = replaceBuf.toString();
            }
            while ((index = outString.indexOf("<gml:MultiPolygon>", index)) > 0) {
                replaceBuf.replace(index, index + 18, "<gml:MultiPolygon srsName=\"\">");
                index = 0;
                outString = replaceBuf.toString();
            }
            byte[] bytes = replaceBuf.toString().getBytes();
            FileOutputStream out = new FileOutputStream(_gml_file);
            out.write(bytes);
            out.close();
            ((InputStream)_in).close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

