/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client;

import com.esri.cc.comp.OGCPlugin;
import com.esri.mo.cs.geom.BasePolygon;
import com.esri.mo.cs.geom.BasePolyline;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.data.feat.BaseDataID;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.BaseMemoryFeatureClass;
import com.esri.mo.data.feat.BaseSpatialFilter;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.DataID;
import com.esri.mo.data.feat.Feature;
import com.esri.mo.data.feat.FeatureClass;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.data.feat.QueryFilter;
import com.esri.mo.map.dpy.FeatureLayer;
import com.esri.mo.map.dpy.GroupLayer;
import com.esri.mo.map.dpy.Layer;
import com.esri.mo.map.dpy.LayerInfo;
import com.esri.mo.map.draw.BaseSimpleRenderer;
import com.esri.mo.map.draw.ColorScheme;
import com.esri.mo.map.draw.Renderer;
import com.esri.mo.map.draw.SampleColorSchemes;
import com.esri.mo.map.img.BaseImageServerLayer;
import com.esri.mo.ui.bean.Legend;
import com.esri.mo.ui.bean.Map;
import com.esri.mo.ui.bean.Toc;
import com.esri.mo.ui.bean.TocAdapter;
import com.esri.mo.ui.bean.TocEvent;
import com.esri.mo.ui.bean.TocListener;
import com.esri.ogc.client.ConnException;
import com.esri.ogc.client.HelpLayer;
import com.esri.ogc.client.WFSServer;
import com.esri.ogc.client.WMSServer;
import com.esri.ogc.client.service.FeaToGML;
import com.esri.ogc.client.service.LocalGml;
import com.esri.ogc.viewer.OGCAction;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class WMSUtil
implements OGCPlugin {
    private Map _$20858;
    private TocMouseAdapter _$20897 = new TocMouseAdapter();
    OGCAction action;
    Toc _toc;
    Legend _legend;

    public static String generateCapabillityQueryString(String strServerURL, String strVendorSpecificParameter, String strVersion) {
        String strCapabilityQS = "";
        String strVendorSpecificParameterQS = "";
        String strVersionQS = "";
        String strExceptionQS = "";
        String strServiceQS = "";
        String strRequestQS = "";
        if (strVendorSpecificParameter != null && strVendorSpecificParameter.length() > 0) {
            strVendorSpecificParameterQS = String.valueOf(String.valueOf(strVendorSpecificParameter)).concat("&");
        }
        if (strVersion != null && strVersion.length() > 0) {
            if (strVersion.compareTo("1.0.0") == 0 || strVersion.compareTo("1.0.1") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("WMTVER=").append(strVersion).append("&")));
                strRequestQS = "REQUEST=capabilities";
            } else if (strVersion.compareTo("1.0.5") == 0 || strVersion.compareTo("1.0.6") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&")));
                strServiceQS = "SERVICE=WMS&";
                strRequestQS = "REQUEST=capabilities";
            } else if (strVersion.compareTo("1.1.0") == 0 || strVersion.compareTo("1.1.1") == 0 || strVersion.compareTo("1.1.12") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&").append("WMTVER=").append(strVersion).append("&")));
                strServiceQS = "SERVICE=WMS&";
                strRequestQS = "REQUEST=capabilities";
            } else {
                strRequestQS = "REQUEST=GetCapabilities";
            }
        } else {
            strRequestQS = "REQUEST=GetCapabilities";
        }
        strCapabilityQS = strServerURL.indexOf("?") > 0 ? (strServerURL.indexOf("?") == strServerURL.length() - 1 ? String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strServerURL))).append(strVendorSpecificParameterQS).append(strVersionQS).append(strExceptionQS).append(strServiceQS).append(strRequestQS))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strServerURL))).append("&").append(strVendorSpecificParameterQS).append(strVersionQS).append(strExceptionQS).append(strServiceQS).append(strRequestQS)))) : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strServerURL))).append("?").append(strVendorSpecificParameterQS).append(strVersionQS).append(strExceptionQS).append(strServiceQS).append(strRequestQS)));
        System.out.println("GetCapabilities Request : ".concat(String.valueOf(String.valueOf(strCapabilityQS))));
        return strCapabilityQS;
    }

    public static String generateMapQueryString(String strServerUrl, String strVendorSpecificParameter, double xmin, double ymin, double xmax, double ymax, String strLayers, String strStyles, String strSrs, String strWidth, String strHeight, String strFormat, String strTransparent, String strBgcolor, String strExceptions, String strSld, String strVersion) {
        if (strVersion == null || strVersion.length() == 0) {
            strVersion = "1.1.1";
        }
        String strVersionQS = "";
        String strExceptionsQS = "";
        String strServiceQS = "";
        String strRequestQS = "";
        String strMapQS = "";
        String strVendorSpecificParameterQS = "";
        if (strVendorSpecificParameter != null && strVendorSpecificParameter.length() > 0) {
            strVendorSpecificParameterQS = String.valueOf(String.valueOf(strVendorSpecificParameter)).concat("&");
        }
        if (strVersion != null && strVersion.length() > 0) {
            if (strVersion.compareTo("1.0.0") == 0 || strVersion.compareTo("1.0.1") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("WMTVER=").append(strVersion).append("&")));
                strExceptionsQS = strExceptions == null || strExceptions.length() == 0 ? "EXCEPTIONS=SE_XML&" : String.valueOf(String.valueOf(new StringBuffer("EXCEPTIONS=").append(strExceptions).append("&")));
                strRequestQS = "REQUEST=Map";
            } else if (strVersion.compareTo("1.0.5") == 0 || strVersion.compareTo("1.0.6") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&")));
                strExceptionsQS = strExceptions == null || strExceptions.length() == 0 ? "EXCEPTIONS=SE_XML&" : String.valueOf(String.valueOf(new StringBuffer("EXCEPTIONS=").append(strExceptions).append("&")));
                strRequestQS = "REQUEST=GetMap";
            } else if (strVersion.compareTo("1.1.0") == 0 || strVersion.compareTo("1.1.1") == 0 || strVersion.compareTo("1.1.12") == 0) {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&")));
                strExceptionsQS = strExceptions == null || strExceptions.length() == 0 ? "EXCEPTIONS=application/vnd.ogc.se_xml&" : String.valueOf(String.valueOf(new StringBuffer("EXCEPTIONS=").append(strExceptions).append("&")));
                strRequestQS = "REQUEST=GetMap";
            } else {
                strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&")));
                strExceptionsQS = "EXCEPTIONS=application/vnd.ogc.se_xml&";
                strRequestQS = "REQUEST=GetMap";
            }
        } else {
            strVersionQS = String.valueOf(String.valueOf(new StringBuffer("VERSION=").append(strVersion).append("&")));
            strExceptionsQS = "EXCEPTIONS=application/vnd.ogc.se_xml&";
            strRequestQS = "REQUEST=GetMap";
        }
        String strLayersQS = String.valueOf(String.valueOf(new StringBuffer("LAYERS=").append(strLayers).append("&")));
        String strSrsQS = String.valueOf(String.valueOf(new StringBuffer("SRS=").append(strSrs).append("&")));
        String strStylesQS = String.valueOf(String.valueOf(new StringBuffer("STYLES=").append(strStyles).append("&")));
        String strBbox = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(xmin)))).append(",").append(String.valueOf(ymin)).append(",").append(String.valueOf(xmax)).append(",").append(String.valueOf(ymax))));
        String strBboxQS = String.valueOf(String.valueOf(new StringBuffer("BBOX=").append(strBbox).append("&")));
        String strWidthQS = String.valueOf(String.valueOf(new StringBuffer("WIDTH=").append(strWidth).append("&")));
        String strHeightQS = String.valueOf(String.valueOf(new StringBuffer("HEIGHT=").append(strHeight).append("&")));
        String strFormatQS = String.valueOf(String.valueOf(new StringBuffer("FORMAT=").append(strFormat).append("&")));
        String strTransparentQS = String.valueOf(String.valueOf(new StringBuffer("TRANSPARENT=").append(strTransparent).append("&")));
        String strBgcolorQS = String.valueOf(String.valueOf(new StringBuffer("BGCOLOR=").append(strBgcolor).append("&")));
        String strSldQS = "";
        if (strSld != null && strSld.length() > 0) {
            strSldQS = String.valueOf(String.valueOf(new StringBuffer("SLD=").append(strSld).append("&")));
            strSldQS = String.valueOf(String.valueOf(strSldQS)).concat("SLDVersion=0.7.1&");
        }
        strMapQS = strServerUrl.indexOf("?") > 0 ? (strServerUrl.indexOf("?") == strServerUrl.length() - 1 || strServerUrl.indexOf("&") == strServerUrl.length() - 1 ? strServerUrl : String.valueOf(String.valueOf(strServerUrl)).concat("&")) : String.valueOf(String.valueOf(strServerUrl)).concat("?");
        strMapQS = String.valueOf(String.valueOf(strMapQS)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strVendorSpecificParameterQS))).append(strVersionQS).append(strLayersQS).append(strSrsQS).append(strStylesQS).append(strBboxQS).append(strWidthQS).append(strHeightQS).append(strFormatQS).append(strTransparentQS).append(strBgcolorQS).append(strSldQS).append(strRequestQS))))));
        return strMapQS;
    }

    public WMSUtil() {
        this(null);
    }

    public WMSUtil(Map map) {
        this._$20858 = map;
        this.action = new OGCAction(this);
    }

    public WFSServer connectWFS(String strServerURL, String strServiceName, String strVersion) throws NullPointerException, IOException {
        WFSServer wfsserver = null;
        wfsserver = WFSServer.getLayerSource(strServerURL, strServiceName, strVersion);
        return wfsserver;
    }

    public boolean AddWFSLayer(WFSServer wfsserver, String strFeatureType) {
        if (wfsserver != null) {
            LayerInfo[] layerinfo = wfsserver.getLayerInfo();
            LayerInfo linfo = null;
            for (int i = 0; i < layerinfo.length && (linfo = layerinfo[i]).getDataset().getName().compareToIgnoreCase(strFeatureType) != 0; ++i) {
            }
            if (linfo == null) {
                return false;
            }
            Layer wfslayer = wfsserver.getLayer(linfo);
            if (wfslayer == null) {
                return false;
            }
            wfslayer.setVisible(true);
            this._$20858.getLayerset().addLayer(wfslayer);
            this._$20858.redraw();
            return true;
        }
        return false;
    }

    public boolean AddWMSLayer(String strUrl, String servicename, String version) throws ConnException, IOException {
        WMSServer wmsserver = null;
        if (this._$20858 != null) {
            try {
                wmsserver = WMSServer.getLayerSource(strUrl, servicename, version);
                wmsserver.getVersion();
            }
            catch (ConnException ce) {
                throw ce;
            }
            catch (Exception e) {
                System.out.println("******** Exception for WMS:".concat(String.valueOf(String.valueOf(e.getMessage()))));
                e.printStackTrace();
            }
            Layer[] l = wmsserver.getLayers();
            BaseImageServerLayer layer = (BaseImageServerLayer)l[0];
            this._$20858.setExtent(l[0].getLayerSource().getPreferredExtent());
            this._$20858.getLayerset().addLayer((Layer)layer);
            return true;
        }
        return false;
    }

    public static String generateCapabillityPostMessage(String strVendorSpecificParameter, String strVersion, String strOptionalSection) {
        String capVersion = "1.2.0";
        String service = "WMS";
        StringBuffer sbCapabilityPMXML = new StringBuffer("");
        sbCapabilityPMXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sbCapabilityPMXML.append("<ogc:GetCapabilities xmlns:ogc=\"http://www.opengis.net/ows\"");
        if (strVersion != null && strVersion.length() > 0) {
            capVersion = strVersion;
        }
        sbCapabilityPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" version=\"").append(capVersion).append("\""))));
        if (strVendorSpecificParameter != null && strVendorSpecificParameter.length() > 0) {
            sbCapabilityPMXML.append(strVendorSpecificParameter);
        }
        if (strOptionalSection != null && strOptionalSection.length() > 0) {
            sbCapabilityPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" >\n<Section>/OGC_Capabilities/").append(strOptionalSection).append("</Section>\n</ogc:GetCapabilities>\n"))));
        } else {
            sbCapabilityPMXML.append(" />\n");
        }
        return sbCapabilityPMXML.toString();
    }

    public static String generateMapPostMessage(String strVendorSpecificParameter, String strVersion, double xmin, double ymin, double xmax, double ymax, String strLayers, String strStyles, String strSrs, int iWidth, int iHeight, String strFormat, String strTransparent, String strExceptions, String strSLDVersion) {
        String mapVersion = "1.2.0";
        String service = "WMS";
        String sldVersion = "0.7.2";
        String srsName = "http://www.opengis.net/gml/srs/epsg.xml#4326";
        String exceptionsName = "application/vnd.ogc.se+xml";
        String formatName = "image/jpeg";
        String transparent = "false";
        int width = 500;
        int height = 400;
        StringBuffer sbMapPMXML = new StringBuffer("");
        sbMapPMXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        sbMapPMXML.append("<ogc:GetMap xmlns:ogc=\"http://www.opengis.net/ows\"");
        sbMapPMXML.append(" xmlns:gml=\"http://www.opengis.net/gml\"");
        sbMapPMXML.append(" env:encodingStyle=\"http://www.w3.org/2001/09/soap-encoding\"");
        if (strVersion != null && strVersion.length() > 0) {
            mapVersion = strVersion;
        }
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" version=\"").append(mapVersion).append("\""))));
        if (strVendorSpecificParameter != null && strVendorSpecificParameter.length() > 0) {
            sbMapPMXML.append(strVendorSpecificParameter);
        }
        if (strSLDVersion != null && strSLDVersion.length() > 0) {
            sldVersion = strSLDVersion;
            if (sldVersion.equals("0.7.0")) {
                sbMapPMXML.append("  <StyledLayerDescriptor >\n");
            } else {
                sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("  <StyledLayerDescriptor version=\"").append(sldVersion).append("\" >\n"))));
            }
        } else {
            sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("  <StyledLayerDescriptor version=\"").append(sldVersion).append("\" >\n"))));
        }
        if (strLayers != null && strLayers.length() > 0 && strStyles != null && strStyles.length() > 0) {
            StringTokenizer layers = new StringTokenizer(strLayers, ",");
            StringTokenizer styles = new StringTokenizer(strStyles, ",");
            if (sldVersion.equals("0.7.0") || sldVersion.equals("0.7.1")) {
                while (layers.hasMoreTokens() && styles.hasMoreTokens()) {
                    sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" <NamedLayer name=\"").append(layers.nextToken()).append("\" >\n"))));
                    sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("  <NamedStyle name=\"").append(styles.nextToken()).append("\" />\n"))));
                    sbMapPMXML.append("  </NamedLayer>\n");
                }
            } else {
                while (layers.hasMoreTokens() && styles.hasMoreTokens()) {
                    sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" <NamedLayer> <Name>").append(layers.nextToken()).append("</Name>\n"))));
                    sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("  <NamedStyle> <Name>").append(styles.nextToken()).append("</Name></NamedStyle>\n"))));
                    sbMapPMXML.append("  </NamedLayer>\n");
                }
            }
        }
        sbMapPMXML.append("  </StyledLayerDescriptor>\n");
        if (strSrs != null && strSrs.length() > 0) {
            srsName = strSrs;
        }
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<BoundingBox srsName=\"").append(srsName).append("\">\n"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<gml:coord><gml:X>").append(String.valueOf(xmin)).append("</gml:X>"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<gml:Y>").append(String.valueOf(ymin)).append("</gml:Y></gml:coord>\n"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<gml:coord><gml:X>").append(String.valueOf(xmax)).append("</gml:X>"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<gml:Y>").append(String.valueOf(ymax)).append("</gml:Y></gml:coord>\n"))));
        sbMapPMXML.append("</BoundingBox>\n");
        if (iWidth > 0) {
            width = iWidth;
        }
        if (iHeight > 0) {
            height = iHeight;
        }
        if (strFormat != null && strFormat.length() > 0) {
            formatName = strFormat;
        }
        if (strTransparent != null && strTransparent.length() > 0) {
            transparent = strTransparent;
        }
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<Output>\n<Format>").append(formatName).append("</Format>\n"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" <Transparent>").append(transparent).append("</Transparent>\n"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" <Size>\n<Width>").append(String.valueOf(width)).append("</Width>\n"))));
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer(" <Height>").append(String.valueOf(width)).append("</Height></Size>\n"))));
        sbMapPMXML.append("</Output>\n");
        if (strExceptions != null && strExceptions.length() > 0) {
            exceptionsName = strExceptions;
        }
        sbMapPMXML.append(String.valueOf(String.valueOf(new StringBuffer("<Exceptions>").append(exceptionsName).append("</Exceptions>\n"))));
        sbMapPMXML.append("</ogc:GetMap>\n");
        return sbMapPMXML.toString();
    }

    public static void main(String[] argv) {
    }

    public static Layer getWMSLayer(String strUrl, String strVSP, String version) {
        Object url = null;
        WMSServer wmsserver = null;
        try {
            wmsserver = WMSServer.getLayerSource(strUrl, strVSP, version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Layer[] l = wmsserver.getLayers();
        BaseImageServerLayer layer = (BaseImageServerLayer)l[0];
        return layer;
    }

    public void saveFeaAsGML(Legend legend, String schema_file, String gml_file) throws Exception {
        Object feature = null;
        FeaToGML gml = null;
        System.err.println("Legend:".concat(String.valueOf(String.valueOf(this._legend))));
        legend = this._legend;
        if (legend == null) {
            List legendList = this._toc.getSelectedLegends();
            if (legendList != null && legendList.size() != 0) {
                legend = (Legend)legendList.get(0);
            } else {
                return;
            }
        }
        FeatureLayer fLayer = null;
        System.out.println("********** name = ".concat(String.valueOf(String.valueOf(legend.getLayer().getName()))));
        if (legend.getLayer().getParent().getName().equalsIgnoreCase("map")) {
            fLayer = (FeatureLayer)this._$20858.getLayer(legend.getLayer().getName());
        } else {
            GroupLayer gLayer = (GroupLayer)this._$20858.getLayer(legend.getLayer().getParent().getName());
            int id = gLayer.findLayer(legend.getLayer().getName());
            fLayer = (FeatureLayer)gLayer.layerAt(id);
            System.out.println(fLayer.getName());
        }
        BaseSpatialFilter qFilter = new BaseSpatialFilter();
        Envelope fg = new Envelope(-200.0, -100.0, 500.0, 200.0);
        qFilter.setGeometry((FeatureGeometry)fg);
        qFilter.setSubFields(fLayer.getFeatureClass().getFields());
        Cursor c = fLayer.search((QueryFilter)qFilter);
        gml = new FeaToGML(c, legend.getLayer().getName());
        gml.writeSchemaToFile(schema_file);
        gml.writeFeatureToFile(gml_file);
    }

    public void displayGML(String schema_file, String gml_file) throws IOException {
        BaseSimpleRenderer renderer;
        BaseMemoryFeatureClass feaClass;
        int fid = 0;
        LocalGml localGml = new LocalGml(schema_file, gml_file);
        Vector feaVector = localGml.getWFSFeature();
        BaseFields fields = localGml.getFields();
        String name = localGml.getName();
        BaseFeature feature = (BaseFeature)feaVector.get(0);
        if (feature.getGeometry() instanceof BasePolyline) {
            feaClass = new BaseMemoryFeatureClass(1, (Fields)fields);
            renderer = BaseSimpleRenderer.constructDefaultRenderer((ColorScheme)new SampleColorSchemes(), (int)1);
        } else if (feature.getGeometry() instanceof BasePolygon) {
            feaClass = new BaseMemoryFeatureClass(2, (Fields)fields);
            renderer = BaseSimpleRenderer.constructDefaultRenderer((ColorScheme)new SampleColorSchemes(), (int)2);
        } else {
            feaClass = new BaseMemoryFeatureClass(0, (Fields)fields);
            renderer = BaseSimpleRenderer.constructDefaultRenderer((ColorScheme)new SampleColorSchemes(), (int)0);
        }
        feaClass.setName(name);
        for (int i = 0; i < feaVector.size(); ++i) {
            feature = (BaseFeature)feaVector.get(i);
            BaseDataID id = new BaseDataID(feaClass.getName(), fid);
            feature.setDataID((DataID)id);
            feaClass.addFeature((Feature)feature);
            ++fid;
        }
        HelpLayer layer = new HelpLayer();
        layer.setVisible(true);
        layer.setFeatureClass((FeatureClass)feaClass);
        layer.setRenderer((Renderer)renderer);
        this._$20858.getLayerset().addLayer((Layer)layer);
        this._$20858.redraw();
    }

    public void setMap(Map map) {
        this._$20858 = map;
        System.out.println("Map:".concat(String.valueOf(String.valueOf(this._$20858.toString()))));
    }

    public Map getMap() {
        return this._$20858;
    }

    public void setToc(Toc toc) {
        this._toc = toc;
        this._toc.addTocListener((TocListener)this._$20897);
    }

    public Toc getToc() {
        return this._toc;
    }

    public Object[] getOGCMenuActions() {
        return this.action.getOGCActions();
    }

    public OGCPlugin getOGCPlugin() {
        return this;
    }

    final class TocMouseAdapter
    extends TocAdapter {
        TocMouseAdapter() {
        }

        public void click(TocEvent te) {
            WMSUtil.this._legend = te.getLegend();
        }
    }
}

