/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client;

import com.esri.mo.axl.map.WorkspaceElement;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.data.feat.MapDataset;
import com.esri.mo.map.dpy.BaseLayerSource;
import com.esri.mo.map.dpy.LayerInfo;
import com.esri.mo.map.dpy.LayerSource;
import com.esri.mo.map.img.BaseImageLayerSource;
import com.esri.mo.map.img.BaseImageServerLayer;
import com.esri.mo.map.img.ImageLayer;
import com.esri.mo.map.img.ServerImage;
import com.esri.mo.map.img.SubLayerSnapshot;
import com.esri.mo.map.img.Tile;
import com.esri.ogc.client.ConnException;
import com.esri.ogc.client.WMSCapability;
import com.esri.ogc.client.WMSLayer;
import com.esri.ogc.client.WMSLayerInfoImpl;
import com.esri.ogc.client.WMSUtil;
import com.esri.ogc.client.ogcWmsXml.BoundingBox;
import com.esri.ogc.client.service.GetWMSService;
import com.esri.ogc.client.service.OgcHttpConnection;
import com.esri.ogc.client.wmsXml.LayerList;
import com.esri.ogc.client.wmsXml.Wms_Capabilities;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Vector;

public class WMSServer
extends BaseImageLayerSource {
    private String _$19725;
    private String _$19726;
    private String _$19727;
    private String _$19728;
    private String _$19729;
    private String _$2882;
    private String _$3518;
    static /* synthetic */ Class class$com$esri$ogc$client$WMSServer;

    public static WMSServer getLayerSource(String strServerURL, String strServiceName, String strVersion) throws ConnException, IOException {
        String connection = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf((class$com$esri$ogc$client$WMSServer == null ? (class$com$esri$ogc$client$WMSServer = WMSServer.class$("com.esri.ogc.client.WMSServer")) : class$com$esri$ogc$client$WMSServer).getName()))).append(":").append(strServerURL).append(":").append(strServiceName).append(":").append(strVersion)));
        WMSServer wmsserver = null;
        wmsserver = (WMSServer)BaseLayerSource.findLayerSource((Object)connection);
        if (wmsserver == null) {
            wmsserver = new WMSServer(strServerURL, strServiceName, strVersion, 5);
            wmsserver.setConnection(connection);
            BaseLayerSource.insertLayerSource((BaseLayerSource)wmsserver);
        }
        return wmsserver;
    }

    private WMSServer(String strServerURL, String strVSP, String strVersion, int nCacheLimit) throws ConnException, IOException {
        super(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(strServerURL))).append(":").append(strVSP).append(":").append(strVersion))), nCacheLimit);
        this._$19725 = strServerURL;
        if (strVSP != null && strVSP.length() > 0) {
            this._$19726 = strVSP;
        }
        this._$19727 = strVersion;
        if (this._$19727 == null || this._$19727.length() == 0) {
            this._$19727 = "1.1.1";
        }
        this.pingServer();
        this.refresh();
    }

    public void pingServer() throws ConnException {
        String strURL = WMSUtil.generateCapabillityQueryString(this._$19725, this._$19726, this._$19727);
        try {
            URL l_url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)l_url.openConnection();
            connection.connect();
        }
        catch (Exception e) {
            throw new ConnException();
        }
    }

    public synchronized URL getImageURL(Tile tile) throws IOException {
        ServerImage image = tile.getProposedImage();
        Envelope extent = image.getEnvelope();
        String strWidth = String.valueOf(image.getSize().getWidth());
        String strHeight = String.valueOf(image.getSize().getHeight());
        SubLayerSnapshot sls = image.getSnapshot();
        String strLayerList = "";
        for (int i = 0; i < sls.size(); ++i) {
            WMSLayerInfoImpl layerinfo = (WMSLayerInfoImpl)sls.getLayerInfo(i);
            MapDataset dataset = layerinfo.getDataset();
            if (!sls.isVisible(i)) continue;
            strLayerList = strLayerList.length() > 0 ? String.valueOf(String.valueOf(strLayerList)).concat(String.valueOf(String.valueOf(",".concat(String.valueOf(String.valueOf(layerinfo.getLayerID())))))) : String.valueOf(String.valueOf(strLayerList)).concat(String.valueOf(String.valueOf(layerinfo.getLayerID())));
        }
        strLayerList = URLEncoder.encode(strLayerList);
        String strURL = WMSUtil.generateMapQueryString(this._$3518, this._$19726, extent.getMinX(), extent.getMinY(), extent.getMaxX(), extent.getMaxY(), strLayerList, "", this._$19729, strWidth, strHeight, this._$2882, "TRUE", "0xFFFFFF", "xml", "", this._$19727);
        System.err.println("URL : ".concat(String.valueOf(String.valueOf(strURL))));
        URL urlResult = new URL(strURL);
        return urlResult;
    }

    public WorkspaceElement toAXL(XmlDocument xmldoc) throws IOException {
        return null;
    }

    protected BaseImageServerLayer createGroupLayer() {
        BaseImageServerLayer group = super.createGroupLayer();
        group.setCanChange(true);
        return group;
    }

    protected ImageLayer createImageLayer(LayerInfo linfo) {
        ImageLayer ilayer = super.createImageLayer(linfo);
        return ilayer;
    }

    public synchronized int getFlattenLayer(LayerList[] layers, ArrayList al) {
        int result = 0;
        if (layers == null) {
            return 0;
        }
        if (layers.length == 0) {
            return 0;
        }
        for (int i = 0; i < layers.length; ++i) {
            LayerList lyr = layers[i];
            if (lyr.getName() != null && lyr.getName().length() >= 0) {
                al.add(lyr);
                ++result;
            }
            result += this.getFlattenLayer(lyr.getLayer(), al);
        }
        return result;
    }

    public synchronized void refresh() throws NullPointerException, IOException {
        block15: {
            LayerList lyr;
            Envelope extent = null;
            String strURL = WMSUtil.generateCapabillityQueryString(this._$19725, this._$19726, this._$19727);
            this.clearLayerInfo();
            OgcHttpConnection connection = new OgcHttpConnection(strURL, "");
            connection.createConnection();
            GetWMSService wmsService = new GetWMSService(connection);
            this._$19727 = wmsService.getRealVersion();
            Wms_Capabilities wmsCap = (Wms_Capabilities)wmsService.getCapabilities(this._$19727);
            this._$19727 = wmsCap.getVersion();
            LayerList wll = wmsCap.getCapability().getLayer();
            LayerList[] layers = wll.getLayer();
            Vector srsVec = wmsCap.getCapability().getLayer().getSRS();
            for (int i = 0; i < srsVec.size(); ++i) {
                this._$19729 = (String)srsVec.get(i);
                if (this._$19729.equalsIgnoreCase("EPSG:4326")) break;
            }
            Vector formatVec = wmsCap.getCapability().getRequest().getMap().getFormat110();
            for (int j = 0; j < formatVec.size(); ++j) {
                this._$2882 = (String)formatVec.get(j);
                if (this._$2882.equalsIgnoreCase("image/png") || this._$2882.equalsIgnoreCase("image/jpeg") || this._$2882.equalsIgnoreCase("image/gif")) break;
            }
            this._$3518 = this._$19727.equals("1.1.1") ? wmsCap.getCapability().getRequest().getMap().getDcpType().getHTTP().getGet().getOnlineResource().getHref() : wmsCap.getCapability().getRequest().getMap().getDcpType().getHTTP().getGet().getOnlineResource100();
            this._$3518 = this._$3518.trim();
            System.err.println("&&&&&&&& url = ".concat(String.valueOf(String.valueOf(this._$3518))));
            if (!this._$3518.endsWith("?")) {
                this._$3518 = String.valueOf(String.valueOf(this._$3518)).concat("?");
            }
            double xmin = Double.MAX_VALUE;
            double ymin = Double.MAX_VALUE;
            double xmax = Double.MIN_VALUE;
            double ymax = Double.MIN_VALUE;
            if (this._$19729.equals("EPSG:4326")) {
                if (wll.getLatLonBoundingBox() != null) {
                    xmin = wll.getLatLonBoundingBox().getMinx();
                    ymin = wll.getLatLonBoundingBox().getMiny();
                    xmax = wll.getLatLonBoundingBox().getMaxx();
                    ymax = wll.getLatLonBoundingBox().getMaxy();
                }
            } else if (wll.getBoundingBox() != null) {
                BoundingBox[] boundingBoxArray = wll.getBoundingBox();
                for (int i = 0; i < boundingBoxArray.length; ++i) {
                    BoundingBox boundingBox = boundingBoxArray[i];
                    xmin = boundingBox.getMinx();
                    ymin = boundingBox.getMiny();
                    xmax = boundingBox.getMaxx();
                    ymax = boundingBox.getMaxy();
                }
            }
            ArrayList alFlatLayers = new ArrayList();
            int noOfNamedLayer = this.getFlattenLayer(layers, alFlatLayers);
            for (int i = 0; i < alFlatLayers.size() && (lyr = (LayerList)alFlatLayers.get(i)).getName() != null && lyr.getName().length() > 0; ++i) {
                if (lyr.getLatLonBoundingBox() != null) {
                    xmin = Math.min(lyr.getLatLonBoundingBox().getMinx(), xmin);
                    if (xmin < (double)-180) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("xmin = ").append(xmin).append("layer = ").append(lyr.getName()))));
                    }
                    if ((ymin = Math.min(lyr.getLatLonBoundingBox().getMiny(), ymin)) < (double)-90) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ymin = ").append(ymin).append("layer = ").append(lyr.getName()))));
                    }
                    if ((xmax = Math.max(lyr.getLatLonBoundingBox().getMaxx(), xmax)) > (double)180) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("xmax = ").append(xmax).append("layer = ").append(lyr.getName()))));
                    }
                    if ((ymax = Math.max(lyr.getLatLonBoundingBox().getMaxy(), ymax)) > (double)90) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("ymax = ").append(ymax).append("layer = ").append(lyr.getName()))));
                    }
                    extent = new Envelope(lyr.getLatLonBoundingBox().getMinx(), lyr.getLatLonBoundingBox().getMiny(), lyr.getLatLonBoundingBox().getMaxx() - lyr.getLatLonBoundingBox().getMinx(), lyr.getLatLonBoundingBox().getMaxy() - lyr.getLatLonBoundingBox().getMiny());
                } else {
                    extent = new Envelope(xmin, ymin, xmax - xmin, ymax - ymin);
                }
                WMSLayerInfoImpl layerinfo = new WMSLayerInfoImpl(lyr.getName(), lyr.getTitle(), (LayerSource)this, extent);
                layerinfo.setMapUnit(0);
                this.addLayerInfo((LayerInfo)layerinfo);
            }
            Envelope totalExtent = null;
            if (layers.length <= 0) break block15;
            totalExtent = new Envelope(xmin, ymin, xmax - xmin, ymax - ymin);
            this.applyDefaultExtent(totalExtent);
        }
    }

    private synchronized void _$19798() throws IOException {
        String strURL = WMSUtil.generateCapabillityQueryString(this._$19725, this._$19726, this._$19727);
        this.clearLayerInfo();
        WMSCapability wmscap = new WMSCapability();
        wmscap.parse(strURL);
        this.clearLayerInfo();
        for (int i = 0; i < wmscap.getLayers().size(); ++i) {
            WMSLayer wmslayer = (WMSLayer)wmscap.getLayers().get(i);
            Envelope extent = new Envelope(-180.0, -90.0, 360.0, 180.0);
            WMSLayerInfoImpl layerinfo = new WMSLayerInfoImpl(wmslayer.getName(), wmslayer.getTitle(), (LayerSource)this, null);
            layerinfo.setMapUnit(0);
            this.addLayerInfo((LayerInfo)layerinfo);
        }
        this.applyDefaultExtent(new Envelope(-180.0, -90.0, 360.0, 180.0));
    }

    public String getVersion() {
        return this._$19727;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

