/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client;

import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.data.feat.BaseField;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.FeatureClass;
import com.esri.mo.data.feat.Field;
import com.esri.mo.data.feat.MapDataset;
import com.esri.mo.map.dpy.BaseFeatureLayer;
import com.esri.mo.map.dpy.BaseLayerInfo;
import com.esri.mo.map.dpy.FeatureLayer;
import com.esri.mo.map.draw.BaseSimpleRenderer;
import com.esri.mo.map.draw.ColorScheme;
import com.esri.mo.map.draw.Renderer;
import com.esri.mo.map.draw.SampleColorSchemes;
import com.esri.ogc.client.WFSFeatureClassProxyImpl;
import com.esri.ogc.client.WFSServer;
import com.esri.ogc.client.ogcWfsXml.FeatureType;
import com.esri.ogc.client.service.FeatureTypeDesc;
import java.io.IOException;

class WFSLayerInfoImpl
extends BaseLayerInfo {
    WFSLayerInfoImpl(FeatureType ft, FeatureTypeDesc ftd, WFSServer wfsserver) throws IOException {
        Envelope e = new Envelope(ft.getLatLongBoundingBox().getMinx(), ft.getLatLongBoundingBox().getMiny(), ft.getLatLongBoundingBox().getMaxx() - ft.getLatLongBoundingBox().getMinx(), ft.getLatLongBoundingBox().getMaxy() - ft.getLatLongBoundingBox().getMiny());
        e.grow(1.05);
        WFSFeatureClassProxyImpl fclass = new WFSFeatureClassProxyImpl(ft.getName(), ftd.getShapeColumnName(), ftd.getGeoTypeID(), ftd.getFeatureFields(), e, wfsserver);
        BaseFields fields = new BaseFields();
        Field[] flds = ftd.getFeatureFields().getFields();
        for (int i = 0; i < flds.length; ++i) {
            fields.addField((Field)new BaseField(flds[i].getName(), flds[i].getType(), flds[i].getDisplaySize(), flds[i].getPrecision()));
        }
        fclass.setFields(fields);
        this.setDataset((MapDataset)fclass);
    }

    public boolean isAvailable(int index) {
        boolean result = super.isAvailable(index);
        switch (index) {
            case 0: 
            case 2: {
                result = true;
            }
        }
        return result;
    }

    FeatureLayer createLayer() throws IOException {
        FeatureClass fclass = (FeatureClass)this.getDataset();
        int ftype = fclass.getFeatureType();
        BaseSimpleRenderer renderer = BaseSimpleRenderer.constructDefaultRenderer((ColorScheme)new SampleColorSchemes(), (int)ftype);
        return new BaseFeatureLayer(fclass, (Renderer)renderer);
    }
}

