/*
 * Decompiled with CFR 0.152.
 */
package com.esri.ogc.client;

import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Polygon;
import com.esri.mo.data.feat.BaseCursor;
import com.esri.mo.data.feat.BaseFeature;
import com.esri.mo.data.feat.BaseFields;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.DataID;
import com.esri.mo.data.feat.DataSelectionSet;
import com.esri.mo.data.feat.Fields;
import com.esri.mo.data.feat.Identifiable;
import com.esri.mo.data.feat.QueryFilter;
import com.esri.mo.data.feat.SelectionSet;
import com.esri.mo.data.feat.SpatialFilter;
import com.esri.mo.data.omc.RemoteFeatureClass;
import com.esri.mo.data.omc.RemoteQuery;
import com.esri.mo.data.omc.ScaleDataID;
import com.esri.mo.data.omc.TileCache;
import com.esri.mo.map.img.BaseFeatureClassProxy;
import com.esri.mo.util.EmptyCursor;
import com.esri.mo.util.MessageCentre;
import com.esri.ogc.client.WFSServer;
import com.esri.ogc.client.WFSWorkspaceImpl;
import com.esri.ogc.client.gml.Features;
import com.esri.ogc.client.service.WFSFeature_new;
import com.esri.ogc.client.service.WFSServiceProxy;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

class WFSFeatureClassProxyImpl
extends BaseFeatureClassProxy
implements RemoteFeatureClass {
    private WFSServer _$18690;
    private WFSServiceProxy _$18691;
    private WFSWorkspaceImpl _$18692;
    private String _$18693;
    private BaseFields _$1995;
    private double _$18694;
    private static final double _$18695 = 40.0;
    private static final double _$18696 = 1.0E-7;
    private boolean _$18697 = true;
    private Counter _$18699 = new Counter(this, 0);
    private int _$18299;
    private static final double _$18700 = 1.5;

    WFSFeatureClassProxyImpl(String name, String shpFieldName, int ftype, BaseFields fields, Envelope extent, WFSServer wfs) {
        super(name, ftype);
        this._$18299 = ftype;
        Envelope clone = extent.getEnvelope();
        if (ftype == 0) {
            clone.grow(1.05);
        }
        this.setExtent(clone);
        this._$18690 = wfs;
        this._$18691 = wfs.getWFSServiceProxy2();
        this._$18692 = (WFSWorkspaceImpl)wfs.getWorkspace();
        this._$18693 = shpFieldName;
        this._$1995 = fields;
        this._$18694 = this._$18705(extent);
        this.setProcessDataEvent(true);
    }

    public void fetch(Envelope extent, double scale, int width, int height) {
        try {
            Envelope area = extent;
            int tileStatus = TileCache.get().isVisited((RemoteFeatureClass)this, scale, (Polygon)area);
            if (tileStatus != 2) {
                area = extent.getEnvelope();
                area.grow(1.5);
                area = this.getExtent().calcIntersection(area);
                TileCache.get().fetch((RemoteFeatureClass)this, scale, (Polygon)area, (Object)extent);
            }
        }
        catch (Exception qex) {
            this.dispatchError(qex);
        }
    }

    public Cursor search(QueryFilter query) {
        if (query == null) {
            throw new IllegalArgumentException();
        }
        Cursor result = null;
        try {
            result = TileCache.get().search((RemoteFeatureClass)this, query);
        }
        catch (Exception qex) {
            this.dispatchError(qex);
            result = super.search(query);
        }
        return result;
    }

    public Identifiable getData(Comparable oid) {
        Identifiable result = super.getData(oid);
        if (result == null) {
            try {
                ScaleDataID dataId = (ScaleDataID)oid;
                result = TileCache.get().getData((RemoteFeatureClass)this, dataId);
            }
            catch (Exception qex) {
                this.dispatchError(qex);
            }
        }
        return result;
    }

    public Cursor getSelectedData(SelectionSet sset) {
        if (sset == null) {
            throw new IllegalArgumentException();
        }
        Cursor result = null;
        if (sset instanceof DataSelectionSet) {
            result = ((DataSelectionSet)sset).getAllData();
        } else {
            try {
                result = TileCache.get().getSelectedData((RemoteFeatureClass)this, sset);
            }
            catch (Exception qex) {
                this.dispatchError(qex);
            }
        }
        return result;
    }

    public Cursor retrieve(RemoteQuery remoteQuery) {
        if (remoteQuery == null || remoteQuery.getQueryFilter() == null) {
            throw new IllegalArgumentException();
        }
        QueryFilter query = remoteQuery.getQueryFilter();
        Envelope queryEnvelope = null;
        boolean okToRetrieve = true;
        if (query instanceof SpatialFilter) {
            SpatialFilter filter = (SpatialFilter)query;
            Envelope extent = this.getExtent();
            FeatureGeometry queryGeometry = filter.getGeometry();
            queryEnvelope = queryGeometry.getEnvelope();
            okToRetrieve = !queryGeometry.clem_disjointEnvelope(extent);
        }
        Object result = new EmptyCursor();
        if (okToRetrieve) {
            this._$18728(1, remoteQuery);
            try {
                result = new CursorImpl(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._$18690.getServerURL()))).append(":").append(this._$18690.getServiceName()).append(":").append(this.getName()))), this.getName(), this._$1995, this._$18691, remoteQuery, this._$18693, remoteQuery.getScale(), queryEnvelope, this._$18699);
            }
            catch (Exception exception) {
                remoteQuery.cancel();
                if (exception instanceof NullPointerException) {
                    this._$18728(4, remoteQuery);
                } else {
                    this.dispatchError(exception);
                }
                this._$18728(3, remoteQuery);
            }
        }
        return result;
    }

    public double getScaleBase() {
        return this._$18694;
    }

    public double getScaleFactor() {
        return 40.0;
    }

    public String getIdentifier() {
        return this.getName();
    }

    public void setGeneralizing(boolean b) {
        this._$18697 = b;
    }

    public boolean isGeneralizing() {
        return this._$18697;
    }

    private final double _$18705(Envelope extent) {
        double dimension = extent.getWidth();
        double height = extent.getHeight();
        if (height < dimension && height > 0.0) {
            dimension = height;
        }
        return dimension * 1.0E-7;
    }

    private final void _$18728(int id, RemoteQuery remoteQuery) {
        if (this._$18692 != null) {
            this._$18692.processGroupEvent(this, id, remoteQuery.getUserObject());
        }
    }

    final void dispatchError(Exception exception) {
        MessageCentre.get().log((Object)this, exception);
    }

    protected void setFields(BaseFields f) {
        super.setFields((Fields)f);
    }

    static {
        _$18695 = 40.0;
        _$18696 = 1.0E-7;
        _$18700 = 1.5;
    }

    private final class CursorImpl
    extends BaseCursor {
        private Envelope _$18747;
        private RemoteQuery _$18748;
        private InputStream _$18749;
        private WFSServiceProxy _$18750;
        private double _$18751;
        private String _$18752;
        private Enumeration _$18753;

        CursorImpl(String wfsName, String wfsFeatureTypeName, BaseFields fields, WFSServiceProxy wfsServiceProxy, RemoteQuery remoteQuery, String wfsShapeFieldName, double scale, Envelope queryEnvelope, Counter counter) throws IOException {
            this._$18748 = remoteQuery;
            this._$18750 = wfsServiceProxy;
            this._$18752 = wfsName;
            this._$18751 = scale;
            int index = wfsShapeFieldName.indexOf(46);
            if (index >= 0) {
                wfsShapeFieldName = wfsShapeFieldName.substring(index + 1);
            }
            String wfsFilter = String.valueOf(String.valueOf(new StringBuffer("<ogc:Filter><ogc:Intersects><ogc:PropertyName>").append(wfsShapeFieldName).append("</ogc:PropertyName><gml:Box srsName=\"EPSG:4326\"><gml:coordinates>").append(queryEnvelope.getMinX()).append(",").append(queryEnvelope.getMinY()).append(" ").append(queryEnvelope.getMaxX()).append(",").append(queryEnvelope.getMaxY()).append("</gml:coordinates></gml:Box></ogc:Intersects></ogc:Filter>")));
            System.out.println("wfsFilter = ".concat(String.valueOf(String.valueOf(wfsFilter))));
            this._$18749 = wfsServiceProxy.getFeatureStream(-1, wfsFeatureTypeName, wfsFilter, fields);
            WFSFeature_new wfsFeature = new WFSFeature_new(this._$18749, fields, wfsFeatureTypeName, WFSFeatureClassProxyImpl.this._$18299);
            Features features = wfsFeature.unMarshalling();
            wfsFeature.generateWFSFeatures(features);
            Vector fs = wfsFeature.getWFSFeatures();
            this._$18753 = fs.elements();
            this.peek();
            this._$18747 = queryEnvelope;
        }

        protected void peek() {
            this._next = null;
            try {
                if (this._$18753.hasMoreElements()) {
                    BaseFeature bf = (BaseFeature)this._$18753.nextElement();
                    bf.setDataID((DataID)new ScaleDataID(this._$18752, WFSFeatureClassProxyImpl.this._$18699.intValue(), this._$18751));
                    WFSFeatureClassProxyImpl.this._$18699.increment();
                    this._next = bf;
                } else {
                    this._next = null;
                }
            }
            catch (NullPointerException npe) {
                if (this._$18748 != null) {
                    this._$18748.cancel();
                }
            }
            catch (Exception e) {
                WFSFeatureClassProxyImpl.this.dispatchError(e);
            }
            this._$18763();
        }

        private void _$18763() {
            if (this._$18747 != null && this._$18748 != null) {
                WFSFeatureClassProxyImpl.this._$18728(2, this._$18748);
                this._$18747 = null;
            }
        }

        public final void dispose() {
            if (this._next != null) {
                this._$18763();
            }
            if (this._$18749 != null) {
                if (this._$18748 != null) {
                    WFSFeatureClassProxyImpl.this._$18728(3, this._$18748);
                }
                this._$18749 = null;
            }
        }
    }

    private final class Counter {
        private int _$18699;

        public Counter(WFSFeatureClassProxyImpl this$0) {
            this._$18699 = 0;
        }

        public Counter(WFSFeatureClassProxyImpl this$0, int c) {
            this._$18699 = c;
        }

        public void increment() {
            ++this._$18699;
        }

        public void increment(int v) {
            this._$18699 += v;
        }

        public void decrement() {
            --this._$18699;
        }

        public void decrement(int v) {
            this._$18699 -= v;
        }

        public void reset() {
            this._$18699 = 0;
        }

        public void reset(int v) {
            this._$18699 = v;
        }

        public int getValue() {
            return this._$18699;
        }

        public int intValue() {
            return this._$18699;
        }
    }
}

