/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.util;

public final class FloatingPointCompare {
    public static final double DEFAULT_EPSILON = 2.220446049250313E-16;

    private FloatingPointCompare() {
    }

    public static final boolean sameSign(double d2, double d3) {
        double d4 = d2 * d3;
        if (d4 > 0.0) {
            return true;
        }
        if (d4 < 0.0) {
            return false;
        }
        if (d2 != 0.0) {
            return false;
        }
        return d3 == 0.0;
    }

    public static boolean ge(double d2, double d3) {
        return FloatingPointCompare.ge(d2, d3, 2.220446049250313E-16);
    }

    public static boolean ge(double d2, double d3, double d4) {
        return d3 - d2 <= (d4 >= 0.0 ? d4 : -d4);
    }

    public static boolean gt(double d2, double d3) {
        return FloatingPointCompare.gt(d2, d3, 2.220446049250313E-16);
    }

    public static boolean gt(double d2, double d3, double d4) {
        return d2 - d3 > (d4 >= 0.0 ? d4 : -d4);
    }

    public static boolean le(double d2, double d3) {
        return FloatingPointCompare.le(d2, d3, 2.220446049250313E-16);
    }

    public static boolean le(double d2, double d3, double d4) {
        return d2 - d3 <= (d4 >= 0.0 ? d4 : -d4);
    }

    public static boolean lt(double d2, double d3) {
        return FloatingPointCompare.lt(d2, d3, 2.220446049250313E-16);
    }

    public static boolean lt(double d2, double d3, double d4) {
        return d3 - d2 > (d4 >= 0.0 ? d4 : -d4);
    }

    public static boolean ne(double d2, double d3) {
        return FloatingPointCompare.ne(d2, d3, 2.220446049250313E-16);
    }

    public static boolean ne(double d2, double d3, double d4) {
        return (d2 - d3 >= 0.0 ? d2 - d3 : d3 - d2) > (d4 >= 0.0 ? d4 : -d4);
    }

    public static boolean eq(double d2, double d3) {
        return FloatingPointCompare.eq(d2, d3, 2.220446049250313E-16);
    }

    public static boolean eq(double d2, double d3, double d4) {
        return (d2 - d3 >= 0.0 ? d2 - d3 : d3 - d2) <= (d4 >= 0.0 ? d4 : -d4);
    }
}

