/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.util;

import com.esri.mo.axl.map.EnvironmentElement;
import com.esri.mo.axl.map.LocaleElement;
import com.esri.mo.axl.map.ScreenElement;
import com.esri.mo.axl.map.SeparatorsElement;
import com.esri.mo.axl.map.UIFontElement;
import com.esri.mo.map.draw.BaseFontSymbol;
import com.esri.mo.util.MessageCentre;
import com.esri.mo.util.Units;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

public class Environment {
    private String d = ";";
    private String i = " ";
    private String a;
    private int b;
    private String c;
    private int e;
    private Color g;
    private Font h;
    private Locale f;

    public static int getCurrentScreenResolution() {
        return Units.getScreenResolution();
    }

    public static Font getPhysicalFont(Font font) throws IOException {
        String string = font.getFamily();
        String string2 = System.getProperty("java.home");
        File file = new File(string2, "lib");
        File file2 = new File(file, "font.properties");
        FileInputStream fileInputStream = new FileInputStream(file2);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string3 = string + ".0";
        String string4 = properties.getProperty(string3);
        if (string4 != null) {
            font = new Font(string4, font.getStyle(), font.getSize());
        }
        return font;
    }

    public void setTupleSeparator(String string) {
        this.d = string;
    }

    public String getTupleSeparator() {
        return this.d;
    }

    public void setCoordSeparator(String string) {
        this.i = string;
    }

    public String getCoordSeparator() {
        return this.i;
    }

    public void setFontColor(Color color) {
        this.g = color;
    }

    public Color getFontColor() {
        return this.g;
    }

    public Locale getLocale() {
        return this.f;
    }

    public void setLocale(Locale locale) {
        this.f = locale;
    }

    public Font getFont() {
        return this.h;
    }

    public void setFont(Font font) {
        this.h = font;
    }

    public int getResolution() {
        return this.e;
    }

    public void setResolution(int n2) {
        this.e = n2;
    }

    public EnvironmentElement toAXL(XmlDocument xmlDocument) {
        ElementNode elementNode;
        EnvironmentElement environmentElement = (EnvironmentElement)((Object)xmlDocument.createElement("ENVIRONMENT"));
        LocaleElement localeElement = (LocaleElement)((Object)xmlDocument.createElement("LOCALE"));
        localeElement.setCountry(this.f.getCountry());
        localeElement.setLanguage(this.f.getLanguage());
        localeElement.setVariant(this.f.getVariant());
        environmentElement.setLocale(localeElement);
        UIFontElement uIFontElement = (UIFontElement)((Object)xmlDocument.createElement("UIFONT"));
        if (this.g != null) {
            uIFontElement.setFontColor(this.g);
        }
        String string = null;
        try {
            string = Environment.getPhysicalFont(this.h).getFamily();
        }
        catch (Exception exception) {
            MessageCentre.get().log(this, exception);
            string = this.h.getFamily();
        }
        uIFontElement.setFont(string);
        uIFontElement.setFontSize(this.h.getSize());
        uIFontElement.setFontStyle(BaseFontSymbol.intToStringStyle(this.h.getStyle()));
        environmentElement.setUIFont(uIFontElement);
        if (this.i == null) {
            this.i = " ";
        }
        if (this.d == null) {
            this.d = ";";
        }
        if (!this.i.equalsIgnoreCase(" ") || !this.d.equalsIgnoreCase(";")) {
            elementNode = (SeparatorsElement)((Object)xmlDocument.createElement("SEPARATORS"));
            if (!this.i.equalsIgnoreCase(" ")) {
                elementNode.setCs(this.i);
            }
            if (!this.d.equalsIgnoreCase(";")) {
                elementNode.setTs(this.d);
            }
            environmentElement.setSeparators((SeparatorsElement)elementNode);
        }
        elementNode = (ScreenElement)((Object)xmlDocument.createElement("SCREEN"));
        elementNode.setDpi(this.e);
        environmentElement.setScreen((ScreenElement)elementNode);
        return environmentElement;
    }

    public synchronized void fromAXL(EnvironmentElement environmentElement) throws IOException {
        if (environmentElement != null) {
            ScreenElement screenElement;
            SeparatorsElement separatorsElement;
            UIFontElement uIFontElement;
            LocaleElement localeElement = environmentElement.getLocale();
            if (localeElement != null) {
                this.f = localeElement.createLocale();
            }
            if ((uIFontElement = environmentElement.getUIFont()) != null) {
                this.h = uIFontElement.createFont();
                this.g = uIFontElement.getFontColor();
            }
            if ((separatorsElement = environmentElement.getSeparators()) != null) {
                if (separatorsElement.getCs() != null) {
                    this.i = separatorsElement.getCs();
                }
                if (separatorsElement.getTs() != null) {
                    this.d = separatorsElement.getTs();
                }
            }
            if ((screenElement = environmentElement.getScreen()) != null) {
                this.setResolution(screenElement.getDpi());
            }
        }
        return;
    }

    public Environment() {
        this.f = Locale.getDefault();
        this.h = new Font("Dialog", 0, 11);
        this.e = Environment.getCurrentScreenResolution();
    }

    public Environment(Locale locale, Font font) {
        this.f = locale;
        this.h = font;
    }
}

