/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.img;

import com.esri.mo.cs.geom.BaseDisplayTransform;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Transform;
import com.esri.mo.map.draw.Symbol;
import com.esri.mo.map.img.ServerImage;
import com.esri.mo.map.img.SubLayerSnapshot;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.CompositeDescriptor;

public class BaseServerImage
implements ServerImage {
    private static final int o = 3;
    private static final int l = 2;
    private static final int m = 1;
    private static final int n = 0;
    private int c;
    private JAI g;
    private RenderedImage d;
    private SubLayerSnapshot e;
    private AffineTransform a;
    private AffineTransform i;
    private Rectangle h;
    private Image j;
    private Dimension f;
    private Envelope k;
    private double b = 1.0;

    public double getTransparency() {
        return this.b;
    }

    public void setTransparency(double d2) {
        this.b = d2;
    }

    public void draw(Graphics2D graphics2D, Symbol symbol, int n2) {
        if (n2 == 0 && this.isAvailable()) {
            Rectangle2D rectangle2D;
            AffineTransform affineTransform = graphics2D.getTransform();
            Envelope envelope = new Envelope(graphics2D.getClipBounds());
            if (!this.k.clem_disjointEnvelope(envelope) && this.h.intersects(rectangle2D = this.a.createTransformedShape(envelope).getBounds2D()) && !(rectangle2D = rectangle2D.createIntersection(this.h)).isEmpty()) {
                if (this.b < 1.0 && this.b >= 0.0) {
                    RenderedImage renderedImage = this.d;
                    boolean bl = false;
                    if (renderedImage.getColorModel() instanceof IndexColorModel) {
                        IndexColorModel indexColorModel = (IndexColorModel)renderedImage.getColorModel();
                        byte[][] byArray = new byte[3][indexColorModel.getMapSize()];
                        indexColorModel.getReds(byArray[0]);
                        indexColorModel.getGreens(byArray[1]);
                        indexColorModel.getBlues(byArray[2]);
                        LookupTableJAI lookupTableJAI = new LookupTableJAI(byArray);
                        renderedImage = JAI.create((String)"lookup", (RenderedImage)renderedImage, (Object)lookupTableJAI);
                        bl = true;
                    }
                    double d2 = this.b * 255.0;
                    byte by = (byte)Math.floor(d2);
                    ParameterBlock parameterBlock = new ParameterBlock();
                    parameterBlock.add(new Float(renderedImage.getWidth())).add(new Float(renderedImage.getHeight()));
                    parameterBlock.add(new Byte[]{new Byte(by)});
                    RenderedOp renderedOp = JAI.create((String)"constant", (ParameterBlock)parameterBlock);
                    parameterBlock = new ParameterBlock();
                    parameterBlock.addSource(renderedImage);
                    parameterBlock.addSource(renderedImage);
                    parameterBlock.add(renderedOp);
                    parameterBlock.add(renderedOp);
                    parameterBlock.add(new Boolean(false));
                    parameterBlock.add(CompositeDescriptor.DESTINATION_ALPHA_LAST);
                    RenderedOp renderedOp2 = JAI.create((String)"composite", (ParameterBlock)parameterBlock, null);
                    graphics2D.drawRenderedImage((RenderedImage)renderedOp2, this.i);
                    renderedOp2.dispose();
                    renderedOp.dispose();
                } else {
                    graphics2D.drawRenderedImage(this.d, this.i);
                }
            }
        }
        return;
    }

    public double getScale() {
        return this.k.width / (double)this.f.width;
    }

    public Dimension getSize() {
        return this.f;
    }

    public FeatureGeometry getGeometry() {
        return this.getEnvelope();
    }

    public Envelope getEnvelope() {
        return this.k.getEnvelope();
    }

    protected void finalize() throws Exception {
        this.flush();
    }

    public void flush() {
        if (this.j != null) {
            this.j.flush();
            this.j = null;
        }
        return;
    }

    public Image toImage() {
        return this.j;
    }

    public Transform getTransform() {
        return new BaseDisplayTransform(this.a);
    }

    private void a(int n2, ActionListener actionListener) {
        actionListener.actionPerformed(new ActionEvent(this, n2, ""));
        return;
    }

    public void load(URL uRL, ActionListener actionListener) throws Exception {
        if (uRL == null || actionListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.c == 0) {
            this.c = 1;
            ParameterBlock parameterBlock = new ParameterBlock();
            parameterBlock.add(uRL);
            this.d = this.g.createNS("url", parameterBlock, null);
            this.c = 2;
            this.d.getWidth();
            this.a(0, actionListener);
            this.d.getData();
            this.c = 3;
            this.a(1, actionListener);
        }
        return;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [BaseServerImage: ");
        stringBuffer.append(this.f.width);
        stringBuffer.append("x");
        stringBuffer.append(this.f.height);
        stringBuffer.append(", ");
        stringBuffer.append(this.k.toString());
        stringBuffer.append(", status=");
        switch (this.c) {
            case 0: {
                stringBuffer.append("Initializing");
                break;
            }
            case 1: {
                stringBuffer.append("Loading");
                break;
            }
            case 2: {
                stringBuffer.append("PartlyAvailable");
                break;
            }
            case 3: {
                stringBuffer.append("FullyAvailable");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isAvailable() {
        return this.c > 1;
    }

    public SubLayerSnapshot getSnapshot() {
        return this.e;
    }

    public BaseServerImage(SubLayerSnapshot subLayerSnapshot, Envelope envelope, Dimension dimension) {
        if (subLayerSnapshot == null || envelope == null || envelope.isEmpty() || dimension == null) {
            throw new IllegalArgumentException();
        }
        this.e = subLayerSnapshot;
        this.k = envelope.getEnvelope();
        this.c = 0;
        this.f = new Dimension(dimension);
        this.a = BaseDisplayTransform.create(this.k, this.f).toAffine();
        try {
            this.i = this.a.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new IllegalArgumentException(noninvertibleTransformException.toString());
        }
        this.h = new Rectangle(0, 0, dimension.width, dimension.height);
        this.g = new JAI();
    }
}

