/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.img;

import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.data.feat.BaseCursor;
import com.esri.mo.data.feat.BaseMapDataset;
import com.esri.mo.data.feat.Cursor;
import com.esri.mo.data.feat.DataEvent;
import com.esri.mo.data.feat.QueryFilter;
import com.esri.mo.map.dpy.DisplayArea;
import com.esri.mo.map.img.BaseCache;
import com.esri.mo.map.img.BaseMapImageFilter;
import com.esri.mo.map.img.Cache;
import com.esri.mo.map.img.ImageLayerSource;
import com.esri.mo.map.img.ImageRetrievalException;
import com.esri.mo.map.img.ImageServer;
import com.esri.mo.map.img.ServerImage;
import com.esri.mo.map.img.SubLayerSnapshot;
import com.esri.mo.map.img.Tile;
import com.esri.mo.map.img.a;
import com.esri.mo.map.img.e;
import com.esri.mo.map.img.f;
import com.esri.mo.util.EmptyCursor;
import com.esri.mo.util.MessageCentre;
import java.awt.Dimension;
import java.net.URL;

public abstract class BaseImageServer
extends BaseMapDataset
implements ImageServer {
    public static final int DEFAULT_CACHE_LIMIT = 5;
    private Envelope b;
    private Cache c;
    private ImageLayerSource a;

    static void a(BaseImageServer baseImageServer, Envelope envelope) {
        baseImageServer.b(envelope);
    }

    private final void b(Envelope envelope) {
        this.dispatchEvent(new DataEvent(this, 2, envelope));
        this.dispatchEvent(new DataEvent(this, 5, envelope));
        return;
    }

    private final void a(Exception exception) {
        MessageCentre.get().log(this, exception);
        return;
    }

    private final void a(int n2) {
        this.dispatchEvent(new DataEvent(this, n2));
        return;
    }

    public void retrieve(Tile tile) {
        this.a(1);
        try {
            URL uRL = this.getImageLayerSource().getImageURL(tile);
            ServerImage serverImage = tile.getImage();
            f f2 = new f(this, serverImage, true);
            serverImage.load(uRL, f2);
            if (f2.a()) {
                throw new ImageRetrievalException();
            }
        }
        catch (NullPointerException nullPointerException) {
            tile.cancel();
            this.a(4);
        }
        catch (Exception exception) {
            tile.cancel();
            this.a(exception);
        }
        this.a(3);
        return;
    }

    public Tile queryTile(Envelope envelope, Dimension dimension, SubLayerSnapshot subLayerSnapshot) {
        if (envelope == null || dimension == null || subLayerSnapshot == null) {
            throw new IllegalArgumentException();
        }
        return new a(null, subLayerSnapshot, envelope, dimension);
    }

    private final Tile a(BaseMapImageFilter baseMapImageFilter) {
        DisplayArea displayArea = baseMapImageFilter.getDisplayArea();
        Dimension dimension = displayArea.getSize();
        Envelope envelope = displayArea.getExtent();
        SubLayerSnapshot subLayerSnapshot = baseMapImageFilter.getSubLayerSnapshot();
        return this.queryTile(envelope, dimension, subLayerSnapshot);
    }

    public Cursor searchDirect(QueryFilter queryFilter) {
        BaseCursor baseCursor = new EmptyCursor();
        if (queryFilter instanceof BaseMapImageFilter) {
            BaseMapImageFilter baseMapImageFilter = (BaseMapImageFilter)queryFilter;
            this.a(1);
            try {
                Tile tile = this.a(baseMapImageFilter);
                URL uRL = this.getImageLayerSource().getImageURL(tile);
                ServerImage serverImage = tile.getImage();
                f f2 = new f(this, serverImage, false);
                serverImage.load(uRL, f2);
                if (f2.a()) {
                    throw new ImageRetrievalException();
                }
                baseCursor = new e(this, tile);
            }
            catch (NullPointerException nullPointerException) {
                this.a(4);
            }
            catch (Exception exception) {
                this.a(exception);
            }
            this.a(3);
        }
        return baseCursor;
    }

    public void setImageLayerSource(ImageLayerSource imageLayerSource) {
        this.a = imageLayerSource;
    }

    public ImageLayerSource getImageLayerSource() {
        return this.a;
    }

    public Cursor search(QueryFilter queryFilter) {
        Cursor cursor = null;
        cursor = queryFilter.getUseCache() && this.c != null ? this.c.search(queryFilter) : this.searchDirect(queryFilter);
        return cursor;
    }

    public Cache getCache() {
        return this.c;
    }

    public BaseImageServer(ImageLayerSource imageLayerSource, String string, int n2) {
        if (imageLayerSource == null || string == null) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            n2 = 5;
        }
        this.setImageLayerSource(imageLayerSource);
        this.setName(string);
        if (n2 > 0) {
            this.c = new BaseCache(this, n2);
        }
    }

    public BaseImageServer(ImageLayerSource imageLayerSource, String string) {
        this(imageLayerSource, string, 5);
    }
}

