/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.img;

import com.esri.mo.axl.map.ImageWorkspaceElement;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.Util;
import com.esri.mo.axl.map.WorkspaceElement;
import com.esri.mo.cs.geom.Envelope;
import com.esri.mo.data.feat.MapDataset;
import com.esri.mo.map.dpy.BaseLayerInfo;
import com.esri.mo.map.dpy.BaseLayerSource;
import com.esri.mo.map.dpy.Layer;
import com.esri.mo.map.dpy.LayerInfo;
import com.esri.mo.map.img.BaseImageDirectory;
import com.esri.mo.map.img.BaseImageDirectoryCatalog;
import com.esri.mo.map.img.BaseImageLayer;
import com.esri.mo.map.img.ImageCatalog;
import com.esri.mo.map.img.ImageClass;
import com.esri.mo.util.MessageCentre;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.io.FileNotFoundException;
import java.io.IOException;

public class BaseImageDirectoryLayerSource
extends BaseLayerSource {
    static /* synthetic */ Class a;
    private BaseImageDirectory b;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static BaseImageDirectoryLayerSource fromAXL(ElementNode elementNode) throws IOException {
        if (elementNode instanceof ImageWorkspaceElement) {
            ImageWorkspaceElement imageWorkspaceElement = (ImageWorkspaceElement)elementNode;
            BaseImageDirectoryLayerSource baseImageDirectoryLayerSource = null;
            try {
                baseImageDirectoryLayerSource = BaseImageDirectoryLayerSource.getLayerSource(imageWorkspaceElement.getDirectory());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FileNotFoundException(imageWorkspaceElement.getDirectory());
            }
            return baseImageDirectoryLayerSource;
        }
        throw new IllegalArgumentException();
    }

    public WorkspaceElement toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        ImageWorkspaceElement imageWorkspaceElement = (ImageWorkspaceElement)((Object)xmlDocument.createElement("IMAGEWORKSPACE"));
        if (imageWorkspaceElement == null) {
            throw new IncompleteDictionaryException();
        }
        imageWorkspaceElement.setDirectory(this.getPath());
        imageWorkspaceElement.setName("jai_ws-" + Util.getNextUniqueId());
        return imageWorkspaceElement;
    }

    public Layer getLayer(String string, int n2) {
        ImageCatalog imageCatalog;
        LayerInfo layerInfo;
        if (this.size() > 0 && (layerInfo = this.getLayerInfo(0)).getDataset() instanceof ImageCatalog && (imageCatalog = (ImageCatalog)layerInfo.getDataset()).getPreferredName().equalsIgnoreCase(string)) {
            string = layerInfo.getName();
        }
        return super.getLayer(string, n2);
    }

    protected Layer createLayer(LayerInfo layerInfo) {
        if (layerInfo == null) {
            throw new IllegalArgumentException();
        }
        ImageClass imageClass = (ImageClass)layerInfo.getDataset();
        BaseImageLayer baseImageLayer = new BaseImageLayer(imageClass);
        if (imageClass instanceof ImageCatalog) {
            baseImageLayer.setName(((ImageCatalog)imageClass).getPreferredName());
        }
        return baseImageLayer;
    }

    public void refresh() throws IOException {
        this.clearLayerInfo();
        this.b.refresh();
        if (this.b.size() > 0) {
            Object object;
            BaseLayerInfo baseLayerInfo;
            String[] stringArray = this.b.getDatasetNames();
            if (stringArray.length > 1) {
                BaseImageDirectoryCatalog baseImageDirectoryCatalog = new BaseImageDirectoryCatalog(this.b);
                baseLayerInfo = new BaseLayerInfo(baseImageDirectoryCatalog);
                this.addLayerInfo(baseLayerInfo);
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    object = (ImageClass)this.b.getDataset(stringArray[n2]);
                    baseLayerInfo = new BaseLayerInfo((MapDataset)object);
                    this.addLayerInfo(baseLayerInfo);
                }
                catch (Exception exception) {
                    MessageCentre.get().log(this, exception);
                }
                ++n2;
            }
            object = this.calcFullExtent();
            this.setFullExtent((Envelope)object);
        }
        return;
    }

    public String getPath() {
        return this.b.getPath();
    }

    private BaseImageDirectoryLayerSource(String string) throws IOException {
        this.b = new BaseImageDirectory(string);
        this.refresh();
    }

    public static BaseImageDirectoryLayerSource getLayerSource(String string) throws IOException {
        String string2 = (a == null ? (a = BaseImageDirectoryLayerSource.a("com.esri.mo.map.img.BaseImageDirectoryLayerSource")) : a).getName() + ":" + string;
        BaseImageDirectoryLayerSource baseImageDirectoryLayerSource = (BaseImageDirectoryLayerSource)BaseLayerSource.findLayerSource(string2);
        if (baseImageDirectoryLayerSource == null) {
            baseImageDirectoryLayerSource = new BaseImageDirectoryLayerSource(string);
            baseImageDirectoryLayerSource.setConnection(string2);
            BaseLayerSource.insertLayerSource(baseImageDirectoryLayerSource);
        }
        return baseImageDirectoryLayerSource;
    }
}

