/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.TextMarkerSymbolElement;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.Transform;
import com.esri.mo.map.draw.ArcFont;
import com.esri.mo.map.draw.BaseFontSymbol;
import com.esri.mo.map.draw.BaseTextSymbol;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;

public class TextMarkerSymbol
extends BaseTextSymbol {
    private int a = 0;
    private int e = 0;
    private int b = 0;
    private double f = 0.0;
    private double d = 0.0;
    private boolean c = true;
    private static final int g = 0;
    private static final int j = 0;
    private static final int h = 0;
    private static final double k = 0.0;
    private static final double i = 0.0;
    public static final boolean DEFAULT_OVERLAP = true;
    public static final int ALIGNMENT_TOP = 4;
    public static final int ALIGNMENT_BOTTOM = 3;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_LEFT = 1;
    public static final int ALIGNMENT_CENTER = 0;

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof TextMarkerSymbolElement)) {
            throw new IllegalArgumentException();
        }
        TextMarkerSymbolElement textMarkerSymbolElement = (TextMarkerSymbolElement)elementNode;
        this.setTransparency(textMarkerSymbolElement.getTransparency());
        this.setAntialiasing(textMarkerSymbolElement.getAntialiasing());
        this.setFont(new ArcFont(textMarkerSymbolElement.getFont(), BaseFontSymbol.stringToIntStyle(textMarkerSymbolElement.getFontStyle()), textMarkerSymbolElement.getFontSize()));
        this.setColor(textMarkerSymbolElement.getFontColor());
        this.setOutline(textMarkerSymbolElement.getOutline());
        this.setGlowing(textMarkerSymbolElement.getGlowing());
        this.setShadow(textMarkerSymbolElement.getShadow());
        this.setBlockOut(textMarkerSymbolElement.getBlockOut());
        this.setOverlap(textMarkerSymbolElement.getOverlap());
        this.setInterval(textMarkerSymbolElement.getInterval());
        this.setAngle(textMarkerSymbolElement.getAngle());
        this.setPrintMode(BaseFontSymbol.stringToIntPrintMode(textMarkerSymbolElement.getPrintMode()));
        this.setHAlignment(TextMarkerSymbol.b(textMarkerSymbolElement.getHAlignment()));
        this.setVAlignment(TextMarkerSymbol.b(textMarkerSymbolElement.getVAlignment()));
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        TextMarkerSymbolElement textMarkerSymbolElement = (TextMarkerSymbolElement)((Object)xmlDocument.createElement("TEXTMARKERSYMBOL"));
        if (textMarkerSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getTransparency() != 1.0) {
            textMarkerSymbolElement.setTransparency(this.getTransparency());
        }
        if (this.getAntialiasing()) {
            textMarkerSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getFont() != BaseFontSymbol.DEFAULT_FONT) {
            textMarkerSymbolElement.setFont(this.getFont().getName());
            textMarkerSymbolElement.setStyle(BaseFontSymbol.intToStringStyle(this.getFont().getStyle()));
            textMarkerSymbolElement.setSize(this.getFont().getSize());
        }
        if (this.getColor() != BaseFontSymbol.DEFAULT_COLOR) {
            textMarkerSymbolElement.setFontColor(this.getColor());
        }
        if (this.getOutline() != BaseFontSymbol.DEFAULT_OUTLINE) {
            textMarkerSymbolElement.setOutline(this.getOutline());
        }
        if (this.getGlowing() != BaseFontSymbol.DEFAULT_GLOWING) {
            textMarkerSymbolElement.setGlowing(this.getGlowing());
        }
        if (this.getShadow() != BaseFontSymbol.DEFAULT_SHADOW) {
            textMarkerSymbolElement.setShadow(this.getShadow());
        }
        if (this.getBlockOut() != BaseFontSymbol.DEFAULT_BLOCKOUT) {
            textMarkerSymbolElement.setBlockOut(this.getBlockOut());
        }
        if (!this.getOverlap()) {
            textMarkerSymbolElement.setOverlap(this.getOverlap());
        }
        if (this.getInterval() != 0.0) {
            textMarkerSymbolElement.setInterval((int)this.getInterval());
        }
        if (this.getAngle() != 0.0) {
            textMarkerSymbolElement.setAngle(this.getAngle());
        }
        if (this.getPrintMode() != 0) {
            textMarkerSymbolElement.setPrintMode(BaseFontSymbol.intToStringPrintMode(this.getPrintMode()));
        }
        if (this.getHAlignment() != 0) {
            textMarkerSymbolElement.setHAlignment(TextMarkerSymbol.a(this.getHAlignment()));
        }
        if (this.getVAlignment() != 0) {
            textMarkerSymbolElement.setVAlignment(TextMarkerSymbol.a(this.getVAlignment()));
        }
        return textMarkerSymbolElement;
    }

    private static int b(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("left")) {
            return 1;
        }
        if (string.equalsIgnoreCase("right")) {
            return 2;
        }
        if (string.equalsIgnoreCase("top")) {
            return 4;
        }
        if (string.equalsIgnoreCase("bottom")) {
            return 3;
        }
        return 0;
    }

    private static String a(int n2) {
        switch (n2) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 4: {
                return "top";
            }
            case 3: {
                return "bottom";
            }
        }
        return "center";
    }

    public int getVAlignment() {
        return this.a;
    }

    public void setVAlignment(int n2) {
        this.a = n2;
    }

    public int getHAlignment() {
        return this.e;
    }

    public void setHAlignment(int n2) {
        this.e = n2;
    }

    public int getPrintMode() {
        return this.b;
    }

    public void setPrintMode(int n2) {
        this.b = n2;
    }

    public double getAngle() {
        return Math.toDegrees(this.f);
    }

    public void setAngle(double d2) {
        this.f = Math.toRadians(d2);
        return;
    }

    public double getInterval() {
        return this.d;
    }

    public void setInterval(double d2) {
        this.d = d2;
    }

    public boolean getOverlap() {
        return this.c;
    }

    public void setOverlap(boolean bl) {
        this.c = bl;
    }

    public void draw(String string, double d2, double d3, double d4, Graphics2D graphics2D, FeatureGeometry featureGeometry) {
        if (string != null && featureGeometry instanceof Point) {
            double d5 = d2;
            double d6 = d3;
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
            if (this.getAntialiasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension dimension = this.getSizeTextWithEffect(string);
            double d7 = dimension.getWidth();
            double d8 = dimension.getHeight();
            double d9 = graphics2D.getTransform().getScaleX();
            double d10 = graphics2D.getTransform().getScaleY();
            double d11 = d5;
            double d12 = d6;
            if (this.e == 0 && this.a == 0 && this.f != 0.0) {
                d11 = d5;
                d12 = d6;
            } else {
                double d13 = (this.d + d7 / 2.0) / d9;
                double d14 = (this.d + d8 / 2.0) / d10;
                switch (this.e) {
                    case 1: {
                        d11 = d5 - d13;
                        break;
                    }
                    case 2: {
                        d11 = d5 + d13;
                        break;
                    }
                    default: {
                        d11 = d5;
                    }
                }
                switch (this.a) {
                    case 4: {
                        d12 = d6 + d14;
                        break;
                    }
                    case 3: {
                        d12 = d6 - d14;
                        break;
                    }
                    default: {
                        d12 = d6;
                    }
                }
            }
            this.drawTextWithEffect(graphics2D, string, d11, d12, this.f, this.getFont(), this.getColor(), this.getBlockOut(), this.getOutline(), this.getShadow(), this.getGlowing(), false);
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        return;
    }

    public void prepare(String string, FeatureGeometry featureGeometry, Transform transform) {
        String string2 = BaseFontSymbol.stringToNewMode(string, this.b, 0);
        if (string2.length() != 0) {
            Dimension dimension = new Dimension(0, 0);
            this.getRenderer().getLayer().getLayerset().getDisplayManager().getLabelEngine().add(dimension, featureGeometry, this, string2);
        }
        return;
    }
}

