/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.TextSymbolElement;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Transform;
import com.esri.mo.map.draw.ArcFont;
import com.esri.mo.map.draw.BaseFontSymbol;
import com.esri.mo.map.draw.BaseTextSymbol;
import com.esri.mo.util.Resource;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;

public class SimpleTextSymbol
extends BaseTextSymbol {
    private int a = 0;
    private double b = 0.0;
    public static final int DEFAULT_PRINTMODE = 0;
    public static final double DEFAULT_INTERVAL = 0.0;

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof TextSymbolElement)) {
            throw new IllegalArgumentException();
        }
        TextSymbolElement textSymbolElement = (TextSymbolElement)elementNode;
        this.setTransparency(textSymbolElement.getTransparency());
        this.setAntialiasing(textSymbolElement.getAntialiasing());
        this.setFont(new ArcFont(textSymbolElement.getFont(), BaseFontSymbol.stringToIntStyle(textSymbolElement.getFontStyle()), textSymbolElement.getFontSize()));
        this.setColor(textSymbolElement.getFontColor());
        this.setOutline(textSymbolElement.getOutline());
        this.setGlowing(textSymbolElement.getGlowing());
        this.setShadow(textSymbolElement.getShadow());
        this.setBlockOut(textSymbolElement.getBlockOut());
        this.setInterval(textSymbolElement.getInterval());
        this.setPrintMode(BaseFontSymbol.stringToIntPrintMode(textSymbolElement.getPrintMode()));
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        TextSymbolElement textSymbolElement = (TextSymbolElement)((Object)xmlDocument.createElement("TEXTSYMBOL"));
        if (textSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getTransparency() != 1.0) {
            textSymbolElement.setTransparency(this.getTransparency());
        }
        if (this.getAntialiasing()) {
            textSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getFont() != BaseFontSymbol.DEFAULT_FONT) {
            textSymbolElement.setFont(this.getFont().getName());
            textSymbolElement.setFontStyle(BaseFontSymbol.intToStringStyle(this.getFont().getStyle()));
            textSymbolElement.setFontSize(this.getFont().getSize());
        }
        if (this.getColor() != BaseFontSymbol.DEFAULT_COLOR) {
            textSymbolElement.setFontColor(this.getColor());
        }
        if (this.getOutline() != BaseFontSymbol.DEFAULT_OUTLINE) {
            textSymbolElement.setOutline(this.getOutline());
        }
        if (this.getGlowing() != BaseFontSymbol.DEFAULT_GLOWING) {
            textSymbolElement.setGlowing(this.getGlowing());
        }
        if (this.getShadow() != BaseFontSymbol.DEFAULT_SHADOW) {
            textSymbolElement.setShadow(this.getShadow());
        }
        if (this.getBlockOut() != BaseFontSymbol.DEFAULT_BLOCKOUT) {
            textSymbolElement.setBlockOut(this.getBlockOut());
        }
        if (this.getInterval() != 0.0) {
            textSymbolElement.setInterval((int)this.getInterval());
        }
        if (this.getPrintMode() != 0) {
            textSymbolElement.setPrintMode(BaseFontSymbol.intToStringPrintMode(this.getPrintMode()));
        }
        return textSymbolElement;
    }

    public int getPrintMode() {
        return this.a;
    }

    public void setPrintMode(int n2) {
        this.a = n2;
    }

    public double getInterval() {
        return this.b;
    }

    public void setInterval(double d2) {
        this.b = d2;
    }

    public void draw(String string, double d2, double d3, double d4, Graphics2D graphics2D, FeatureGeometry featureGeometry) {
        if (string.equals(Resource.getBundleText("NullDisplayText"))) {
            return;
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
        if (this.getAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.drawTextWithEffect(graphics2D, string, d2, d3, d4, this.getFont(), this.getColor(), this.getBlockOut(), this.getOutline(), this.getShadow(), this.getGlowing(), false);
        graphics2D.setComposite(AlphaComposite.SrcOver);
        return;
    }

    public void prepare(String string, FeatureGeometry featureGeometry, Transform transform) {
        String string2 = BaseFontSymbol.stringToNewMode(string, this.a, 0);
        if (string2.length() != 0) {
            Dimension dimension = this.getSizeTextWithEffect(string2);
            this.getRenderer().getLayer().getLayerset().getDisplayManager().getLabelEngine().add(dimension, featureGeometry, this, string2);
        }
        return;
    }
}

