/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.AXLSerializable;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.SimplePolygonSymbolElement;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Ring;
import com.esri.mo.map.draw.AoFillStyle;
import com.esri.mo.map.draw.AoLineStroke;
import com.esri.mo.map.draw.AoPatternPaint;
import com.esri.mo.map.draw.SimpleLineSymbol;
import com.esri.mo.map.draw.a;
import com.esri.mo.map.draw.b;
import com.esri.mo.util.FloatingPointCompare;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class SimplePolygonSymbol
extends SimpleLineSymbol
implements AXLSerializable {
    private boolean a = false;
    private Paint b = AoFillStyle.getPaint(0);
    private int e = 1;
    private double d = 6.0;
    private double c = 1.0;
    public static final int DEFAULT_FILLTYPE = 0;
    public static final double DEFAULT_FILLINTERVAL = 6.0;
    public static final double DEFAULT_FILLTRANSPARENCY = 1.0;
    public static final String Fill_Type_Transparent = "transparent";
    public static final String Fill_Type_Darkgray = "darkgray";
    public static final String Fill_Type_Gray = "gray";
    public static final String Fill_Type_Lightgray = "lightgray";
    public static final String Fill_Type_Diagcross = "diagcross";
    public static final String Fill_Type_Cross = "cross";
    public static final String Fill_Type_Fdiagonal = "fdiagonal";
    public static final String Fill_Type_Bdiagonal = "bdiagonal";
    public static final String Fill_Type_Vertical = "vertical";
    public static final String Fill_Type_Horizontal = "horizontal";
    public static final String Fill_Type_Solid = "solid";

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof SimplePolygonSymbolElement)) {
            throw new IllegalArgumentException();
        }
        SimplePolygonSymbolElement simplePolygonSymbolElement = (SimplePolygonSymbolElement)elementNode;
        if (this.getAntialiasing()) {
            this.setAntialiasing(simplePolygonSymbolElement.getAntialiasing());
        }
        Color color = simplePolygonSymbolElement.getFillColor();
        this.setFillInterval(simplePolygonSymbolElement.getFillInterval());
        String string = simplePolygonSymbolElement.getFillType();
        int n2 = 0;
        if (string.equalsIgnoreCase(Fill_Type_Horizontal)) {
            n2 = 2;
        } else if (string.equalsIgnoreCase(Fill_Type_Vertical)) {
            n2 = 3;
        } else if (string.equalsIgnoreCase(Fill_Type_Bdiagonal)) {
            n2 = 5;
        } else if (string.equalsIgnoreCase(Fill_Type_Fdiagonal)) {
            n2 = 4;
        } else if (string.equalsIgnoreCase(Fill_Type_Cross)) {
            n2 = 6;
        } else if (string.equalsIgnoreCase(Fill_Type_Diagcross)) {
            n2 = 7;
        } else if (string.equalsIgnoreCase(Fill_Type_Lightgray)) {
            n2 = 8;
        } else if (string.equalsIgnoreCase(Fill_Type_Gray)) {
            n2 = 9;
        } else if (string.equalsIgnoreCase(Fill_Type_Darkgray)) {
            n2 = 10;
        }
        this.a = simplePolygonSymbolElement.hasTransparencyAttribute();
        if (this.a) {
            this.setTransparency(simplePolygonSymbolElement.getTransparency());
            this.setFillTransparency(simplePolygonSymbolElement.getTransparency());
        } else {
            this.setFillTransparency(simplePolygonSymbolElement.getFillTransparency());
            this.setTransparency(simplePolygonSymbolElement.getBoundaryTransparency());
        }
        if (this.getFillTransparency() == 0.0) {
            n2 = 1;
        }
        this.setPaint(AoFillStyle.getPaint(n2, color));
        this.setLineColor(simplePolygonSymbolElement.getBoundaryColor());
        String string2 = simplePolygonSymbolElement.getBoundaryType();
        int n3 = 0;
        if (string2.equalsIgnoreCase("dash")) {
            n3 = 1;
        } else if (string2.equalsIgnoreCase("dot")) {
            n3 = 2;
        } else if (string2.equalsIgnoreCase("dash_dot")) {
            n3 = 3;
        } else if (string2.equalsIgnoreCase("dash_dot_dot")) {
            n3 = 4;
        }
        String string3 = simplePolygonSymbolElement.getBoundaryCapType();
        int n4 = 0;
        if (string3.equalsIgnoreCase("round")) {
            n4 = 1;
        } else if (string3.equalsIgnoreCase("square")) {
            n4 = 2;
        }
        String string4 = simplePolygonSymbolElement.getBoundaryJoinType();
        int n5 = 1;
        if (string4.equalsIgnoreCase("miter")) {
            n5 = 1;
        } else if (string4.equalsIgnoreCase("bevel")) {
            n5 = 2;
        }
        this.e = simplePolygonSymbolElement.getBoundaryWidth();
        if (this.e > 0) {
            this.setStroke(new AoLineStroke(n3, (float)this.e, n4, n5));
        }
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        Object object;
        Object object2;
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        SimplePolygonSymbolElement simplePolygonSymbolElement = (SimplePolygonSymbolElement)((Object)xmlDocument.createElement("SIMPLEPOLYGONSYMBOL"));
        if (simplePolygonSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getAntialiasing()) {
            simplePolygonSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getFillInterval() != 6.0) {
            simplePolygonSymbolElement.setFillInterval((int)this.getFillInterval());
        }
        if (!this.a) {
            simplePolygonSymbolElement.setBoundaryTransparency(this.getTransparency());
            simplePolygonSymbolElement.setFillTransparency(this.getFillTransparency());
        } else {
            simplePolygonSymbolElement.setTransparency(this.getTransparency());
        }
        Paint paint = this.getPaint();
        if (paint != null) {
            if (paint instanceof Color) {
                object2 = (Color)paint;
                if (!((Color)object2).equals(new Color(0, 200, 0))) {
                    simplePolygonSymbolElement.setFillColor((Color)paint);
                }
            } else if (paint instanceof AoPatternPaint) {
                object2 = (AoPatternPaint)paint;
                object = Fill_Type_Solid;
                switch (((AoPatternPaint)object2).getStyle()) {
                    case 2: {
                        object = Fill_Type_Horizontal;
                        break;
                    }
                    case 3: {
                        object = Fill_Type_Vertical;
                        break;
                    }
                    case 6: {
                        object = Fill_Type_Cross;
                        break;
                    }
                    case 7: {
                        object = Fill_Type_Diagcross;
                        break;
                    }
                    case 5: {
                        object = Fill_Type_Bdiagonal;
                        break;
                    }
                    case 4: {
                        object = Fill_Type_Fdiagonal;
                        break;
                    }
                    case 8: {
                        object = Fill_Type_Lightgray;
                        break;
                    }
                    case 9: {
                        object = Fill_Type_Gray;
                        break;
                    }
                    case 10: {
                        object = Fill_Type_Darkgray;
                        break;
                    }
                    case 0: {
                        object = Fill_Type_Solid;
                        break;
                    }
                    case 1: {
                        object = Fill_Type_Solid;
                    }
                }
                if (!((String)object).equalsIgnoreCase(Fill_Type_Solid)) {
                    simplePolygonSymbolElement.setFillType((String)object);
                }
                if (!((AoPatternPaint)object2).getColor().equals(new Color(0, 200, 0))) {
                    simplePolygonSymbolElement.setFillColor(((AoPatternPaint)object2).getColor());
                }
            }
        }
        if ((object2 = this.getStroke()) instanceof AoLineStroke) {
            object = (AoLineStroke)object2;
            if (((BasicStroke)object).getLineWidth() != 1.0f) {
                simplePolygonSymbolElement.setBoundaryWidth((int)((BasicStroke)object).getLineWidth());
            }
            if (((AoLineStroke)object).getLineStyle() != 0) {
                switch (((AoLineStroke)object).getLineStyle()) {
                    case 0: {
                        simplePolygonSymbolElement.setBoundaryType(Fill_Type_Solid);
                        break;
                    }
                    case 1: {
                        simplePolygonSymbolElement.setBoundaryType("dash");
                        break;
                    }
                    case 2: {
                        simplePolygonSymbolElement.setBoundaryType("dot");
                        break;
                    }
                    case 3: {
                        simplePolygonSymbolElement.setBoundaryType("dash_dot");
                        break;
                    }
                    case 4: {
                        simplePolygonSymbolElement.setBoundaryType("dash_dot_dot");
                    }
                }
            }
            if (((BasicStroke)object).getEndCap() != 0) {
                switch (((BasicStroke)object).getEndCap()) {
                    case 0: {
                        simplePolygonSymbolElement.setBoundaryCapType("butt");
                        break;
                    }
                    case 1: {
                        simplePolygonSymbolElement.setBoundaryCapType("round");
                        break;
                    }
                    case 2: {
                        simplePolygonSymbolElement.setBoundaryCapType("square");
                    }
                }
            }
            if (((BasicStroke)object).getLineJoin() != 1) {
                switch (((BasicStroke)object).getLineJoin()) {
                    case 1: {
                        simplePolygonSymbolElement.setBoundaryJoinType("round");
                        break;
                    }
                    case 0: {
                        simplePolygonSymbolElement.setBoundaryJoinType("miter");
                        break;
                    }
                    case 2: {
                        simplePolygonSymbolElement.setBoundaryJoinType("bevel");
                    }
                }
            }
        } else {
            simplePolygonSymbolElement.setBoundaryType(Fill_Type_Solid);
            simplePolygonSymbolElement.setBoundaryWidth(this.e);
        }
        if (this.getLineColor() != SimpleLineSymbol.DEFAULT_COLOR) {
            simplePolygonSymbolElement.setBoundaryColor(this.getLineColor());
        }
        return simplePolygonSymbolElement;
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof AoLineStroke) {
            AoLineStroke aoLineStroke = (AoLineStroke)stroke;
            this.e = (int)aoLineStroke.getLineWidth();
        }
        super.setStroke(stroke);
        return;
    }

    public double getFillInterval() {
        return this.d;
    }

    public void setFillInterval(double d2) {
        this.d = d2;
    }

    public boolean hasTransparency() {
        return super.hasTransparency() || FloatingPointCompare.ne(this.getFillTransparency(), 1.0);
    }

    public double getFillTransparency() {
        return this.c;
    }

    public void setFillTransparency(double d2) {
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        this.c = d2;
        return;
    }

    protected void fill(Graphics2D graphics2D, Shape shape) {
        if (this.b != null) {
            graphics2D.setPaint(this.b);
            graphics2D.fill(shape);
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    protected void fill(Graphics2D var1_1, FeatureGeometry var2_2, AffineTransform var3_3) {
        var9_4 = -1;
        if (this.b != null) {
            var1_1.setPaint(this.b);
            var4_5 = 0;
            {
                switch (var9_4) {
                    case 1: {
                        continue block6;
                    }
                    while (true) {
                        var5_6 = var2_2.getGeometry(var4_5);
                        var6_7 = (Ring)var5_6;
                        var7_8 = var6_7.getPoints();
                        var8_9 = com.esri.mo.map.draw.a.getPoints(var7_8.size());
                        var7_8.transform(var8_9.getX(), var8_9.getY(), var3_3);
                        var1_1.fillPolygon(var8_9.getX(), var8_9.getY(), var7_8.size());
                        ++var4_5;
                        case 0: {
                            var9_4 = -1;
                        }
                        break;
                    }
                }
            }
            if (var4_5 < var2_2.size()) ** continue;
        }
        return;
    }

    public Paint getPaint() {
        return this.b;
    }

    public void setPaint(Paint paint) {
        this.b = paint;
        if (paint == null) {
            this.setFillTransparency(0.0);
            this.a = false;
        }
        return;
    }

    public void draw(FeatureGeometry featureGeometry, Graphics2D graphics2D, Object object) {
        if (this.getAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getFillTransparency()));
        AffineTransform affineTransform = this.switchTransform(graphics2D);
        if (featureGeometry.size() > 1) {
            b b2 = com.esri.mo.map.draw.b.a(featureGeometry, affineTransform);
            this.fill(graphics2D, b2);
        } else {
            try {
                featureGeometry.getGeometry(0);
                this.fill(graphics2D, featureGeometry, affineTransform);
            }
            catch (Exception exception) {
                b b3 = com.esri.mo.map.draw.b.a(featureGeometry, affineTransform);
                this.fill(graphics2D, b3);
            }
        }
        graphics2D.setTransform(affineTransform);
        if (this.e > 0) {
            super.draw(featureGeometry, graphics2D, object);
        }
        return;
    }
}

