/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.AXLSerializable;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.SimpleLineSymbolElement;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Path;
import com.esri.mo.map.draw.AoLineStroke;
import com.esri.mo.map.draw.BaseSymbol;
import com.esri.mo.map.draw.a;
import com.esri.mo.map.draw.b;
import com.esri.mo.util.Resource;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public class SimpleLineSymbol
extends BaseSymbol
implements AXLSerializable {
    public static final int DEFAULT_JOINTYPE = 1;
    public static final int DEFAULT_CAPTYPE = 0;
    public static final int DEFAULT_WIDTH = 0;
    public static final int DEFAULT_TYPE = 0;
    public static final boolean DEFAULT_OVERLAP = true;
    public static final Color DEFAULT_COLOR = Color.black;
    private boolean a = false;
    private Color d;
    private Composite c = null;
    private Stroke b = new AoLineStroke(1.0f);

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof SimpleLineSymbolElement)) {
            throw new IllegalArgumentException();
        }
        SimpleLineSymbolElement simpleLineSymbolElement = (SimpleLineSymbolElement)elementNode;
        this.setAntialiasing(simpleLineSymbolElement.getAntialiasing());
        this.setTransparency(simpleLineSymbolElement.getTransparency());
        Color color = simpleLineSymbolElement.getColor();
        if (color == null) {
            throw new IOException();
        }
        this.setLineColor(color);
        int n2 = SimpleLineSymbol.fromAxlLineType(simpleLineSymbolElement.getType());
        int n3 = simpleLineSymbolElement.getWidth();
        int n4 = SimpleLineSymbol.fromAxlCapType(simpleLineSymbolElement.getCapType());
        int n5 = SimpleLineSymbol.fromAxlJoinType(simpleLineSymbolElement.getJoinType());
        AoLineStroke aoLineStroke = new AoLineStroke(n2, (float)n3, n4, n5);
        this.setStroke(aoLineStroke);
        return;
    }

    public static final int fromAxlJoinType(String string) throws IOException {
        if (string == null || string.equals("round")) {
            return 1;
        }
        if (string.equals("miter")) {
            return 0;
        }
        if (string.equals("bevel")) {
            return 2;
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolFromAxlJoin", string));
    }

    public static final int fromAxlCapType(String string) throws IOException {
        if (string == null || string.equals("round")) {
            return 1;
        }
        if (string.equals("butt")) {
            return 0;
        }
        if (string.equals("square")) {
            return 2;
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolFromAxlCap", string));
    }

    public static final int fromAxlLineType(String string) throws IOException {
        if (string == null || string.equals("solid")) {
            return 0;
        }
        if (string.equals("dash")) {
            return 1;
        }
        if (string.equals("dot")) {
            return 2;
        }
        if (string.equals("dash_dot")) {
            return 3;
        }
        if (string.equals("dash_dot_dot")) {
            return 4;
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolFromAxlLine", string));
    }

    protected void simpleLineAttributes(SimpleLineSymbolElement simpleLineSymbolElement) throws IOException {
        if (simpleLineSymbolElement != null) {
            Stroke stroke = this.getStroke();
            if (stroke instanceof AoLineStroke) {
                String string;
                AoLineStroke aoLineStroke = (AoLineStroke)stroke;
                int n2 = (int)aoLineStroke.getLineWidth();
                if (n2 != 0) {
                    simpleLineSymbolElement.setWidth(n2);
                }
                if (aoLineStroke.getLineStyle() != 0) {
                    string = SimpleLineSymbol.toAxlLineType(aoLineStroke.getLineStyle());
                    simpleLineSymbolElement.setType(string);
                }
                if (aoLineStroke.getEndCap() != 0) {
                    string = SimpleLineSymbol.toAxlCapType(aoLineStroke.getEndCap());
                    simpleLineSymbolElement.setCapType(string);
                }
                if (aoLineStroke.getLineJoin() != 1) {
                    string = SimpleLineSymbol.toAxlJoinType(aoLineStroke.getLineJoin());
                    simpleLineSymbolElement.setJoinType(string);
                }
            } else {
                simpleLineSymbolElement.setType("solid");
                simpleLineSymbolElement.setWidth(1);
            }
            if (this.getLineColor() != DEFAULT_COLOR) {
                simpleLineSymbolElement.setColor(this.getLineColor());
            }
        }
        return;
    }

    public static final String toAxlJoinType(int n2) throws IOException {
        switch (n2) {
            case 1: {
                return "round";
            }
            case 0: {
                return "miter";
            }
            case 2: {
                return "bevel";
            }
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolToAxlJoin", String.valueOf(n2)));
    }

    public static final String toAxlCapType(int n2) throws IOException {
        switch (n2) {
            case 0: {
                return "butt";
            }
            case 1: {
                return "round";
            }
            case 2: {
                return "square";
            }
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolToAxlCap", String.valueOf(n2)));
    }

    public static final String toAxlLineType(int n2) throws IOException {
        switch (n2) {
            case 0: {
                return "solid";
            }
            case 1: {
                return "dash";
            }
            case 2: {
                return "dot";
            }
            case 3: {
                return "dash_dot";
            }
            case 4: {
                return "dash_dot_dot";
            }
        }
        throw new IOException(Resource.formatMessage1("SimpleLineSymbolToAxlLine", String.valueOf(n2)));
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        SimpleLineSymbolElement simpleLineSymbolElement = (SimpleLineSymbolElement)((Object)xmlDocument.createElement("SIMPLELINESYMBOL"));
        if (simpleLineSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getAntialiasing()) {
            simpleLineSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getTransparency() != 1.0) {
            simpleLineSymbolElement.setTransparency(this.getTransparency());
        }
        this.simpleLineAttributes(simpleLineSymbolElement);
        return simpleLineSymbolElement;
    }

    public Composite getComposite() {
        return this.c;
    }

    public void setComposite(Composite composite) {
        this.c = composite;
    }

    public Color getLineColor() {
        return this.d;
    }

    public void setLineColor(Color color) {
        this.d = color;
    }

    public Stroke getStroke() {
        return this.b;
    }

    public void setStroke(Stroke stroke) {
        this.b = stroke;
        this.a = true;
        return;
    }

    protected void line(Graphics2D graphics2D, Shape shape) {
        if (this.d != null) {
            graphics2D.setStroke(this.b);
            graphics2D.setColor(this.d);
            if (this.c != null) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(this.c);
                graphics2D.draw(shape);
                graphics2D.setComposite(composite);
            } else {
                graphics2D.draw(shape);
            }
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawFeature(Graphics2D var1_1, FeatureGeometry var2_2, AffineTransform var3_3) {
        var9_4 = -1;
        var4_5 = 0;
        {
            switch (var9_4) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var5_6 = var2_2.getGeometry(var4_5);
                    var6_7 = (Path)var5_6;
                    var7_8 = var6_7.getPoints();
                    var8_9 = com.esri.mo.map.draw.a.getPoints(var7_8.size());
                    var7_8.transform(var8_9.getX(), var8_9.getY(), var3_3);
                    var1_1.drawPolyline(var8_9.getX(), var8_9.getY(), var7_8.size());
                    ++var4_5;
                    case 0: {
                        var9_4 = -1;
                    }
                    break;
                }
            }
        }
        if (var4_5 < var2_2.size()) ** continue;
        return;
    }

    protected void line(Graphics2D graphics2D, FeatureGeometry featureGeometry, AffineTransform affineTransform) {
        if (this.d != null) {
            graphics2D.setStroke(this.b);
            graphics2D.setColor(this.d);
            if (this.c != null) {
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(this.c);
                this.drawFeature(graphics2D, featureGeometry, affineTransform);
                graphics2D.setComposite(composite);
            } else {
                this.drawFeature(graphics2D, featureGeometry, affineTransform);
            }
        }
        return;
    }

    public void draw(FeatureGeometry featureGeometry, Graphics2D graphics2D, Object object) {
        if (this.getAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
        AffineTransform affineTransform = this.switchTransform(graphics2D);
        if (this.a) {
            b b2 = com.esri.mo.map.draw.b.a(featureGeometry, affineTransform);
            this.line(graphics2D, b2);
        } else {
            try {
                featureGeometry.getGeometry(0);
                this.line(graphics2D, featureGeometry, affineTransform);
            }
            catch (Exception exception) {
                b b3 = com.esri.mo.map.draw.b.a(featureGeometry, affineTransform);
                this.line(graphics2D, b3);
            }
        }
        graphics2D.setTransform(affineTransform);
        return;
    }

    public SimpleLineSymbol() {
        this.d = Color.black;
    }
}

