/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.axl.map.RasterShieldSymbolElement;
import com.esri.mo.axl.map.Util;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Transform;
import com.esri.mo.map.draw.ArcFont;
import com.esri.mo.map.draw.BaseFontSymbol;
import com.esri.mo.map.draw.BaseTextSymbol;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.swing.JLabel;

public class RasterShieldSymbol
extends BaseTextSymbol {
    private Image g = null;
    private Image h = null;
    private String a = null;
    private String f = null;
    private boolean i = false;
    private int b = 0;
    private int c = 0;
    private int e = 1;
    private int d = 0;
    public static final boolean DEFAULT_BOUNDARY = false;
    public static final int DEFAULT_TEXTPOSITION_Y = 0;
    public static final int DEFAULT_TEXTPOSITION_X = 0;
    public static final int DEFAULT_LABELMODE = 1;
    public static final int DEFAULT_PRINTMODE = 0;
    public static final URL DEFAULT_IMAGEURL = null;

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof RasterShieldSymbolElement)) {
            throw new IllegalArgumentException();
        }
        RasterShieldSymbolElement rasterShieldSymbolElement = (RasterShieldSymbolElement)elementNode;
        this.setAntialiasing(rasterShieldSymbolElement.getAntialiasing());
        this.setTransparency(rasterShieldSymbolElement.getTransparency());
        this.setFont(new ArcFont(rasterShieldSymbolElement.getFont(), BaseFontSymbol.stringToIntStyle(rasterShieldSymbolElement.getFontStyle()), rasterShieldSymbolElement.getFontSize()));
        this.setColor(rasterShieldSymbolElement.getFontColor());
        this.setShadow(rasterShieldSymbolElement.getShadow());
        this.setPrintMode(BaseFontSymbol.stringToIntPrintMode(rasterShieldSymbolElement.getPrintMode()));
        this.setLabelMode(BaseFontSymbol.stringToIntLabelMode(rasterShieldSymbolElement.getLabelMode()));
        this.setTextPositionX(rasterShieldSymbolElement.getTextPositionX());
        this.setTextPositionY(rasterShieldSymbolElement.getTextPositionY());
        this.setBoundary(rasterShieldSymbolElement.getBoundary());
        if (!Util.isEmptyAttribute(rasterShieldSymbolElement.getUrlString())) {
            this.setUrlString(rasterShieldSymbolElement.getUrlString());
        }
        if (!Util.isEmptyAttribute(rasterShieldSymbolElement.getImageString())) {
            this.setImageString(rasterShieldSymbolElement.getImageString());
        }
        this.a();
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        RasterShieldSymbolElement rasterShieldSymbolElement = (RasterShieldSymbolElement)((Object)xmlDocument.createElement("RASTERSHIELDSYMBOL"));
        if (rasterShieldSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getTransparency() != 1.0) {
            rasterShieldSymbolElement.setTransparency(this.getTransparency());
        }
        if (this.getAntialiasing()) {
            rasterShieldSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getFont() != BaseFontSymbol.DEFAULT_FONT) {
            rasterShieldSymbolElement.setFont(this.getFont().getName());
            rasterShieldSymbolElement.setFontStyle(BaseFontSymbol.intToStringStyle(this.getFont().getStyle()));
            rasterShieldSymbolElement.setFontSize(this.getFont().getSize());
        }
        if (this.getColor() != BaseFontSymbol.DEFAULT_COLOR) {
            rasterShieldSymbolElement.setFontColor(this.getColor());
        }
        if (this.getShadow() != BaseFontSymbol.DEFAULT_SHADOW) {
            rasterShieldSymbolElement.setShadow(this.getShadow());
        }
        if (this.getPrintMode() != 0) {
            rasterShieldSymbolElement.setPrintMode(BaseFontSymbol.intToStringPrintMode(this.getPrintMode()));
        }
        if (this.getLabelMode() != 1) {
            rasterShieldSymbolElement.setLabelMode(BaseFontSymbol.intToStringLabelMode(this.getLabelMode()));
        }
        if (this.getTextPositionX() != 0 || this.getTextPositionY() != 0) {
            rasterShieldSymbolElement.setTextPosition(this.getTextPositionX() + "," + this.getTextPositionY());
        }
        if (this.getBoundary()) {
            rasterShieldSymbolElement.setBoundary(this.getBoundary());
        }
        if (this.getUrlString() != null) {
            rasterShieldSymbolElement.setUrlString(this.getUrlString());
        }
        if (this.getImageString() != null) {
            rasterShieldSymbolElement.setImageString(this.getImageString());
        }
        return rasterShieldSymbolElement;
    }

    public Image getImage() {
        return this.h;
    }

    public String getUrlString() {
        return this.a;
    }

    public void setUrlString(String string) {
        this.a = string;
        this.a();
        return;
    }

    public String getImageString() {
        return this.f;
    }

    public void setImageString(String string) {
        this.f = string;
        this.a();
        return;
    }

    public boolean getBoundary() {
        return this.i;
    }

    public void setBoundary(boolean bl) {
        this.i = bl;
    }

    public int getTextPositionY() {
        return this.b;
    }

    public void setTextPositionY(int n2) {
        this.b = n2;
    }

    public int getTextPositionX() {
        return this.c;
    }

    public void setTextPositionX(int n2) {
        this.c = n2;
    }

    public int getLabelMode() {
        return this.e;
    }

    public void setLabelMode(int n2) {
        this.e = n2;
    }

    public int getPrintMode() {
        return this.d;
    }

    public void setPrintMode(int n2) {
        this.d = n2;
    }

    public String getRotationalAnglesAsString() {
        return "0,0,0,0,0,0,0,0";
    }

    /*
     * Unable to fully structure code
     */
    public int[] getRotationalAngles() {
        var3_1 = -1;
        var1_2 = new int[8];
        var2_3 = 0;
        {
            switch (var3_1) {
                case 1: {
                    continue block6;
                }
                while (true) {
                    var1_2[var2_3] = 0;
                    ++var2_3;
                    case 0: {
                        var3_1 = -1;
                    }
                    break;
                }
            }
        }
        if (var2_3 < 8) ** continue;
        return var1_2;
    }

    private void a() {
        Image image;
        MediaTracker mediaTracker = new MediaTracker(new JLabel());
        if (this.a != null) {
            try {
                image = Toolkit.getDefaultToolkit().getImage(new URL(this.a));
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                if (!mediaTracker.isErrorID(0)) {
                    int n2 = image.getWidth(null);
                    int n3 = image.getHeight(null);
                    BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    this.h = this.filterTransparentImage(bufferedImage);
                    this.g = this.filterShadowImage(this.h);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.f != null) {
            try {
                image = Toolkit.getDefaultToolkit().getImage(this.f);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                if (!mediaTracker.isErrorID(0)) {
                    int n4 = image.getWidth(null);
                    int n5 = image.getHeight(null);
                    BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    this.h = this.filterTransparentImage(bufferedImage);
                    this.g = this.filterShadowImage(this.h);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("Warning: RasterShieldSymbol can't load image. image=" + this.f + " " + "url=" + this.a);
        return;
    }

    public void draw(String string, double d2, double d3, double d4, Graphics2D graphics2D, FeatureGeometry featureGeometry) {
        graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
        if (this.getAntialiasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        Point2D.Double double_ = new Point2D.Double();
        affineTransform.transform(new Point2D.Double(d2, d3), double_);
        graphics2D.setTransform(new AffineTransform());
        graphics2D.translate(double_.x, double_.y);
        int n2 = this.h.getWidth(null) / 2;
        int n3 = this.h.getHeight(null) / 2;
        if (this.getShadow() != null && this.g != null) {
            graphics2D.drawImage(this.g, -n2 + 5, -n3 + 4, null);
        }
        if (this.h != null) {
            graphics2D.drawImage(this.h, -n2, -n3, null);
        }
        graphics2D.setTransform(affineTransform);
        this.drawTextWithEffect(graphics2D, string, d2, d3, 0.0, this.getFont(), this.getColor(), null, null, null, null, true);
        graphics2D.setTransform(affineTransform);
        return;
    }

    public void prepare(String string, FeatureGeometry featureGeometry, Transform transform) {
        String string2 = BaseFontSymbol.stringToNewMode(string, this.d, this.e);
        if (string2.length() != 0 && this.h != null) {
            int n2 = 2 * this.h.getWidth(null);
            int n3 = 2 * this.h.getHeight(null);
            Dimension dimension = new Dimension(n2, n3);
            this.getRenderer().getLayer().getLayerset().getDisplayManager().getLabelEngine().add(dimension, featureGeometry, this, string2);
        }
        return;
    }
}

