/*
 * Decompiled with CFR 0.152.
 */
package com.esri.mo.map.draw;

import com.esri.mo.axl.map.CalloutMarkerSymbolElement;
import com.esri.mo.axl.map.IncompleteDictionaryException;
import com.esri.mo.cs.geom.FeatureGeometry;
import com.esri.mo.cs.geom.Point;
import com.esri.mo.cs.geom.Transform;
import com.esri.mo.map.draw.ArcFont;
import com.esri.mo.map.draw.BaseFontSymbol;
import com.esri.mo.map.draw.BaseTextSymbol;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;

public class CalloutMarkerSymbol
extends BaseTextSymbol {
    private Color b;
    private double a = 0.0;
    private Color c = DEFAULT_BACKCOLOR;
    public static final Color DEFAULT_BOUNDARYCOLOR;
    public static final double DEFAULT_INTERVAL = 0.0;
    public static final Color DEFAULT_BACKCOLOR;

    static {
        DEFAULT_BACKCOLOR = Color.white;
        DEFAULT_BOUNDARYCOLOR = Color.black;
    }

    public void fromAXL(ElementNode elementNode) throws IOException {
        if (!(elementNode instanceof CalloutMarkerSymbolElement)) {
            throw new IllegalArgumentException();
        }
        CalloutMarkerSymbolElement calloutMarkerSymbolElement = (CalloutMarkerSymbolElement)elementNode;
        this.setTransparency(calloutMarkerSymbolElement.getTransparency());
        this.setAntialiasing(calloutMarkerSymbolElement.getAntialiasing());
        this.setFont(new ArcFont(calloutMarkerSymbolElement.getFont(), BaseFontSymbol.stringToIntStyle(calloutMarkerSymbolElement.getFontStyle()), calloutMarkerSymbolElement.getFontSize()));
        this.setColor(calloutMarkerSymbolElement.getFontColor());
        this.setOutline(calloutMarkerSymbolElement.getOutline());
        this.setGlowing(calloutMarkerSymbolElement.getGlowing());
        this.setShadow(calloutMarkerSymbolElement.getShadow());
        this.setBackColor(calloutMarkerSymbolElement.getBackColor());
        this.setInterval(calloutMarkerSymbolElement.getInterval());
        this.setBoundaryColor(calloutMarkerSymbolElement.getBoundaryColor());
        return;
    }

    public ElementNode toAXL(XmlDocument xmlDocument) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException();
        }
        CalloutMarkerSymbolElement calloutMarkerSymbolElement = (CalloutMarkerSymbolElement)((Object)xmlDocument.createElement("CALLOUTMARKERSYMBOL"));
        if (calloutMarkerSymbolElement == null) {
            throw new IncompleteDictionaryException();
        }
        if (this.getTransparency() != 1.0) {
            calloutMarkerSymbolElement.setTransparency(this.getTransparency());
        }
        if (this.getAntialiasing()) {
            calloutMarkerSymbolElement.setAntialiasing(this.getAntialiasing());
        }
        if (this.getFont() != BaseFontSymbol.DEFAULT_FONT) {
            calloutMarkerSymbolElement.setFont(this.getFont().getName());
            calloutMarkerSymbolElement.setFontStyle(BaseFontSymbol.intToStringStyle(this.getFont().getStyle()));
            calloutMarkerSymbolElement.setFontSize(this.getFont().getSize());
        }
        if (this.getColor() != BaseFontSymbol.DEFAULT_COLOR) {
            calloutMarkerSymbolElement.setFontColor(this.getColor());
        }
        if (this.getOutline() != BaseFontSymbol.DEFAULT_OUTLINE) {
            calloutMarkerSymbolElement.setOutline(this.getOutline());
        }
        if (this.getGlowing() != BaseFontSymbol.DEFAULT_GLOWING) {
            calloutMarkerSymbolElement.setGlowing(this.getGlowing());
        }
        if (this.getShadow() != BaseFontSymbol.DEFAULT_SHADOW) {
            calloutMarkerSymbolElement.setShadow(this.getShadow());
        }
        if (this.getBackColor() != DEFAULT_BACKCOLOR) {
            calloutMarkerSymbolElement.setBackColor(this.getBackColor());
        }
        if (this.getInterval() != 0.0) {
            calloutMarkerSymbolElement.setInterval((int)this.getInterval());
        }
        if (this.getBoundaryColor() != DEFAULT_BOUNDARYCOLOR) {
            calloutMarkerSymbolElement.setBoundaryColor(this.getBoundaryColor());
        }
        return calloutMarkerSymbolElement;
    }

    public Color getBoundaryColor() {
        return this.b;
    }

    public void setBoundaryColor(Color color) {
        this.b = color;
    }

    public double getInterval() {
        return this.a;
    }

    public void setInterval(double d2) {
        this.a = d2;
    }

    public Color getBackColor() {
        return this.c;
    }

    public void setBackColor(Color color) {
        this.c = color;
    }

    private int a(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d4 + d2) / 2.0;
        double d9 = (d5 + d3) / 2.0;
        double d10 = Math.atan2(d5 - d3, d4 - d2);
        double d11 = Math.abs(d8 - d6);
        double d12 = Math.abs(d9 - d7);
        double d13 = Math.atan2(d12, d11);
        if (d6 <= d8 && d7 >= d9) {
            if (d13 >= d10) {
                return 2;
            }
            return 1;
        }
        if (d6 > d8 && d7 > d9) {
            if (d13 >= d10) {
                return 3;
            }
            return 4;
        }
        if (d6 >= d8 && d7 <= d9) {
            if (d13 >= d10) {
                return 6;
            }
            return 5;
        }
        if (d6 < d8 && d7 < d9) {
            if (d13 >= d10) {
                return 7;
            }
            return 8;
        }
        return -1;
    }

    private Shape a(int n2, float f2, float f3, float f4, float f5, float f6, float f7) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f6, f7);
        float f8 = f4 - f2;
        float f9 = f5 - f3;
        float f10 = f8 * 0.2f;
        float f11 = f9 * 0.2f;
        float f12 = f8 * 0.2f;
        float f13 = f9 * 0.2f;
        switch (n2) {
            case 1: {
                generalPath.lineTo(f2, f5 - f11);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5 - f11 - f13);
                break;
            }
            case 2: {
                generalPath.lineTo(f2 + f10 + f12, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f2 + f10, f5);
                break;
            }
            case 3: {
                generalPath.lineTo(f4 - f10, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4 - f10 - f12, f5);
                break;
            }
            case 4: {
                generalPath.lineTo(f4, f5 - f11 - f13);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f5 - f11);
                break;
            }
            case 5: {
                generalPath.lineTo(f4, f3 + f11);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3 + f11 + f13);
                break;
            }
            case 6: {
                generalPath.lineTo(f4 - f10 - f12, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f4 - f10, f3);
                break;
            }
            case 7: {
                generalPath.lineTo(f2 + f10, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2 + f10 + f12, f3);
                break;
            }
            case 8: {
                generalPath.lineTo(f2, f3 + f11 + f13);
                generalPath.lineTo(f2, f5);
                generalPath.lineTo(f4, f5);
                generalPath.lineTo(f4, f3);
                generalPath.lineTo(f2, f3);
                generalPath.lineTo(f2, f3 + f11);
            }
        }
        generalPath.lineTo(f6, f7);
        return generalPath;
    }

    public void draw(String string, double d2, double d3, double d4, Graphics2D graphics2D, FeatureGeometry featureGeometry) {
        if (string != null && featureGeometry instanceof Point) {
            double d5 = ((Point2D.Double)((Object)featureGeometry)).x;
            double d6 = ((Point2D.Double)((Object)featureGeometry)).y;
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
            if (this.getAntialiasing()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            Dimension dimension = this.getSizeTextWithEffect(string);
            double d7 = dimension.getWidth() / 2.0;
            double d8 = dimension.getHeight() / 2.0;
            AffineTransform affineTransform = graphics2D.getTransform();
            Point2D.Double double_ = new Point2D.Double();
            affineTransform.transform(new Point2D.Double(d2, d3), double_);
            double d9 = double_.x - d7;
            double d10 = double_.y - d8;
            double d11 = double_.x + d7;
            double d12 = double_.y + d8;
            affineTransform.transform(new Point2D.Double(d5, d6), double_);
            double d13 = double_.x;
            double d14 = double_.y;
            graphics2D.setTransform(new AffineTransform());
            int n2 = this.a(d9, d10, d11, d12, d13, d14);
            if (n2 > 0) {
                if (this.getShadow() != null) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                    graphics2D.setColor(this.getShadow());
                    graphics2D.fill(this.a(n2, (float)(d9 + 5.0), (float)(d10 + 4.0), (float)(d11 + 5.0), (float)(d12 + 4.0), (float)d13, (float)d14));
                    graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.getTransparency()));
                }
                Shape shape = this.a(n2, (float)d9, (float)d10, (float)d11, (float)d12, (float)d13, (float)d14);
                if (this.getBackColor() != null) {
                    graphics2D.setColor(this.getBackColor());
                    graphics2D.fill(shape);
                }
                graphics2D.setColor(this.getBoundaryColor());
                graphics2D.draw(shape);
            }
            graphics2D.setTransform(affineTransform);
            this.drawTextWithEffect(graphics2D, string, d2, d3, 0.0, this.getFont(), this.getColor(), null, this.getOutline(), null, this.getGlowing(), false);
            graphics2D.setComposite(AlphaComposite.SrcOver);
        }
        return;
    }

    public void prepare(String string, FeatureGeometry featureGeometry, Transform transform) {
        if (string.length() != 0) {
            Dimension dimension = this.getSizeTextWithEffect(string);
            double d2 = dimension.getWidth() + this.a * 2.0;
            double d3 = dimension.getHeight() + this.a * 2.0;
            Dimension dimension2 = new Dimension((int)d2, (int)d3);
            this.getRenderer().getLayer().getLayerset().getDisplayManager().getLabelEngine().add(dimension2, featureGeometry, this, string);
        }
        return;
    }

    public CalloutMarkerSymbol() {
        this.b = DEFAULT_BOUNDARYCOLOR;
    }
}

